/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.io.pipelib;

import com.zeitheron.hammercore.lib.zlib.io.pipelib.FlowSide;
import com.zeitheron.hammercore.lib.zlib.io.pipelib.IFlowListener;
import com.zeitheron.hammercore.lib.zlib.io.pipelib.PipeFlow;
import com.zeitheron.hammercore.lib.zlib.weupnp.AttuneResult;
import com.zeitheron.hammercore.lib.zlib.weupnp.EnumProtocol;
import com.zeitheron.hammercore.lib.zlib.weupnp.WeUPnP;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class PipeServer
implements AutoCloseable,
Closeable {
    private static WeUPnP upnp = new WeUPnP();
    public List<IFlowListener> listeners;
    private boolean prepared;
    private boolean started;
    private boolean closed;
    private ServerSocket server;
    private AttuneResult res;
    private int port;
    private String channel;

    public PipeServer() {
        if (PipeFlow.ACCEPTOR.get() != null) {
            throw new RuntimeException("This thread already flows to " + PipeFlow.ACCEPTOR.get().name().toLowerCase() + "!");
        }
        PipeFlow.ACCEPTOR.set(FlowSide.SERVER);
        this.listeners = new ArrayList<IFlowListener>();
        this.prepared = false;
        this.started = true;
        this.closed = false;
        upnp.setup();
        try {
            upnp.discover();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public List<IFlowListener> getListeners() {
        return this.listeners;
    }

    public void addListener(IFlowListener l) {
        this.listeners.add(l);
    }

    public String getChannel() {
        return this.channel;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public boolean isStarted() {
        return this.started;
    }

    public PipeServer prepare() {
        if (this.prepared) {
            throw new IllegalStateException("Cannot prepare prepared pipe server!");
        }
        try {
            this.res = upnp.attune(EnumProtocol.TCP, this.port, this.port, "Endie's PipeLib Server");
        }
        catch (IOException | SAXException e1) {
            e1.printStackTrace();
        }
        try {
            this.server = new ServerSocket(this.port, 150);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to prepare pipe server!", e);
        }
        this.prepared = true;
        return this;
    }

    public void start() {
        if (!this.prepared) {
            throw new IllegalStateException("Cannot start unprepared pipe server!");
        }
        this.started = true;
        try {
            this.server.setSoTimeout(1000);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        while (!this.closed) {
            try {
                this.process(this.server.accept());
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Pipe server closed.");
    }

    private void process(Socket s) throws IOException {
        DataInputStream i = new DataInputStream(s.getInputStream());
        DataOutputStream o = new DataOutputStream(s.getOutputStream());
        int heap = i.readInt();
        if (heap > 1000000) {
            return;
        }
        byte[] data = new byte[heap];
        i.read(data);
        PipeFlow flow = new PipeFlow().deserialize(data);
        if (flow == null || flow.event != null && flow.event.equals("Channel")) {
            short f;
            String rem = new String(flow.data);
            if (flow == null || !rem.equals(this.getChannel())) {
                o.writeBoolean(false);
                o.flush();
                i.close();
                o.close();
                s.close();
                return;
            }
            o.writeBoolean(true);
            o.flush();
            ArrayList<PipeFlow> ps = new ArrayList<PipeFlow>();
            short packets = i.readShort();
            for (f = 0; f < packets; f = (short)(f + 1)) {
                data = new byte[i.readInt()];
                i.read(data);
                ps.addAll(new PipeFlow().deserialize(data).perform(this.getListeners()));
            }
            o.writeShort(ps.size());
            for (f = 0; f < ps.size(); f = (short)(f + 1)) {
                PipeFlow p = (PipeFlow)ps.get(f);
                data = p.serialize();
                o.writeInt(data.length);
                o.write(data);
            }
            o.flush();
            i.close();
            o.close();
            s.close();
        }
    }

    public PipeServer link(String channel, int port) {
        return this.link(channel).link(port);
    }

    public PipeServer link(int port) {
        if (this.prepared) {
            throw new IllegalStateException("Cannot set endpoint port to prepared pipe server!");
        }
        this.port = port;
        return this;
    }

    public PipeServer link(String channel) {
        if (this.prepared) {
            throw new IllegalStateException("Cannot set channel to prepared pipe server!");
        }
        this.channel = channel;
        return this;
    }

    @Override
    public void close() {
        if (!this.prepared) {
            throw new IllegalStateException("Cannot close unprepared pipe server!");
        }
        PipeFlow.ACCEPTOR.set(null);
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.res != null) {
            try {
                this.res.undo();
            }
            catch (IOException | SAXException e) {
                e.printStackTrace();
            }
        }
    }
}

