/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.proxy;

import com.google.common.base.Predicates;
import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.api.IProcess;
import com.zeitheron.hammercore.api.lighting.ColoredLightManager;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import com.zeitheron.hammercore.client.particle.api.ParticleList;
import com.zeitheron.hammercore.client.particle.def.ParticleSlowZap;
import com.zeitheron.hammercore.client.particle.def.ParticleZap;
import com.zeitheron.hammercore.client.particle.def.thunder.ThunderHelper;
import com.zeitheron.hammercore.client.utils.OpnodeLoader;
import com.zeitheron.hammercore.net.internal.thunder.Thunder;
import com.zeitheron.hammercore.proxy.ParticleProxy_Common;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ParticleProxy_Client
extends ParticleProxy_Common {
    private static final List<Particle> particleQueue = new ArrayList<Particle>();
    public static final List<IProcess> updatables = new ArrayList<IProcess>(16);

    public ParticleProxy_Client() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        HammerCore.LOG.info("Added particle lighting supplier");
        ColoredLightManager.addGenerator(partialTime -> ParticleList.getParticlesList().stream().filter(Predicates.instanceOf(IGlowingEntity.class)).map(p -> (IGlowingEntity)p).map(e -> e.produceColoredLight(partialTime.floatValue())));
    }

    public static void queueParticleSpawn(Particle particle) {
        particleQueue.add(particle);
    }

    @Override
    public void spawnZap(World w, Vec3d start, Vec3d end, int rgb) {
        if (!w.field_72995_K) {
            super.spawnZap(w, start, end, rgb);
            return;
        }
        ParticleZap zap = new ParticleZap(w, start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c, (float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb >> 0 & 0xFF) / 255.0f);
        zap.spawn();
    }

    @Override
    public void spawnZap(int w, Vec3d start, Vec3d end, int rgb) {
        ParticleZap zap = null;
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == w) {
            zap = new ParticleZap((World)Minecraft.func_71410_x().field_71441_e, start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c, (float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb >> 0 & 0xFF) / 255.0f);
            zap.spawn();
        }
    }

    @Override
    public void spawnSlowZap(World w, Vec3d start, Vec3d end, int rgb, int maxTicks, float ampl) {
        if (!w.field_72995_K) {
            super.spawnSlowZap(w, start, end, rgb, maxTicks, ampl);
            return;
        }
        ParticleSlowZap zap = new ParticleSlowZap(w, maxTicks, ampl, start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c, (float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb >> 0 & 0xFF) / 255.0f);
        zap.spawn();
    }

    @Override
    public void spawnSlowZap(int w, Vec3d start, Vec3d end, int rgb, int maxTicks, float ampl) {
        ParticleSlowZap zap = null;
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == w) {
            zap = new ParticleSlowZap((World)Minecraft.func_71410_x().field_71441_e, maxTicks, ampl, start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c, (float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb >> 0 & 0xFF) / 255.0f);
            zap.spawn();
        }
    }

    @Override
    public void spawnSimpleThunder(World world, Vec3d start, Vec3d end, long seed, int age, float fractMod, Thunder.Layer core, Thunder.Layer aura) {
        if (world.field_72995_K) {
            ThunderHelper.thunder(world, start, end, new Thunder(seed, age, fractMod), core, aura, Thunder.Fractal.DEFAULT_FRACTAL);
        } else {
            super.spawnSimpleThunder(world, start, end, seed, age, fractMod, core, aura);
        }
    }

    @Override
    public void startProcess(IProcess proc) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            if (proc != null && !updatables.contains(proc)) {
                updatables.add(proc);
            }
        } else {
            super.startProcess(proc);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        while (!particleQueue.isEmpty()) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particleQueue.remove(0));
        }
        ParticleList.refreshParticles();
        for (int i = 0; i < updatables.size(); ++i) {
            try {
                IProcess upd = updatables.get(i);
                upd.update();
                if (upd.isAlive()) continue;
                upd.onKill();
                updatables.remove(i);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static double getParticleMotionX(Particle part) {
        return part.field_187129_i;
    }

    public static double getParticleMotionY(Particle part) {
        return part.field_187130_j;
    }

    public static double getParticleMotionZ(Particle part) {
        return part.field_187131_k;
    }

    public static double getParticlePosX(Particle part) {
        return part.field_187126_f;
    }

    public static double getParticlePosY(Particle part) {
        return part.field_187127_g;
    }

    public static double getParticlePosZ(Particle part) {
        return part.field_187128_h;
    }

    public static void setParticleMotionX(Particle part, double d) {
        part.field_187129_i = d;
    }

    public static void setParticleMotionY(Particle part, double d) {
        part.field_187130_j = d;
    }

    public static void setParticleMotionZ(Particle part, double d) {
        part.field_187131_k = d;
    }

    public static void setParticlePosX(Particle part, double d) {
        part.field_187126_f = d;
    }

    public static void setParticlePosY(Particle part, double d) {
        part.field_187127_g = d;
    }

    public static void setParticlePosZ(Particle part, double d) {
        part.field_187128_h = d;
    }

    @SubscribeEvent
    public void reloadTextures(TextureStitchEvent evt) {
        OpnodeLoader.reloadModels();
    }
}

