/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.zeitheron.hammercore.utils.NumberUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.lang3.ArrayUtils;

public class NBTUtils {
    public static void writeNumberToNBT(String key, NBTTagCompound nbt, Number number) {
        NumberUtils.EnumNumberType type = NumberUtils.getType(number);
        if (type != null && type != NumberUtils.EnumNumberType.UNDEFINED) {
            nbt.func_74773_a(key, NumberUtils.asBytes(number));
        }
    }

    public static Number readNumberFromNBT(String key, NBTTagCompound nbt) {
        return NumberUtils.fromBytes(nbt.func_74770_j(key));
    }

    public static void writeStringArrayToNBT(String key, NBTTagCompound nbt, String ... $) {
        nbt.func_74768_a(key + "Length", $.length);
        for (int i = 0; i < $.length; ++i) {
            nbt.func_74778_a(key + i, $[i]);
        }
    }

    public static String[] readStringArrayFromNBT(String key, NBTTagCompound nbt) {
        String[] $ = new String[nbt.func_74762_e(key + "Length")];
        for (int i = 0; i < $.length; ++i) {
            $[i] = nbt.func_74779_i(key + i);
        }
        return $;
    }

    public static void writeUUIDArrayToNBT(String key, NBTTagCompound nbt, UUID ... $) {
        nbt.func_74768_a(key + "Length", $.length);
        for (int i = 0; i < $.length; ++i) {
            nbt.func_186854_a(key + i, $[i]);
        }
    }

    public static UUID[] readUUIDArrayFromNBT(String key, NBTTagCompound nbt) {
        UUID[] $ = new UUID[nbt.func_74762_e(key + "Length")];
        for (int i = 0; i < $.length; ++i) {
            $[i] = nbt.func_186857_a(key + i);
        }
        return $;
    }

    public static List<String> readStringListFromNBT(NBTTagCompound nbt, String key) {
        ArrayList<String> list = new ArrayList<String>();
        NBTTagList tl = nbt.func_150295_c(key, 8);
        for (int i = 0; i < tl.func_74745_c(); ++i) {
            list.add(tl.func_150307_f(i));
        }
        return list;
    }

    public static NBTTagCompound writeStringListToNBT(NBTTagCompound nbt, String key, List<String> list) {
        NBTTagList tl = new NBTTagList();
        for (int i = 0; i < list.size(); ++i) {
            tl.func_74742_a((NBTBase)new NBTTagString(list.get(i)));
        }
        nbt.func_74782_a(key, (NBTBase)tl);
        return nbt;
    }

    public static void removeTagFromItemStack(ItemStack stack, String tag) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(tag);
            if (stack.func_77978_p().func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }

    public static int[] toIA(NBTTagCompound comp) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)comp, (DataOutput)new DataOutputStream(baos));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] data = baos.toByteArray();
        while (data.length % 4 != 0) {
            data = ArrayUtils.add((byte[])data, (byte)0);
        }
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        int[] ret = new int[data.length / 4];
        buffer.asIntBuffer().get(ret);
        return ret;
    }

    public static NBTTagCompound toNBT(int[] ia) {
        ByteBuffer buffer = ByteBuffer.allocate(ia.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.asIntBuffer().put(ia);
        buffer.flip();
        byte[] data = buffer.array();
        try {
            return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new ByteArrayInputStream(data)));
        }
        catch (IOException e) {
            return new NBTTagCompound();
        }
    }
}

