/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class VecDir {
    public final Vec3d start;
    public final Vec3d direction;
    public final double distance;

    public VecDir(Vec3d start, Vec3d direction, double distance) {
        this.start = start;
        this.distance = distance;
        this.direction = direction;
    }

    public VecDir(Vec3d start, float pitch, float yaw, double distance) {
        this.start = start;
        this.distance = distance;
        this.direction = Vec3d.func_189986_a((float)pitch, (float)yaw);
    }

    public Vec3d calcEndVec() {
        return this.start.func_178787_e(this.direction.func_186678_a(this.distance));
    }

    public <T extends Entity> List<? extends T> getEntitiesWithinDir(World world, Class<? extends T> ent) {
        Vec3d end = this.calcEndVec();
        AxisAlignedBB aabb = new AxisAlignedBB(this.start.field_72450_a, this.start.field_72448_b, this.start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c).func_72321_a(0.5, 0.5, 0.5);
        return world.func_175647_a(ent, aabb, e -> e.func_174813_aQ().func_72327_a(this.start, end) != null);
    }

    public <T extends Entity> List<? extends T> getEntitiesWithinDir(World world, Class<? extends T> ent, Predicate<T> pred) {
        Vec3d end = this.calcEndVec();
        AxisAlignedBB aabb = new AxisAlignedBB(this.start.field_72450_a, this.start.field_72448_b, this.start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c).func_72321_a(0.5, 0.5, 0.5);
        return world.func_175647_a(ent, aabb, e -> e.func_174813_aQ().func_72327_a(this.start, end) != null && pred.test(e));
    }

    public <T extends Entity> T getClosestEntityWithinDir(World world, Class<? extends T> ent) {
        List<T> ts = this.getEntitiesWithinDir(world, ent);
        double min = Double.POSITIVE_INFINITY;
        double curr = 0.0;
        Entity last = null;
        for (Entity t : ts) {
            double d;
            curr = t.func_70092_e(this.start.field_72450_a, this.start.field_72448_b, this.start.field_72449_c);
            if (!(d < min) || (last = t) == null) continue;
            min = curr;
        }
        return (T)last;
    }

    public <T extends Entity> T getClosestEntityWithinDir(World world, Class<? extends T> ent, Predicate<T> pred) {
        List<T> ts = this.getEntitiesWithinDir(world, ent, pred);
        double min = Double.POSITIVE_INFINITY;
        double curr = 0.0;
        Entity last = null;
        for (Entity t : ts) {
            double d;
            curr = t.func_70092_e(this.start.field_72450_a, this.start.field_72448_b, this.start.field_72449_c);
            if (!(d < min) || (last = t) == null) continue;
            min = curr;
        }
        return (T)last;
    }

    public VecDir calcFromDistanceTillEnd(double distance) {
        Vec3d start = this.start.func_178787_e(this.direction.func_186678_a(distance));
        double nd = this.distance - distance;
        return new VecDir(start, this.direction, nd);
    }

    public VecDir calcFromProgressTillEnd(double progress) {
        return this.calcFromDistanceTillEnd(this.distance * progress);
    }

    public VecDir redirect(double from, float pitch, float yaw, double distance) {
        return new VecDir(this.start.func_178787_e(this.direction.func_186678_a(from)), pitch, yaw, distance);
    }

    public VecDir cutTill(Entity ent) {
        RayTraceResult res = ent.func_174813_aQ().func_72327_a(this.start, this.calcEndVec());
        if (res != null && res.field_72307_f != null) {
            return new VecDir(this.start, this.direction, res.field_72307_f.func_72438_d(this.start));
        }
        return this;
    }
}

