/*
 * Decompiled with CFR 0.152.
 */
package com.blackout.extendedslabs;

import com.blackout.extendedslabs.datagen.ESPBlockModelProvider;
import com.blackout.extendedslabs.datagen.ESPBlockStateProvider;
import com.blackout.extendedslabs.datagen.ESPBlockTagsProvider;
import com.blackout.extendedslabs.datagen.ESPCornerRecipeProvider;
import com.blackout.extendedslabs.datagen.ESPItemModelGenerator;
import com.blackout.extendedslabs.datagen.ESPLootTableProvider;
import com.blackout.extendedslabs.datagen.ESPSlabRecipeProvider;
import com.blackout.extendedslabs.datagen.ESPStairRecipeProvider;
import com.blackout.extendedslabs.datagen.ESPVerticalSlabRecipeProvider;
import com.blackout.extendedslabs.init.ESPCorners;
import com.blackout.extendedslabs.init.ESPSlabs;
import com.blackout.extendedslabs.init.ESPStairs;
import com.blackout.extendedslabs.init.ESPVerticalSlabs;
import com.blackout.extendedslabs.init.modded.BOPCorners;
import com.blackout.extendedslabs.init.modded.BOPVerticalSlabs;
import com.blackout.extendedslabs.render.block.BlockRenderLayer;
import com.blackout.extendedslabs.util.CreativeTab;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="extendedslabs")
public class ExtendedSlabs {
    public static final String MODID = "extendedslabs";
    public static final String MODNAME = "Extended Slabs";
    public static final String VERSION = "2.0.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"extendedslabs");
    public static final ItemGroup GROUP = new CreativeTab();

    public ExtendedSlabs() {
        LOGGER.debug("Extended Slabs Version is:2.0.0");
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::gatherData);
        ESPSlabs.ITEMS.register(eventBus);
        ESPSlabs.BLOCKS.register(eventBus);
        ESPStairs.ITEMS.register(eventBus);
        ESPStairs.BLOCKS.register(eventBus);
        ESPCorners.ITEMS.register(eventBus);
        ESPCorners.BLOCKS.register(eventBus);
        ESPVerticalSlabs.ITEMS.register(eventBus);
        ESPVerticalSlabs.BLOCKS.register(eventBus);
        if (ModList.get().isLoaded("biomesoplenty")) {
            BOPCorners.ITEMS.register(eventBus);
            BOPCorners.BLOCKS.register(eventBus);
            BOPVerticalSlabs.ITEMS.register(eventBus);
            BOPVerticalSlabs.BLOCKS.register(eventBus);
            LOGGER.debug("extendedslabs: Biomes O' Plenty Compat Loaded");
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        ExistingFileHelper existing = event.getExistingFileHelper();
        if (event.includeServer()) {
            dataGenerator.func_200390_a((IDataProvider)new ESPLootTableProvider(dataGenerator));
            dataGenerator.func_200390_a((IDataProvider)new ESPBlockModelProvider(dataGenerator, MODID, existing));
            dataGenerator.func_200390_a((IDataProvider)new ESPItemModelGenerator(dataGenerator, existing));
            dataGenerator.func_200390_a((IDataProvider)new ESPBlockStateProvider(dataGenerator, MODID, existing));
            dataGenerator.func_200390_a((IDataProvider)new ESPBlockTagsProvider(dataGenerator, existing));
            dataGenerator.func_200390_a((IDataProvider)new ESPStairRecipeProvider(dataGenerator));
            dataGenerator.func_200390_a((IDataProvider)new ESPCornerRecipeProvider(dataGenerator));
            dataGenerator.func_200390_a((IDataProvider)new ESPSlabRecipeProvider(dataGenerator));
            dataGenerator.func_200390_a((IDataProvider)new ESPVerticalSlabRecipeProvider(dataGenerator));
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        BlockRenderLayer.renderBlock();
        LOGGER.info("renderBlock");
    }
}

