/*
 * Decompiled with CFR 0.152.
 */
package com.blackout.extendedslabs.blocks;

import com.blackout.extendedslabs.blocks.falling.FallingVerticalSlabBlock;
import com.blackout.extendedslabs.blocks.path.PathVerticalSlabBlock;
import com.blackout.extendedslabs.blocks.shapes.VerticalSlabShape;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class VerticalSlabBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<VerticalSlabShape> SHAPE = EnumProperty.func_177709_a((String)"shape", VerticalSlabShape.class);
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)0.0, (double)8.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)8.0, (double)16.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)16.0, (double)16.0, (double)16.0, (double)0.0, (double)8.0);
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)0.0, (double)16.0, (double)0.0, (double)8.0, (double)0.0, (double)16.0);
    protected static final VoxelShape NORTH_OUTER_SHAPE = Block.func_208617_a((double)0.0, (double)16.0, (double)0.0, (double)8.0, (double)0.0, (double)8.0);
    protected static final VoxelShape EAST_OUTER_SHAPE = Block.func_208617_a((double)8.0, (double)16.0, (double)0.0, (double)16.0, (double)0.0, (double)8.0);
    protected static final VoxelShape SOUTH_OUTER_SHAPE = Block.func_208617_a((double)8.0, (double)16.0, (double)16.0, (double)16.0, (double)0.0, (double)8.0);
    protected static final VoxelShape WEST_OUTER_SHAPE = Block.func_208617_a((double)0.0, (double)16.0, (double)8.0, (double)8.0, (double)0.0, (double)16.0);

    public VerticalSlabBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)((Object)VerticalSlabShape.STRAIGHT))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VerticalSlabShape verticalslabshape = (VerticalSlabShape)((Object)state.func_177229_b(SHAPE));
        Direction enumfacing = (Direction)state.func_177229_b((Property)FACING);
        if (verticalslabshape != VerticalSlabShape.STRAIGHT) {
            switch (verticalslabshape) {
                case OUTER_LEFT: {
                    return VerticalSlabBlock.getOuterLeftFacingShapes(enumfacing);
                }
                case OUTER_RIGHT: {
                    return VerticalSlabBlock.getOuterRightFacingShapes(enumfacing);
                }
                case INNER_LEFT: {
                    return VerticalSlabBlock.getInnerLeftFacingShapes(enumfacing);
                }
                case INNER_RIGHT: {
                    return VerticalSlabBlock.getInnerRightFacingShapes(enumfacing);
                }
            }
            return VerticalSlabBlock.getStraightFacingShapes(enumfacing);
        }
        return VerticalSlabBlock.getStraightFacingShapes(enumfacing);
    }

    private static VoxelShape getStraightFacingShapes(Direction facing) {
        switch (facing) {
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    private static VoxelShape getOuterLeftFacingShapes(Direction facing) {
        switch (facing) {
            case WEST: {
                return WEST_OUTER_SHAPE;
            }
            case EAST: {
                return EAST_OUTER_SHAPE;
            }
            case SOUTH: {
                return SOUTH_OUTER_SHAPE;
            }
        }
        return NORTH_OUTER_SHAPE;
    }

    private static VoxelShape getInnerLeftFacingShapes(Direction facing) {
        switch (facing) {
            case WEST: {
                return VoxelShapes.func_197872_a((VoxelShape)WEST_SHAPE, (VoxelShape)SOUTH_SHAPE);
            }
            case EAST: {
                return VoxelShapes.func_197872_a((VoxelShape)EAST_SHAPE, (VoxelShape)NORTH_SHAPE);
            }
            case SOUTH: {
                return VoxelShapes.func_197872_a((VoxelShape)SOUTH_SHAPE, (VoxelShape)EAST_SHAPE);
            }
        }
        return VoxelShapes.func_197872_a((VoxelShape)NORTH_SHAPE, (VoxelShape)WEST_SHAPE);
    }

    private static VoxelShape getOuterRightFacingShapes(Direction facing) {
        switch (facing) {
            case WEST: {
                return NORTH_OUTER_SHAPE;
            }
            case EAST: {
                return SOUTH_OUTER_SHAPE;
            }
            case SOUTH: {
                return WEST_OUTER_SHAPE;
            }
        }
        return EAST_OUTER_SHAPE;
    }

    private static VoxelShape getInnerRightFacingShapes(Direction facing) {
        switch (facing) {
            case WEST: {
                return VoxelShapes.func_197872_a((VoxelShape)WEST_SHAPE, (VoxelShape)NORTH_SHAPE);
            }
            case EAST: {
                return VoxelShapes.func_197872_a((VoxelShape)EAST_SHAPE, (VoxelShape)SOUTH_SHAPE);
            }
            case SOUTH: {
                return VoxelShapes.func_197872_a((VoxelShape)SOUTH_SHAPE, (VoxelShape)WEST_SHAPE);
            }
        }
        return VoxelShapes.func_197872_a((VoxelShape)NORTH_SHAPE, (VoxelShape)EAST_SHAPE);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState iblockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        return (BlockState)iblockstate.func_206870_a(SHAPE, (Comparable)((Object)VerticalSlabBlock.getSlabShape(iblockstate, (IWorld)context.func_195991_k(), context.func_195995_a())));
    }

    private static VerticalSlabShape getSlabShape(BlockState state, IWorld worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (VerticalSlabBlock.isBlockVerticalSlab(iblockstate) && (direction1 = (Direction)iblockstate.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && VerticalSlabBlock.isDifferentVerticalSlab(state, worldIn, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return VerticalSlabShape.OUTER_LEFT;
            }
            return VerticalSlabShape.OUTER_RIGHT;
        }
        BlockState iblockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (VerticalSlabBlock.isBlockVerticalSlab(iblockstate1) && (direction2 = (Direction)iblockstate1.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && VerticalSlabBlock.isDifferentVerticalSlab(state, worldIn, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return VerticalSlabShape.INNER_LEFT;
            }
            return VerticalSlabShape.INNER_RIGHT;
        }
        return VerticalSlabShape.STRAIGHT;
    }

    private static boolean isDifferentVerticalSlab(BlockState state, IWorld worldIn, BlockPos pos, Direction direction) {
        BlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        return !VerticalSlabBlock.isBlockVerticalSlab(iblockstate) || iblockstate.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING);
    }

    public static boolean isBlockVerticalSlab(BlockState state) {
        return state.func_177230_c() instanceof VerticalSlabBlock || state.func_177230_c() instanceof FallingVerticalSlabBlock || state.func_177230_c() instanceof PathVerticalSlabBlock;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205361_b(currentPos, (Object)Fluids.field_204546_a);
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)stateIn.func_206870_a(SHAPE, (Comparable)((Object)VerticalSlabBlock.getSlabShape(stateIn, worldIn, currentPos))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }
}

