/*
 * Decompiled with CFR 0.152.
 */
package com.blackout.extendedslabs.datagen;

import com.blackout.extendedslabs.ExtendedSlabs;
import com.blackout.extendedslabs.init.ESPCorners;
import com.blackout.extendedslabs.init.ESPSlabs;
import com.blackout.extendedslabs.init.ESPStairs;
import com.blackout.extendedslabs.init.ESPVerticalSlabs;
import com.blackout.extendedslabs.init.modded.BOPCorners;
import com.blackout.extendedslabs.init.modded.BOPVerticalSlabs;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ESPItemModelGenerator
extends ItemModelProvider {
    public ESPItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "extendedslabs", existingFileHelper);
    }

    protected void registerModels() {
        this.generateSlabBlockItems(ESPSlabs.ITEMS.getEntries());
        this.generateStairBlockItems(ESPStairs.ITEMS.getEntries());
        this.generateCornerBlockItems(ESPCorners.ITEMS.getEntries());
        this.generateVerticalSlabBlockItems(ESPVerticalSlabs.ITEMS.getEntries());
        this.generateBOPCornerBlockItems(BOPCorners.ITEMS.getEntries());
        this.generateBOPVerticalSlabBlockItems(BOPVerticalSlabs.ITEMS.getEntries());
    }

    @Nonnull
    public String func_200397_b() {
        return "Extended Slabs Item models";
    }

    private void generateSlabBlockItems(Collection<RegistryObject<Item>> itemBlocks) {
        for (RegistryObject<Item> item : itemBlocks) {
            String name = item.getId().func_110623_a();
            if (!this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "block/" + name), (ExistingFileHelper.IResourceType)MODEL) || this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "item/" + name), (ExistingFileHelper.IResourceType)MODEL)) continue;
            ExtendedSlabs.LOGGER.info((Object)item.getId());
            this.withExistingParent(name, new ResourceLocation("extendedslabs", "block/" + name));
        }
    }

    private void generateStairBlockItems(Collection<RegistryObject<Item>> itemBlocks) {
        for (RegistryObject<Item> item : itemBlocks) {
            String name = item.getId().func_110623_a();
            if (!this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "block/stairs/regular/" + name), (ExistingFileHelper.IResourceType)MODEL) || this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "item/" + name), (ExistingFileHelper.IResourceType)MODEL)) continue;
            ExtendedSlabs.LOGGER.info((Object)item.getId());
            this.withExistingParent(name, new ResourceLocation("extendedslabs", "block/stairs/regular/" + name));
        }
    }

    private void generateCornerBlockItems(Collection<RegistryObject<Item>> itemBlocks) {
        for (RegistryObject<Item> item : itemBlocks) {
            String name = item.getId().func_110623_a();
            if (!this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "block/corners/" + name), (ExistingFileHelper.IResourceType)MODEL) || this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "item/" + name), (ExistingFileHelper.IResourceType)MODEL)) continue;
            ExtendedSlabs.LOGGER.info((Object)item.getId());
            this.withExistingParent(name, new ResourceLocation("extendedslabs", "block/corners/" + name));
        }
    }

    private void generateVerticalSlabBlockItems(Collection<RegistryObject<Item>> itemBlocks) {
        for (RegistryObject<Item> item : itemBlocks) {
            String name = item.getId().func_110623_a();
            if (!this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "block/" + name), (ExistingFileHelper.IResourceType)MODEL) || this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "item/" + name), (ExistingFileHelper.IResourceType)MODEL)) continue;
            ExtendedSlabs.LOGGER.info((Object)item.getId());
            this.withExistingParent(name, new ResourceLocation("extendedslabs", "block/" + name));
        }
    }

    private void generateBOPCornerBlockItems(Collection<RegistryObject<Item>> itemBlocks) {
        for (RegistryObject<Item> item : itemBlocks) {
            String name = item.getId().func_110623_a();
            if (!this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "block/corners/" + name), (ExistingFileHelper.IResourceType)MODEL) || this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "item/" + name), (ExistingFileHelper.IResourceType)MODEL)) continue;
            ExtendedSlabs.LOGGER.info((Object)item.getId());
            this.withExistingParent(name, new ResourceLocation("extendedslabs", "block/corners/" + name));
        }
    }

    private void generateBOPVerticalSlabBlockItems(Collection<RegistryObject<Item>> itemBlocks) {
        for (RegistryObject<Item> item : itemBlocks) {
            String name = item.getId().func_110623_a();
            if (!this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "block/" + name), (ExistingFileHelper.IResourceType)MODEL) || this.existingFileHelper.exists(new ResourceLocation("extendedslabs", "item/" + name), (ExistingFileHelper.IResourceType)MODEL)) continue;
            ExtendedSlabs.LOGGER.info((Object)item.getId());
            this.withExistingParent(name, new ResourceLocation("extendedslabs", "block/" + name));
        }
    }
}

