/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.util.Palette;
import dan200.computercraft.shared.util.StringUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;

public abstract class TermMethods {
    private static int getHighestBit(int group) {
        int bit = 0;
        while (group > 0) {
            group >>= 1;
            ++bit;
        }
        return bit;
    }

    @Nonnull
    public abstract Terminal getTerminal() throws LuaException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final void write(IArguments arguments) throws LuaException {
        Terminal terminal;
        String text = StringUtil.toString(arguments.get(0));
        Terminal terminal2 = terminal = this.getTerminal();
        synchronized (terminal2) {
            terminal.write(text);
            terminal.setCursorPos(terminal.getCursorX() + text.length(), terminal.getCursorY());
        }
    }

    @LuaFunction
    public final void scroll(int y) throws LuaException {
        this.getTerminal().scroll(y);
    }

    @LuaFunction
    public final Object[] getCursorPos() throws LuaException {
        Terminal terminal = this.getTerminal();
        return new Object[]{terminal.getCursorX() + 1, terminal.getCursorY() + 1};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final void setCursorPos(int x, int y) throws LuaException {
        Terminal terminal;
        Terminal terminal2 = terminal = this.getTerminal();
        synchronized (terminal2) {
            terminal.setCursorPos(x - 1, y - 1);
        }
    }

    @LuaFunction
    public final boolean getCursorBlink() throws LuaException {
        return this.getTerminal().getCursorBlink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final void setCursorBlink(boolean blink) throws LuaException {
        Terminal terminal;
        Terminal terminal2 = terminal = this.getTerminal();
        synchronized (terminal2) {
            terminal.setCursorBlink(blink);
        }
    }

    @LuaFunction
    public final Object[] getSize() throws LuaException {
        Terminal terminal = this.getTerminal();
        return new Object[]{terminal.getWidth(), terminal.getHeight()};
    }

    @LuaFunction
    public final void clear() throws LuaException {
        this.getTerminal().clear();
    }

    @LuaFunction
    public final void clearLine() throws LuaException {
        this.getTerminal().clearLine();
    }

    @LuaFunction(value={"getTextColour", "getTextColor"})
    public final int getTextColour() throws LuaException {
        return TermMethods.encodeColour(this.getTerminal().getTextColour());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(value={"setTextColour", "setTextColor"})
    public final void setTextColour(int colourArg) throws LuaException {
        Terminal terminal;
        int colour = TermMethods.parseColour(colourArg);
        Terminal terminal2 = terminal = this.getTerminal();
        synchronized (terminal2) {
            terminal.setTextColour(colour);
        }
    }

    @LuaFunction(value={"getBackgroundColour", "getBackgroundColor"})
    public final int getBackgroundColour() throws LuaException {
        return TermMethods.encodeColour(this.getTerminal().getBackgroundColour());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(value={"setBackgroundColour", "setBackgroundColor"})
    public final void setBackgroundColour(int colourArg) throws LuaException {
        Terminal terminal;
        int colour = TermMethods.parseColour(colourArg);
        Terminal terminal2 = terminal = this.getTerminal();
        synchronized (terminal2) {
            terminal.setBackgroundColour(colour);
        }
    }

    @LuaFunction(value={"isColour", "isColor"})
    public final boolean getIsColour() throws LuaException {
        return this.getTerminal().isColour();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final void blit(ByteBuffer text, ByteBuffer textColour, ByteBuffer backgroundColour) throws LuaException {
        Terminal terminal;
        if (textColour.remaining() != text.remaining() || backgroundColour.remaining() != text.remaining()) {
            throw new LuaException("Arguments must be the same length");
        }
        Terminal terminal2 = terminal = this.getTerminal();
        synchronized (terminal2) {
            terminal.blit(text, textColour, backgroundColour);
            terminal.setCursorPos(terminal.getCursorX() + text.remaining(), terminal.getCursorY());
        }
    }

    @LuaFunction(value={"setPaletteColour", "setPaletteColor"})
    public final void setPaletteColour(IArguments args) throws LuaException {
        int colour = 15 - TermMethods.parseColour(args.getInt(0));
        if (args.count() == 2) {
            int hex = args.getInt(1);
            double[] rgb = Palette.decodeRGB8(hex);
            TermMethods.setColour(this.getTerminal(), colour, rgb[0], rgb[1], rgb[2]);
        } else {
            double r = args.getFiniteDouble(1);
            double g = args.getFiniteDouble(2);
            double b = args.getFiniteDouble(3);
            TermMethods.setColour(this.getTerminal(), colour, r, g, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction(value={"getPaletteColour", "getPaletteColor"})
    public final Object[] getPaletteColour(int colourArg) throws LuaException {
        Terminal terminal;
        int colour = 15 - TermMethods.parseColour(colourArg);
        Terminal terminal2 = terminal = this.getTerminal();
        synchronized (terminal2) {
            return ArrayUtils.toObject((double[])terminal.getPalette().getColour(colour));
        }
    }

    public static int parseColour(int colour) throws LuaException {
        if (colour <= 0) {
            throw new LuaException("Colour out of range");
        }
        if ((colour = TermMethods.getHighestBit(colour) - 1) < 0 || colour > 15) {
            throw new LuaException("Colour out of range");
        }
        return colour;
    }

    public static int encodeColour(int colour) {
        return 1 << colour;
    }

    public static void setColour(Terminal terminal, int colour, double r, double g, double b) {
        terminal.getPalette().setColour(colour, r, g, b);
        terminal.setChanged();
    }
}

