/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.request;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.apis.http.Resource;
import dan200.computercraft.core.apis.http.ResourceGroup;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.request.HttpRequestHandler;
import dan200.computercraft.core.apis.http.request.HttpResponseHandle;
import dan200.computercraft.core.metrics.Metrics;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpRequest
extends Resource<HttpRequest> {
    private static final String SUCCESS_EVENT = "http_success";
    private static final String FAILURE_EVENT = "http_failure";
    private static final int MAX_REDIRECTS = 16;
    private Future<?> executorFuture;
    private ChannelFuture connectFuture;
    private HttpRequestHandler currentRequest;
    private final IAPIEnvironment environment;
    private final String address;
    private final ByteBuf postBuffer;
    private final HttpHeaders headers;
    private final boolean binary;
    final AtomicInteger redirects;

    public HttpRequest(ResourceGroup<HttpRequest> limiter, IAPIEnvironment environment, String address, String postText, HttpHeaders headers, boolean binary, boolean followRedirects) {
        super(limiter);
        this.environment = environment;
        this.address = address;
        this.postBuffer = postText != null ? Unpooled.wrappedBuffer((byte[])postText.getBytes(StandardCharsets.UTF_8)) : Unpooled.buffer((int)0);
        this.headers = headers;
        this.binary = binary;
        this.redirects = new AtomicInteger(followRedirects ? 16 : 0);
        if (postText != null) {
            if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-www-form-urlencoded; charset=utf-8");
            }
            if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.postBuffer.readableBytes());
            }
        }
    }

    public IAPIEnvironment environment() {
        return this.environment;
    }

    public static URI checkUri(String address) throws HTTPRequestException {
        URI url;
        try {
            url = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new HTTPRequestException("URL malformed");
        }
        HttpRequest.checkUri(url);
        return url;
    }

    public static void checkUri(URI url) throws HTTPRequestException {
        if (url.getScheme() == null) {
            throw new HTTPRequestException("Must specify http or https");
        }
        if (url.getHost() == null) {
            throw new HTTPRequestException("URL malformed");
        }
        String scheme = url.getScheme().toLowerCase(Locale.ROOT);
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new HTTPRequestException("Invalid protocol '" + scheme + "'");
        }
    }

    public void request(URI uri, HttpMethod method) {
        if (this.isClosed()) {
            return;
        }
        this.executorFuture = NetworkUtils.EXECUTOR.submit(() -> this.doRequest(uri, method));
        this.checkClosed();
    }

    private void doRequest(final URI uri, HttpMethod method) {
        block6: {
            if (this.isClosed()) {
                return;
            }
            try {
                SslContext sslContext;
                boolean ssl = uri.getScheme().equalsIgnoreCase("https");
                final InetSocketAddress socketAddress = NetworkUtils.getAddress(uri, ssl);
                final Options options = NetworkUtils.getOptions(uri.getHost(), socketAddress);
                Object object = sslContext = ssl ? NetworkUtils.getSslContext() : null;
                if (this.isClosed()) {
                    return;
                }
                long requestBody = HttpRequest.getHeaderSize(this.headers) + (long)this.postBuffer.capacity();
                if (options.maxUpload != 0L && requestBody > options.maxUpload) {
                    this.failure("Request body is too large");
                    return;
                }
                this.environment.observe(Metrics.HTTP_REQUESTS);
                this.environment.observe(Metrics.HTTP_UPLOAD, requestBody);
                final HttpRequestHandler handler = this.currentRequest = new HttpRequestHandler(this, uri, method, options);
                this.connectFuture = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(NetworkUtils.LOOP_GROUP)).channelFactory(NioSocketChannel::new)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel ch) {
                        if (options.timeout > 0) {
                            ch.config().setConnectTimeoutMillis(options.timeout);
                        }
                        ChannelPipeline p = ch.pipeline();
                        p.addLast(new ChannelHandler[]{NetworkUtils.SHAPING_HANDLER});
                        if (sslContext != null) {
                            p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc(), uri.getHost(), socketAddress.getPort())});
                        }
                        if (options.timeout > 0) {
                            p.addLast(new ChannelHandler[]{new ReadTimeoutHandler((long)options.timeout, TimeUnit.MILLISECONDS)});
                        }
                        p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpContentDecompressor(), handler});
                    }
                })).remoteAddress((SocketAddress)socketAddress).connect().addListener(c -> {
                    if (!c.isSuccess()) {
                        this.failure(NetworkUtils.toFriendlyError(c.cause()));
                    }
                });
                this.checkClosed();
            }
            catch (HTTPRequestException e) {
                this.failure(e.getMessage());
            }
            catch (Exception e) {
                this.failure(NetworkUtils.toFriendlyError(e));
                if (!ComputerCraft.logComputerErrors) break block6;
                ComputerCraft.log.error("Error in HTTP request", (Throwable)e);
            }
        }
    }

    void failure(String message) {
        if (this.tryClose()) {
            this.environment.queueEvent(FAILURE_EVENT, this.address, message);
        }
    }

    void failure(String message, HttpResponseHandle object) {
        if (this.tryClose()) {
            this.environment.queueEvent(FAILURE_EVENT, this.address, message, object);
        }
    }

    void success(HttpResponseHandle object) {
        if (this.tryClose()) {
            this.environment.queueEvent(SUCCESS_EVENT, this.address, object);
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.executorFuture = HttpRequest.closeFuture(this.executorFuture);
        this.connectFuture = HttpRequest.closeChannel(this.connectFuture);
        this.currentRequest = HttpRequest.closeCloseable(this.currentRequest);
    }

    public static long getHeaderSize(HttpHeaders headers) {
        long size = 0L;
        for (Map.Entry header : headers) {
            size += header.getKey() == null ? 0L : (long)((String)header.getKey()).length();
            size += header.getValue() == null ? 0L : (long)(((String)header.getValue()).length() + 1);
        }
        return size;
    }

    public ByteBuf body() {
        return this.postBuffer;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public boolean isBinary() {
        return this.binary;
    }
}

