/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaThread;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.UnwindThrowable;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.compiler.CompileException;
import cc.tweaked.internal.cobalt.compiler.LoadState;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.debug.DebugHandler;
import cc.tweaked.internal.cobalt.debug.DebugState;
import cc.tweaked.internal.cobalt.function.LuaClosure;
import cc.tweaked.internal.cobalt.lib.BaseLib;
import cc.tweaked.internal.cobalt.lib.Bit32Lib;
import cc.tweaked.internal.cobalt.lib.CoroutineLib;
import cc.tweaked.internal.cobalt.lib.DebugLib;
import cc.tweaked.internal.cobalt.lib.MathLib;
import cc.tweaked.internal.cobalt.lib.StringLib;
import cc.tweaked.internal.cobalt.lib.TableLib;
import cc.tweaked.internal.cobalt.lib.Utf8Lib;
import cc.tweaked.internal.cobalt.lib.platform.VoidResourceManipulator;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.IDynamicLuaObject;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaFunction;
import dan200.computercraft.core.asm.LuaMethod;
import dan200.computercraft.core.asm.ObjectSource;
import dan200.computercraft.core.computer.TimeoutState;
import dan200.computercraft.core.lua.BasicFunction;
import dan200.computercraft.core.lua.ILuaMachine;
import dan200.computercraft.core.lua.MachineEnvironment;
import dan200.computercraft.core.lua.MachineResult;
import dan200.computercraft.core.lua.ResultInterpreterFunction;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.shared.util.ThreadUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CobaltLuaMachine
implements ILuaMachine {
    private static final ThreadPoolExecutor COROUTINES = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), ThreadUtils.factory("Coroutine"));
    private static final LuaMethod FUNCTION_METHOD = (target, context, args) -> ((ILuaFunction)target).call(args);
    private final TimeoutState timeout;
    private final TimeoutDebugHandler debug;
    private final ILuaContext context;
    private LuaState state;
    private LuaTable globals;
    private LuaThread mainRoutine = null;
    private String eventFilter = null;

    public CobaltLuaMachine(MachineEnvironment environment) {
        this.timeout = environment.timeout;
        this.context = environment.context;
        this.debug = new TimeoutDebugHandler();
        MetricsObserver metrics = environment.metrics;
        LuaState state = this.state = LuaState.builder().resourceManipulator(new VoidResourceManipulator()).debug(this.debug).coroutineExecutor(command -> {
            metrics.observe(Metrics.COROUTINES_CREATED);
            COROUTINES.execute(() -> {
                try {
                    command.run();
                }
                finally {
                    metrics.observe(Metrics.COROUTINES_DISPOSED);
                }
            });
        }).build();
        this.globals = new LuaTable();
        state.setupThread(this.globals);
        this.globals.load(state, new BaseLib());
        this.globals.load(state, new TableLib());
        this.globals.load(state, new StringLib());
        this.globals.load(state, new MathLib());
        this.globals.load(state, new CoroutineLib());
        this.globals.load(state, new Bit32Lib());
        this.globals.load(state, new Utf8Lib());
        this.globals.load(state, new DebugLib());
        this.globals.rawset("collectgarbage", Constants.NIL);
        this.globals.rawset("dofile", Constants.NIL);
        this.globals.rawset("loadfile", Constants.NIL);
        this.globals.rawset("print", Constants.NIL);
        this.globals.rawset("_VERSION", (LuaValue)ValueFactory.valueOf("Lua 5.1"));
        this.globals.rawset("_HOST", (LuaValue)ValueFactory.valueOf(environment.hostString));
        this.globals.rawset("_CC_DEFAULT_SETTINGS", (LuaValue)ValueFactory.valueOf(ComputerCraft.defaultComputerSettings));
        if (ComputerCraft.disableLua51Features) {
            this.globals.rawset("_CC_DISABLE_LUA51_FEATURES", (LuaValue)Constants.TRUE);
        }
    }

    @Override
    public void addAPI(@Nonnull ILuaAPI api) {
        String[] names;
        LuaTable table = this.wrapLuaObject(api);
        if (table == null) {
            ComputerCraft.log.warn("API {} does not provide any methods", (Object)api);
            table = new LuaTable();
        }
        for (String name : names = api.getNames()) {
            this.globals.rawset(name, (LuaValue)table);
        }
    }

    @Override
    public MachineResult loadBios(@Nonnull InputStream bios) {
        if (this.mainRoutine != null) {
            return MachineResult.OK;
        }
        try {
            LuaClosure value = LoadState.load(this.state, bios, "@bios.lua", this.globals);
            this.mainRoutine = new LuaThread(this.state, value, this.globals);
            return MachineResult.OK;
        }
        catch (CompileException e) {
            this.close();
            return MachineResult.error(e);
        }
        catch (Exception e) {
            ComputerCraft.log.warn("Could not load bios.lua", (Throwable)e);
            this.close();
            return MachineResult.GENERIC_ERROR;
        }
    }

    @Override
    public MachineResult handleEvent(String eventName, Object[] arguments) {
        if (this.mainRoutine == null) {
            return MachineResult.OK;
        }
        if (this.eventFilter != null && eventName != null && !eventName.equals(this.eventFilter) && !eventName.equals("terminate")) {
            return MachineResult.OK;
        }
        this.timeout.refresh();
        if (!this.timeout.isSoftAborted()) {
            this.debug.thrownSoftAbort = false;
        }
        try {
            LuaThread thread;
            Varargs resumeArgs = Constants.NONE;
            if (eventName != null) {
                resumeArgs = ValueFactory.varargsOf((LuaValue)ValueFactory.valueOf(eventName), this.toValues(arguments));
            }
            if ((thread = this.state.getCurrentThread()) == null || thread == this.state.getMainThread()) {
                thread = this.mainRoutine;
            }
            Varargs results = LuaThread.run(thread, resumeArgs);
            if (this.timeout.isHardAborted()) {
                throw HardAbortError.INSTANCE;
            }
            if (results == null) {
                return MachineResult.PAUSE;
            }
            LuaValue filter = results.first();
            String string = this.eventFilter = filter.isString() ? filter.toString() : null;
            if (this.mainRoutine.getStatus().equals("dead")) {
                this.close();
                return MachineResult.GENERIC_ERROR;
            }
            return MachineResult.OK;
        }
        catch (HardAbortError | InterruptedException e) {
            this.close();
            return MachineResult.TIMEOUT;
        }
        catch (LuaError e) {
            this.close();
            ComputerCraft.log.warn("Top level coroutine errored", (Throwable)e);
            return MachineResult.error(e);
        }
    }

    @Override
    public void printExecutionState(StringBuilder out) {
        LuaState state = this.state;
        if (state == null) {
            out.append("CobaltLuaMachine is terminated\n");
        } else {
            state.printExecutionState(out);
        }
    }

    @Override
    public void close() {
        LuaState state = this.state;
        if (state == null) {
            return;
        }
        state.abandon();
        this.mainRoutine = null;
        this.state = null;
        this.globals = null;
    }

    @Nullable
    private LuaTable wrapLuaObject(Object object) {
        String[] dynamicMethods = object instanceof IDynamicLuaObject ? Objects.requireNonNull(((IDynamicLuaObject)object).getMethodNames(), "Methods cannot be null") : LuaMethod.EMPTY_METHODS;
        LuaTable table = new LuaTable();
        for (int i = 0; i < dynamicMethods.length; ++i) {
            String method2 = dynamicMethods[i];
            table.rawset(method2, (LuaValue)new ResultInterpreterFunction(this, LuaMethod.DYNAMIC.get(i), object, this.context, method2));
        }
        ObjectSource.allMethods(LuaMethod.GENERATOR, object, (instance, method) -> table.rawset(method.getName(), (LuaValue)(method.nonYielding() ? new BasicFunction(this, (LuaMethod)method.getMethod(), instance, this.context, method.getName()) : new ResultInterpreterFunction(this, (LuaMethod)method.getMethod(), instance, this.context, method.getName()))));
        try {
            if (table.keyCount() == 0) {
                return null;
            }
        }
        catch (LuaError luaError) {
            // empty catch block
        }
        return table;
    }

    @Nonnull
    private LuaValue toValue(@Nullable Object object, @Nullable Map<Object, LuaValue> values) {
        LuaValue result;
        if (object == null) {
            return Constants.NIL;
        }
        if (object instanceof Number) {
            return ValueFactory.valueOf(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return ValueFactory.valueOf((Boolean)object);
        }
        if (object instanceof String) {
            return ValueFactory.valueOf(object.toString());
        }
        if (object instanceof byte[]) {
            byte[] b = (byte[])object;
            return ValueFactory.valueOf(Arrays.copyOf(b, b.length));
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer b = (ByteBuffer)object;
            byte[] bytes = new byte[b.remaining()];
            b.get(bytes);
            return ValueFactory.valueOf(bytes);
        }
        if (values == null) {
            values = new IdentityHashMap<Object, LuaValue>(1);
        }
        if ((result = values.get(object)) != null) {
            return result;
        }
        if (object instanceof ILuaFunction) {
            return new ResultInterpreterFunction(this, FUNCTION_METHOD, object, this.context, object.toString());
        }
        if (object instanceof IDynamicLuaObject) {
            LuaTable wrapped = this.wrapLuaObject(object);
            if (wrapped == null) {
                wrapped = new LuaTable();
            }
            values.put(object, wrapped);
            return wrapped;
        }
        if (object instanceof Map) {
            LuaTable table = new LuaTable();
            values.put(object, table);
            for (Map.Entry pair : ((Map)object).entrySet()) {
                LuaValue key = this.toValue(pair.getKey(), values);
                LuaValue value = this.toValue(pair.getValue(), values);
                if (key.isNil() || value.isNil()) continue;
                table.rawset(key, value);
            }
            return table;
        }
        if (object instanceof Collection) {
            Collection objects = (Collection)object;
            LuaTable table = new LuaTable(objects.size(), 0);
            values.put(object, table);
            int i = 0;
            for (Object child : objects) {
                table.rawset(++i, this.toValue(child, values));
            }
            return table;
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            LuaTable table = new LuaTable(objects.length, 0);
            values.put(object, table);
            for (int i = 0; i < objects.length; ++i) {
                table.rawset(i + 1, this.toValue(objects[i], values));
            }
            return table;
        }
        LuaTable wrapped = this.wrapLuaObject(object);
        if (wrapped != null) {
            values.put(object, wrapped);
            return wrapped;
        }
        if (ComputerCraft.logComputerErrors) {
            ComputerCraft.log.warn("Received unknown type '{}', returning nil.", (Object)object.getClass().getName());
        }
        return Constants.NIL;
    }

    Varargs toValues(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return Constants.NONE;
        }
        if (objects.length == 1) {
            return this.toValue(objects[0], null);
        }
        IdentityHashMap<Object, LuaValue> result = new IdentityHashMap<Object, LuaValue>(0);
        LuaValue[] values = new LuaValue[objects.length];
        for (int i = 0; i < values.length; ++i) {
            Object object = objects[i];
            values[i] = this.toValue(object, result);
        }
        return ValueFactory.varargsOf(values);
    }

    static Object toObject(LuaValue value, Map<LuaValue, Object> objects) {
        switch (value.type()) {
            case -1: 
            case 0: {
                return null;
            }
            case -2: 
            case 3: {
                return value.toDouble();
            }
            case 1: {
                return value.toBoolean();
            }
            case 4: {
                return value.toString();
            }
            case 5: {
                if (objects == null) {
                    objects = new IdentityHashMap<LuaValue, Object>(1);
                } else {
                    Object existing = objects.get(value);
                    if (existing != null) {
                        return existing;
                    }
                }
                HashMap<Object, Object> table = new HashMap<Object, Object>();
                objects.put(value, table);
                LuaTable luaTable = (LuaTable)value;
                LuaValue k = Constants.NIL;
                while (true) {
                    Varargs keyValue;
                    try {
                        keyValue = luaTable.next(k);
                    }
                    catch (LuaError luaError) {
                        break;
                    }
                    k = keyValue.first();
                    if (k.isNil()) break;
                    LuaValue v = keyValue.arg(2);
                    Object keyObject = CobaltLuaMachine.toObject(k, objects);
                    Object valueObject = CobaltLuaMachine.toObject(v, objects);
                    if (keyObject == null || valueObject == null) continue;
                    table.put(keyObject, valueObject);
                }
                return table;
            }
        }
        return null;
    }

    static Object[] toObjects(Varargs values) {
        int count = values.count();
        Object[] objects = new Object[count];
        for (int i = 0; i < count; ++i) {
            objects[i] = CobaltLuaMachine.toObject(values.arg(i + 1), null);
        }
        return objects;
    }

    private static final class HardAbortError
    extends Error {
        private static final long serialVersionUID = 7954092008586367501L;
        static final HardAbortError INSTANCE = new HardAbortError();

        private HardAbortError() {
            super("Hard Abort", null, true, false);
        }
    }

    private class TimeoutDebugHandler
    extends DebugHandler {
        private final TimeoutState timeout;
        private int count = 0;
        boolean thrownSoftAbort;
        private boolean isPaused;
        private int oldFlags;
        private boolean oldInHook;

        TimeoutDebugHandler() {
            this.timeout = CobaltLuaMachine.this.timeout;
        }

        @Override
        public void onInstruction(DebugState ds, DebugFrame di, int pc) throws LuaError, UnwindThrowable {
            di.pc = pc;
            if (this.isPaused) {
                this.resetPaused(ds, di);
            }
            if ((this.count = this.count + 1 & 0x7F) == 0) {
                if (this.timeout.isHardAborted() || CobaltLuaMachine.this.state == null) {
                    throw HardAbortError.INSTANCE;
                }
                if (this.timeout.isPaused()) {
                    this.handlePause(ds, di);
                }
                if (this.timeout.isSoftAborted()) {
                    this.handleSoftAbort();
                }
            }
            super.onInstruction(ds, di, pc);
        }

        @Override
        public void poll() throws LuaError {
            LuaState state = CobaltLuaMachine.this.state;
            if (this.timeout.isHardAborted() || state == null) {
                throw HardAbortError.INSTANCE;
            }
            if (this.timeout.isPaused()) {
                LuaThread.suspendBlocking(state);
            }
            if (this.timeout.isSoftAborted()) {
                this.handleSoftAbort();
            }
        }

        private void resetPaused(DebugState ds, DebugFrame di) {
            this.isPaused = false;
            ds.inhook = this.oldInHook;
            di.flags = this.oldFlags;
        }

        private void handleSoftAbort() throws LuaError {
            if (this.thrownSoftAbort) {
                return;
            }
            this.thrownSoftAbort = true;
            throw new LuaError("Too long without yielding");
        }

        private void handlePause(DebugState ds, DebugFrame di) throws LuaError, UnwindThrowable {
            this.isPaused = true;
            this.oldInHook = ds.inhook;
            this.oldFlags = di.flags;
            di.flags |= 0x44;
            LuaThread.suspend(ds.getLuaState());
            this.resetPaused(ds, di);
        }
    }
}

