/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.peripheral.diskdrive.BlockDiskDrive;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.monitor.BlockMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.printer.BlockPrinter;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.data.BlockModelDefinition;
import net.minecraft.data.BlockModelFields;
import net.minecraft.data.BlockModelProvider;
import net.minecraft.data.BlockStateVariantBuilder;
import net.minecraft.data.FinishedMultiPartBlockState;
import net.minecraft.data.FinishedVariantBlockState;
import net.minecraft.data.IMultiPartPredicateBuilder;
import net.minecraft.data.ModelTextures;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.data.ModelsUtil;
import net.minecraft.data.StockModelShapes;
import net.minecraft.data.StockTextureAliases;
import net.minecraft.data.TexturedModel;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

class BlockModelGenerator {
    private static final ModelsUtil MONITOR_BASE = new ModelsUtil(Optional.of(new ResourceLocation("computercraft", "block/monitor_base")), Optional.empty(), new StockTextureAliases[]{StockTextureAliases.field_240410_g_, StockTextureAliases.field_240412_i_, StockTextureAliases.field_240409_f_, StockTextureAliases.field_240411_h_});
    private static final ModelsUtil MODEM = new ModelsUtil(Optional.of(new ResourceLocation("computercraft", "block/modem")), Optional.empty(), new StockTextureAliases[]{StockTextureAliases.field_240410_g_, StockTextureAliases.field_240411_h_});
    private static final ModelsUtil TURTLE = new ModelsUtil(Optional.of(new ResourceLocation("computercraft", "block/turtle_base")), Optional.empty(), new StockTextureAliases[]{StockTextureAliases.field_240405_b_});
    private static final ModelsUtil TURTLE_UPGRADE_LEFT = new ModelsUtil(Optional.of(new ResourceLocation("computercraft", "block/turtle_upgrade_base_left")), Optional.of("_left"), new StockTextureAliases[]{StockTextureAliases.field_240405_b_});
    private static final ModelsUtil TURTLE_UPGRADE_RIGHT = new ModelsUtil(Optional.of(new ResourceLocation("computercraft", "block/turtle_upgrade_base_right")), Optional.of("_left"), new StockTextureAliases[]{StockTextureAliases.field_240405_b_});
    private static final BooleanProperty[] CABLE_DIRECTIONS = new BooleanProperty[]{BlockCable.DOWN, BlockCable.UP, BlockCable.NORTH, BlockCable.SOUTH, BlockCable.WEST, BlockCable.EAST};
    private static final boolean[] BOOLEANS = new boolean[]{false, true};

    BlockModelGenerator() {
    }

    public static void addBlockModels(BlockModelProvider generators) {
        BlockModelGenerator.registerComputer(generators, (BlockComputer)Registry.ModBlocks.COMPUTER_NORMAL.get());
        BlockModelGenerator.registerComputer(generators, (BlockComputer)Registry.ModBlocks.COMPUTER_ADVANCED.get());
        BlockModelGenerator.registerComputer(generators, (BlockComputer)Registry.ModBlocks.COMPUTER_COMMAND.get());
        BlockModelGenerator.registerTurtle(generators, (BlockTurtle)Registry.ModBlocks.TURTLE_NORMAL.get());
        BlockModelGenerator.registerTurtle(generators, (BlockTurtle)Registry.ModBlocks.TURTLE_ADVANCED.get());
        BlockModelGenerator.registerWirelessModem(generators, (BlockWirelessModem)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get());
        BlockModelGenerator.registerWirelessModem(generators, (BlockWirelessModem)Registry.ModBlocks.WIRELESS_MODEM_ADVANCED.get());
        BlockModelGenerator.registerWiredModems(generators);
        BlockModelGenerator.registerMonitor(generators, (BlockMonitor)Registry.ModBlocks.MONITOR_NORMAL.get());
        BlockModelGenerator.registerMonitor(generators, (BlockMonitor)Registry.ModBlocks.MONITOR_ADVANCED.get());
        generators.func_239939_b_((Block)Registry.ModBlocks.SPEAKER.get(), TexturedModel.field_240440_g_);
        BlockModelGenerator.registerDiskDrive(generators);
        BlockModelGenerator.registerPrinter(generators);
        BlockModelGenerator.registerCable(generators);
        BlockModelGenerator.registerTurtleUpgrade(generators, "block/turtle_crafting_table", "block/turtle_crafty_face");
        BlockModelGenerator.registerTurtleUpgrade(generators, "block/turtle_speaker", "block/turtle_speaker_face");
        BlockModelGenerator.registerTurtleModem(generators, "block/turtle_modem_normal", "block/wireless_modem_normal_face");
        BlockModelGenerator.registerTurtleModem(generators, "block/turtle_modem_advanced", "block/wireless_modem_advanced_face");
    }

    private static void registerDiskDrive(BlockModelProvider generators) {
        BlockDiskDrive diskDrive = (BlockDiskDrive)Registry.ModBlocks.DISK_DRIVE.get();
        generators.field_239834_a_.accept(FinishedVariantBlockState.func_240119_a_((Block)diskDrive).func_240125_a_(BlockModelGenerator.createHorizontalFacingDispatch()).func_240125_a_(BlockModelGenerator.createModelDispatch(BlockDiskDrive.STATE, value -> {
            String textureSuffix;
            switch (value) {
                case EMPTY: {
                    textureSuffix = "_front";
                    break;
                }
                case INVALID: {
                    textureSuffix = "_front_rejected";
                    break;
                }
                case FULL: {
                    textureSuffix = "_front_accepted";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return StockModelShapes.field_240313_i_.func_240229_a_((Block)diskDrive, "_" + value.func_176610_l(), ModelTextures.func_240389_w_((Block)diskDrive).func_240349_a_(StockTextureAliases.field_240410_g_, ModelTextures.func_240347_a_((Block)diskDrive, (String)textureSuffix)), generators.field_239835_b_);
        })));
        generators.func_239957_c_((Block)diskDrive, ModelsResourceUtil.func_240222_a_((Block)diskDrive, (String)"_empty"));
    }

    private static void registerPrinter(BlockModelProvider generators) {
        BlockPrinter printer = (BlockPrinter)Registry.ModBlocks.PRINTER.get();
        generators.field_239834_a_.accept(FinishedVariantBlockState.func_240119_a_((Block)printer).func_240125_a_(BlockModelGenerator.createHorizontalFacingDispatch()).func_240125_a_(BlockModelGenerator.createModelDispatch(BlockPrinter.TOP, BlockPrinter.BOTTOM, (top, bottom) -> {
            String texture;
            String model;
            if (top.booleanValue() && bottom.booleanValue()) {
                model = "_both_full";
                texture = "_both_trays";
            } else if (top.booleanValue()) {
                model = "_top_full";
                texture = "_top_tray";
            } else if (bottom.booleanValue()) {
                model = "_bottom_full";
                texture = "_bottom_tray";
            } else {
                model = "_empty";
                texture = "_empty";
            }
            return StockModelShapes.field_240313_i_.func_240229_a_((Block)printer, model, ModelTextures.func_240389_w_((Block)printer).func_240349_a_(StockTextureAliases.field_240410_g_, ModelTextures.func_240347_a_((Block)printer, (String)("_front" + texture))), generators.field_239835_b_);
        })));
        generators.func_239957_c_((Block)printer, ModelsResourceUtil.func_240222_a_((Block)printer, (String)"_empty"));
    }

    private static void registerComputer(BlockModelProvider generators, BlockComputer block) {
        generators.field_239834_a_.accept(FinishedVariantBlockState.func_240119_a_((Block)block).func_240125_a_(BlockModelGenerator.createHorizontalFacingDispatch()).func_240125_a_(BlockModelGenerator.createModelDispatch(BlockComputer.STATE, state -> StockModelShapes.field_240313_i_.func_240229_a_((Block)block, "_" + state.func_176610_l(), ModelTextures.func_240389_w_((Block)block).func_240349_a_(StockTextureAliases.field_240410_g_, ModelTextures.func_240347_a_((Block)block, (String)("_front" + state.getTexture()))), generators.field_239835_b_))));
        generators.func_239957_c_((Block)block, ModelsResourceUtil.func_240222_a_((Block)block, (String)"_blinking"));
    }

    private static void registerTurtle(BlockModelProvider generators, BlockTurtle block) {
        ResourceLocation model = TURTLE.func_240228_a_((Block)block, ModelTextures.func_240353_b_((Block)block), generators.field_239835_b_);
        generators.field_239834_a_.accept(FinishedVariantBlockState.func_240120_a_((Block)block, (BlockModelDefinition)BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)model)).func_240125_a_(BlockModelGenerator.createHorizontalFacingDispatch()));
        generators.field_239835_b_.accept(ModelsResourceUtil.func_240219_a_((Item)block.func_199767_j()), () -> {
            JsonObject out = new JsonObject();
            out.addProperty("loader", "computercraft:turtle");
            out.addProperty("model", model.toString());
            return out;
        });
    }

    private static void registerWirelessModem(BlockModelProvider generators, BlockWirelessModem block) {
        generators.field_239834_a_.accept(FinishedVariantBlockState.func_240119_a_((Block)block).func_240125_a_(BlockModelGenerator.createFacingDispatch()).func_240125_a_(BlockModelGenerator.createModelDispatch(BlockWirelessModem.ON, on -> BlockModelGenerator.modemModel(generators, ModelsResourceUtil.func_240222_a_((Block)block, (String)(on != false ? "_on" : "_off")), ModelTextures.func_240347_a_((Block)block, (String)("_face" + (on != false ? "_on" : "")))))));
        generators.func_239957_c_((Block)block, ModelsResourceUtil.func_240222_a_((Block)block, (String)"_off"));
    }

    private static void registerWiredModems(BlockModelProvider generators) {
        BlockWiredModemFull fullBlock = (BlockWiredModemFull)Registry.ModBlocks.WIRED_MODEM_FULL.get();
        generators.field_239834_a_.accept(FinishedVariantBlockState.func_240119_a_((Block)fullBlock).func_240125_a_(BlockModelGenerator.createModelDispatch(BlockWiredModemFull.MODEM_ON, BlockWiredModemFull.PERIPHERAL_ON, (on, peripheral) -> {
            String suffix = (on != false ? "_on" : "_off") + (peripheral != false ? "_peripheral" : "");
            ResourceLocation faceTexture = new ResourceLocation("computercraft", "block/wired_modem_face" + (peripheral != false ? "_peripheral" : "") + (on != false ? "_on" : ""));
            BlockModelGenerator.modemModel(generators, new ResourceLocation("computercraft", "block/wired_modem" + suffix), faceTexture);
            return StockModelShapes.field_240307_c_.func_240234_a_(ModelsResourceUtil.func_240222_a_((Block)fullBlock, (String)suffix), new ModelTextures().func_240349_a_(StockTextureAliases.field_240404_a_, faceTexture), generators.field_239835_b_);
        })));
        generators.func_239957_c_((Block)fullBlock, ModelsResourceUtil.func_240222_a_((Block)fullBlock, (String)"_off"));
        generators.func_239867_a_((Item)Registry.ModItems.WIRED_MODEM.get(), new ResourceLocation("computercraft", "block/wired_modem_off"));
    }

    private static ResourceLocation modemModel(BlockModelProvider generators, ResourceLocation name, ResourceLocation texture) {
        return MODEM.func_240234_a_(name, new ModelTextures().func_240349_a_(StockTextureAliases.field_240410_g_, texture).func_240349_a_(StockTextureAliases.field_240411_h_, new ResourceLocation("computercraft", "block/modem_back")), generators.field_239835_b_);
    }

    private static void registerMonitor(BlockModelProvider generators, BlockMonitor block) {
        BlockModelGenerator.monitorModel(generators, block, "", 16, 4, 0, 32);
        BlockModelGenerator.monitorModel(generators, block, "_d", 20, 7, 0, 36);
        BlockModelGenerator.monitorModel(generators, block, "_l", 19, 4, 1, 33);
        BlockModelGenerator.monitorModel(generators, block, "_ld", 31, 7, 1, 45);
        BlockModelGenerator.monitorModel(generators, block, "_lr", 18, 4, 2, 34);
        BlockModelGenerator.monitorModel(generators, block, "_lrd", 30, 7, 2, 46);
        BlockModelGenerator.monitorModel(generators, block, "_lru", 24, 5, 2, 40);
        BlockModelGenerator.monitorModel(generators, block, "_lrud", 27, 6, 2, 43);
        BlockModelGenerator.monitorModel(generators, block, "_lu", 25, 5, 1, 39);
        BlockModelGenerator.monitorModel(generators, block, "_lud", 28, 6, 1, 42);
        BlockModelGenerator.monitorModel(generators, block, "_r", 17, 4, 3, 35);
        BlockModelGenerator.monitorModel(generators, block, "_rd", 29, 7, 3, 47);
        BlockModelGenerator.monitorModel(generators, block, "_ru", 23, 5, 3, 41);
        BlockModelGenerator.monitorModel(generators, block, "_rud", 26, 6, 3, 44);
        BlockModelGenerator.monitorModel(generators, block, "_u", 22, 5, 0, 38);
        BlockModelGenerator.monitorModel(generators, block, "_ud", 21, 6, 0, 37);
        generators.field_239834_a_.accept(FinishedVariantBlockState.func_240119_a_((Block)block).func_240125_a_(BlockModelGenerator.createHorizontalFacingDispatch()).func_240125_a_(BlockModelGenerator.createVerticalFacingDispatch((Property<Direction>)BlockMonitor.ORIENTATION)).func_240125_a_(BlockModelGenerator.createModelDispatch(BlockMonitor.STATE, edge -> ModelsResourceUtil.func_240222_a_((Block)block, (String)(edge == MonitorEdgeState.NONE ? "" : "_" + edge.func_176610_l())))));
        generators.func_239957_c_((Block)block, BlockModelGenerator.monitorModel(generators, block, "_item", 15, 4, 0, 32));
    }

    private static ResourceLocation monitorModel(BlockModelProvider generators, BlockMonitor block, String corners, int front, int side, int top, int back) {
        return MONITOR_BASE.func_240234_a_(ModelsResourceUtil.func_240222_a_((Block)block, (String)corners), new ModelTextures().func_240349_a_(StockTextureAliases.field_240410_g_, ModelTextures.func_240347_a_((Block)block, (String)("_" + front))).func_240349_a_(StockTextureAliases.field_240412_i_, ModelTextures.func_240347_a_((Block)block, (String)("_" + side))).func_240349_a_(StockTextureAliases.field_240409_f_, ModelTextures.func_240347_a_((Block)block, (String)("_" + top))).func_240349_a_(StockTextureAliases.field_240411_h_, ModelTextures.func_240347_a_((Block)block, (String)("_" + back))), generators.field_239835_b_);
    }

    private static void registerCable(BlockModelProvider generators) {
        FinishedMultiPartBlockState generator = FinishedMultiPartBlockState.func_240106_a_((Block)((Block)Registry.ModBlocks.CABLE.get()));
        ResourceLocation coreFacing = new ResourceLocation("computercraft", "block/cable_core_facing");
        generator.func_240108_a_(IMultiPartPredicateBuilder.func_240090_b_((IMultiPartPredicateBuilder[])new IMultiPartPredicateBuilder[]{BlockModelGenerator.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST).func_240098_a_((Property)BlockCable.UP, (Comparable)Boolean.valueOf(true)), BlockModelGenerator.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST).func_240098_a_((Property)BlockCable.DOWN, (Comparable)Boolean.valueOf(true))}), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)coreFacing).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelFields.Rotation.R90));
        generator.func_240108_a_(IMultiPartPredicateBuilder.func_240090_b_((IMultiPartPredicateBuilder[])new IMultiPartPredicateBuilder[]{BlockModelGenerator.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST), BlockModelGenerator.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST).func_240098_a_((Property)BlockCable.NORTH, (Comparable)Boolean.valueOf(true)), BlockModelGenerator.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST).func_240098_a_((Property)BlockCable.SOUTH, (Comparable)Boolean.valueOf(true))}), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)coreFacing).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R0));
        generator.func_240108_a_(IMultiPartPredicateBuilder.func_240090_b_((IMultiPartPredicateBuilder[])new IMultiPartPredicateBuilder[]{BlockModelGenerator.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN).func_240098_a_((Property)BlockCable.EAST, (Comparable)Boolean.valueOf(true)), BlockModelGenerator.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN).func_240098_a_((Property)BlockCable.WEST, (Comparable)Boolean.valueOf(true))}), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)coreFacing).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelFields.Rotation.R90));
        ResourceLocation core = new ResourceLocation("computercraft", "block/cable_core_any");
        ArrayList<IMultiPartPredicateBuilder.Properties> rightAngles = new ArrayList<IMultiPartPredicateBuilder.Properties>();
        for (int i = 0; i < DirectionUtil.FACINGS.length; ++i) {
            for (int j = i; j < DirectionUtil.FACINGS.length; ++j) {
                if (DirectionUtil.FACINGS[i].func_176740_k() == DirectionUtil.FACINGS[j].func_176740_k()) continue;
                rightAngles.add(new IMultiPartPredicateBuilder.Properties().func_240098_a_((Property)BlockCable.CABLE, (Comparable)Boolean.valueOf(true)).func_240098_a_((Property)CABLE_DIRECTIONS[i], (Comparable)Boolean.valueOf(true)).func_240098_a_((Property)CABLE_DIRECTIONS[j], (Comparable)Boolean.valueOf(true)));
            }
        }
        generator.func_240108_a_(IMultiPartPredicateBuilder.func_240090_b_((IMultiPartPredicateBuilder[])rightAngles.toArray(new IMultiPartPredicateBuilder[0])), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)core));
        ResourceLocation arm = new ResourceLocation("computercraft", "block/cable_arm");
        for (Direction direction : DirectionUtil.FACINGS) {
            generator.func_240108_a_((IMultiPartPredicateBuilder)new IMultiPartPredicateBuilder.Properties().func_240098_a_((Property)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(true)), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)arm).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelGenerator.toXAngle(direction.func_176734_d())).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelGenerator.toYAngle(direction.func_176734_d())));
        }
        for (Direction direction : DirectionUtil.FACINGS) {
            for (boolean on : BOOLEANS) {
                for (boolean peripheral : BOOLEANS) {
                    String suffix = (on ? "_on" : "_off") + (peripheral ? "_peripheral" : "");
                    generator.func_240108_a_((IMultiPartPredicateBuilder)new IMultiPartPredicateBuilder.Properties().func_240098_a_(BlockCable.MODEM, (Comparable)((Object)CableModemVariant.from(direction, on, peripheral))), BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)new ResourceLocation("computercraft", "block/wired_modem" + suffix)).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelGenerator.toXAngle(direction)).func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelGenerator.toYAngle(direction)));
                }
            }
        }
        generators.field_239834_a_.accept(generator);
    }

    private static IMultiPartPredicateBuilder.Properties cableNoNeighbour(Direction ... directions) {
        IMultiPartPredicateBuilder.Properties condition = new IMultiPartPredicateBuilder.Properties().func_240098_a_((Property)BlockCable.CABLE, (Comparable)Boolean.valueOf(true));
        for (Direction direction : directions) {
            condition.func_240098_a_((Property)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(false));
        }
        return condition;
    }

    private static void registerTurtleUpgrade(BlockModelProvider generators, String name, String texture) {
        TURTLE_UPGRADE_LEFT.func_240234_a_(new ResourceLocation("computercraft", name + "_left"), ModelTextures.func_240350_a_((ResourceLocation)new ResourceLocation("computercraft", texture)), generators.field_239835_b_);
        TURTLE_UPGRADE_RIGHT.func_240234_a_(new ResourceLocation("computercraft", name + "_right"), ModelTextures.func_240350_a_((ResourceLocation)new ResourceLocation("computercraft", texture)), generators.field_239835_b_);
    }

    private static void registerTurtleModem(BlockModelProvider generators, String name, String texture) {
        BlockModelGenerator.registerTurtleUpgrade(generators, name + "_off", texture);
        BlockModelGenerator.registerTurtleUpgrade(generators, name + "_on", texture + "_on");
    }

    private static BlockModelFields.Rotation toXAngle(Direction direction) {
        switch (direction) {
            default: {
                return BlockModelFields.Rotation.R0;
            }
            case UP: {
                return BlockModelFields.Rotation.R270;
            }
            case DOWN: 
        }
        return BlockModelFields.Rotation.R90;
    }

    private static BlockModelFields.Rotation toYAngle(Direction direction) {
        switch (direction) {
            default: {
                return BlockModelFields.Rotation.R0;
            }
            case NORTH: {
                return BlockModelFields.Rotation.R0;
            }
            case SOUTH: {
                return BlockModelFields.Rotation.R180;
            }
            case EAST: {
                return BlockModelFields.Rotation.R90;
            }
            case WEST: 
        }
        return BlockModelFields.Rotation.R270;
    }

    private static BlockStateVariantBuilder createHorizontalFacingDispatch() {
        BlockStateVariantBuilder.One dispatch = BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208157_J);
        for (Direction direction : BlockStateProperties.field_208157_J.func_177700_c()) {
            dispatch.func_240143_a_((Comparable)direction, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelGenerator.toYAngle(direction)));
        }
        return dispatch;
    }

    private static BlockStateVariantBuilder createVerticalFacingDispatch(Property<Direction> property) {
        BlockStateVariantBuilder.One dispatch = BlockStateVariantBuilder.func_240133_a_(property);
        for (Direction direction : property.func_177700_c()) {
            dispatch.func_240143_a_((Comparable)direction, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelGenerator.toXAngle(direction)));
        }
        return dispatch;
    }

    private static BlockStateVariantBuilder createFacingDispatch() {
        BlockStateVariantBuilder.One dispatch = BlockStateVariantBuilder.func_240133_a_((Property)BlockStateProperties.field_208155_H);
        for (Direction direction : BlockStateProperties.field_208155_H.func_177700_c()) {
            dispatch.func_240143_a_((Comparable)direction, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240201_b_, (Object)BlockModelGenerator.toYAngle(direction)).func_240198_a_(BlockModelFields.field_240200_a_, (Object)BlockModelGenerator.toXAngle(direction)));
        }
        return dispatch;
    }

    private static <T extends Comparable<T>> BlockStateVariantBuilder createModelDispatch(Property<T> property, Function<T, ResourceLocation> makeModel) {
        BlockStateVariantBuilder.One variant = BlockStateVariantBuilder.func_240133_a_(property);
        for (Comparable value : property.func_177700_c()) {
            variant.func_240143_a_(value, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)makeModel.apply(value)));
        }
        return variant;
    }

    private static <T extends Comparable<T>, U extends Comparable<U>> BlockStateVariantBuilder createModelDispatch(Property<T> propertyT, Property<U> propertyU, BiFunction<T, U, ResourceLocation> makeModel) {
        BlockStateVariantBuilder.Two variant = BlockStateVariantBuilder.func_240134_a_(propertyT, propertyU);
        for (Comparable valueT : propertyT.func_177700_c()) {
            for (Comparable valueU : propertyU.func_177700_c()) {
                variant.func_240149_a_(valueT, valueU, BlockModelDefinition.func_240194_a_().func_240198_a_(BlockModelFields.field_240202_c_, (Object)makeModel.apply(valueT, valueU)));
            }
        }
        return variant;
    }
}

