/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;

public enum UserLevel implements Predicate<CommandSource>
{
    OWNER,
    OP,
    OWNER_OP,
    ANYONE;


    public int toLevel() {
        switch (this) {
            case OWNER: {
                return 4;
            }
            case OP: 
            case OWNER_OP: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public boolean test(CommandSource source) {
        if (this == ANYONE) {
            return true;
        }
        if (this == OWNER) {
            return UserLevel.isOwner(source);
        }
        if (this == OWNER_OP && UserLevel.isOwner(source)) {
            return true;
        }
        return source.func_197034_c(this.toLevel());
    }

    public static UserLevel union(UserLevel left, UserLevel right) {
        if (left == right) {
            return left;
        }
        if (left == ANYONE || right == ANYONE) {
            return ANYONE;
        }
        if (left == OWNER) {
            return right;
        }
        if (right == OWNER) {
            return left;
        }
        return OWNER_OP;
    }

    private static boolean isOwner(CommandSource source) {
        MinecraftServer server = source.func_197028_i();
        Entity sender = source.func_197022_f();
        return server.func_71262_S() ? source.func_197022_f() == null && source.func_197034_c(4) && source.func_197037_c().equals("Server") : sender instanceof PlayerEntity && server.func_213199_b(((PlayerEntity)sender).func_146103_bH());
    }
}

