/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.builder;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.text.ChatHelpers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public final class HelpingArgumentBuilder
extends LiteralArgumentBuilder<CommandSource> {
    private final Collection<HelpingArgumentBuilder> children = new ArrayList<HelpingArgumentBuilder>();
    private static final TextFormatting HEADER = TextFormatting.LIGHT_PURPLE;
    private static final TextFormatting SYNOPSIS = TextFormatting.AQUA;
    private static final TextFormatting NAME = TextFormatting.GREEN;

    private HelpingArgumentBuilder(String literal) {
        super(literal);
    }

    public static HelpingArgumentBuilder choice(String literal) {
        return new HelpingArgumentBuilder(literal);
    }

    public LiteralArgumentBuilder<CommandSource> requires(Predicate<CommandSource> requirement) {
        throw new IllegalStateException("Cannot use requires on a HelpingArgumentBuilder");
    }

    public Predicate<CommandSource> getRequirement() {
        List requirements = Stream.concat(this.children.stream().map(ArgumentBuilder::getRequirement), this.getArguments().stream().map(CommandNode::getRequirement)).collect(Collectors.toList());
        UserLevel userLevel = UserLevel.OWNER;
        for (Predicate requirement : requirements) {
            if (!(requirement instanceof UserLevel)) {
                return x -> requirements.stream().anyMatch(y -> y.test(x));
            }
            userLevel = UserLevel.union(userLevel, (UserLevel)requirement);
        }
        return userLevel;
    }

    public LiteralArgumentBuilder<CommandSource> executes(Command<CommandSource> command) {
        throw new IllegalStateException("Cannot use executes on a HelpingArgumentBuilder");
    }

    public LiteralArgumentBuilder<CommandSource> then(ArgumentBuilder<CommandSource, ?> argument) {
        if (this.getRedirect() != null) {
            throw new IllegalStateException("Cannot add children to a redirected node");
        }
        if (argument instanceof HelpingArgumentBuilder) {
            this.children.add((HelpingArgumentBuilder)argument);
        } else if (argument instanceof LiteralArgumentBuilder) {
            super.then(argument);
        } else {
            throw new IllegalStateException("HelpingArgumentBuilder can only accept literal children");
        }
        return this;
    }

    public LiteralArgumentBuilder<CommandSource> then(CommandNode<CommandSource> argument) {
        if (!(argument instanceof LiteralCommandNode)) {
            throw new IllegalStateException("HelpingArgumentBuilder can only accept literal children");
        }
        return (LiteralArgumentBuilder)super.then(argument);
    }

    public LiteralCommandNode<CommandSource> build() {
        return this.buildImpl(this.getLiteral().replace('-', '_'), this.getLiteral());
    }

    private LiteralCommandNode<CommandSource> build(@Nonnull String id, @Nonnull String command) {
        return this.buildImpl(id + "." + this.getLiteral().replace('-', '_'), command + " " + this.getLiteral());
    }

    private LiteralCommandNode<CommandSource> buildImpl(String id, String command) {
        LiteralCommandNode node;
        HelpCommand helpCommand = new HelpCommand(id, command);
        helpCommand.node = node = new LiteralCommandNode(this.getLiteral(), (Command)helpCommand, this.getRequirement(), this.getRedirect(), this.getRedirectModifier(), this.isFork());
        LiteralArgumentBuilder helpNode = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").executes((Command)helpCommand);
        for (CommandNode child : this.getArguments()) {
            node.addChild(child);
            helpNode.then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)child.getName()).requires(child.getRequirement())).executes(HelpingArgumentBuilder.helpForChild((CommandNode<CommandSource>)child, id, command))).build());
        }
        for (HelpingArgumentBuilder childBuilder : this.children) {
            LiteralCommandNode<CommandSource> child = childBuilder.build(id, command);
            node.addChild(child);
            helpNode.then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)child.getName()).requires(child.getRequirement())).executes(HelpingArgumentBuilder.helpForChild(child, id, command))).redirect(child.getChild("help"))).build());
        }
        node.addChild((CommandNode)helpNode.build());
        return node;
    }

    private static Command<CommandSource> helpForChild(CommandNode<CommandSource> node, String id, String command) {
        return context -> {
            ((CommandSource)context.getSource()).func_197030_a(HelpingArgumentBuilder.getHelp((CommandContext<CommandSource>)context, node, id + "." + node.getName().replace('-', '_'), command + " " + node.getName()), false);
            return 0;
        };
    }

    private static ITextComponent getHelp(CommandContext<CommandSource> context, CommandNode<CommandSource> node, String id, String command) {
        CommandDispatcher dispatcher = ((CommandSource)context.getSource()).func_197028_i().func_195571_aL().func_197054_a();
        LiteralCommandNode temp = new LiteralCommandNode("_", null, x -> true, null, null, false);
        temp.addChild(node);
        String usage = ((String)dispatcher.getSmartUsage((CommandNode)temp, context.getSource()).get(node)).substring(node.getName().length());
        IFormattableTextComponent output = new StringTextComponent("").func_230529_a_((ITextComponent)ChatHelpers.coloured("/" + command + usage, HEADER)).func_240702_b_(" ").func_230529_a_((ITextComponent)ChatHelpers.coloured(ChatHelpers.translate("commands." + id + ".synopsis"), SYNOPSIS)).func_240702_b_("\n").func_230529_a_((ITextComponent)ChatHelpers.translate("commands." + id + ".desc"));
        for (CommandNode child : node.getChildren()) {
            if (!child.getRequirement().test(context.getSource()) || !(child instanceof LiteralCommandNode)) continue;
            output.func_240702_b_("\n");
            IFormattableTextComponent component = ChatHelpers.coloured(child.getName(), NAME);
            component.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + command + " " + child.getName()));
            output.func_230529_a_((ITextComponent)component);
            output.func_240702_b_(" - ").func_230529_a_((ITextComponent)ChatHelpers.translate("commands." + id + "." + child.getName() + ".synopsis"));
        }
        return output;
    }

    private static final class HelpCommand
    implements Command<CommandSource> {
        private final String id;
        private final String command;
        LiteralCommandNode<CommandSource> node;

        private HelpCommand(String id, String command) {
            this.id = id;
            this.command = command;
        }

        public int run(CommandContext<CommandSource> context) {
            ((CommandSource)context.getSource()).func_197030_a(HelpingArgumentBuilder.getHelp((CommandContext<CommandSource>)context, (CommandNode<CommandSource>)this.node, this.id, this.command), false);
            return 0;
        }
    }
}

