/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.LockCode;
import net.minecraftforge.common.util.NonNullConsumer;

public abstract class TileComputerBase
extends TileGeneric
implements IComputerTile,
ITickableTileEntity,
INameable,
INamedContainerProvider {
    private static final String NBT_ID = "ComputerId";
    private static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private int instanceID = -1;
    private int computerID = -1;
    protected String label = null;
    private boolean on = false;
    boolean startOn = false;
    private boolean fresh = false;
    private int invalidSides = 0;
    private final NonNullConsumer<Object>[] invalidate;
    private LockCode lockCode = LockCode.field_180162_a;
    private final ComputerFamily family;

    public TileComputerBase(TileEntityType<? extends TileGeneric> type, ComputerFamily family) {
        super(type);
        this.family = family;
        this.invalidate = new NonNullConsumer[6];
        NonNullConsumer[] invalidate = this.invalidate;
        for (Direction direction : Direction.values()) {
            int mask = 1 << direction.ordinal();
            invalidate[direction.ordinal()] = o -> this.invalidSides |= mask;
        }
    }

    protected void unload() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.close();
        }
        this.instanceID = -1;
    }

    @Override
    public void destroy() {
        this.unload();
        for (Direction dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.func_145831_w(), this.func_174877_v(), dir);
        }
    }

    public void onChunkUnloaded() {
        this.unload();
    }

    public void func_145843_s() {
        this.unload();
        super.func_145843_s();
    }

    protected boolean canNameWithTag(PlayerEntity player) {
        return false;
    }

    @Override
    public boolean isUsable(PlayerEntity player) {
        return super.isUsable(player) && LockableTileEntity.func_213905_a((PlayerEntity)player, (LockCode)this.lockCode, (ITextComponent)this.func_145748_c_());
    }

    @Override
    @Nonnull
    public ActionResultType onActivate(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack currentItem = player.func_184586_b(hand);
        if (!currentItem.func_190926_b() && currentItem.func_77973_b() == Items.field_151057_cb && this.canNameWithTag(player) && currentItem.func_82837_s()) {
            if (!this.func_145831_w().field_72995_K) {
                this.setLabel(currentItem.func_200301_q().getString());
                currentItem.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef()) {
            if (!this.func_145831_w().field_72995_K && this.isUsable(player)) {
                ServerComputer computer = this.createServerComputer();
                computer.turnOn();
                ItemStack stack = this.func_195044_w().func_177230_c() instanceof BlockComputerBase ? ((BlockComputerBase)this.func_195044_w().func_177230_c()).getItem(this) : ItemStack.field_190927_a;
                new ComputerContainerData(computer, stack).open(player, this);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        this.updateInputAt(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        this.updateInputAt(neighbour);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.computerID < 0 && !this.startOn) {
            return;
        }
        ServerComputer computer = this.createServerComputer();
        if (this.invalidSides != 0) {
            for (Direction direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(computer, direction);
            }
        }
        if (this.startOn || this.fresh && this.on) {
            computer.turnOn();
            this.startOn = false;
        }
        computer.keepAlive();
        this.fresh = false;
        this.computerID = computer.getID();
        this.label = computer.getLabel();
        this.on = computer.isOn();
        this.updateBlockState(computer.getState());
        if (computer.hasOutputChanged()) {
            this.updateOutput();
        }
    }

    protected abstract void updateBlockState(ComputerState var1);

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        if (this.computerID >= 0) {
            nbt.func_74768_a(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.func_74778_a(NBT_LABEL, this.label);
        }
        nbt.func_74757_a(NBT_ON, this.on);
        this.lockCode.func_180157_a(nbt);
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.computerID = nbt.func_74764_b(NBT_ID) ? nbt.func_74762_e(NBT_ID) : -1;
        this.label = nbt.func_74764_b(NBT_LABEL) ? nbt.func_74779_i(NBT_LABEL) : null;
        this.on = this.startOn = nbt.func_74767_n(NBT_ON);
        this.lockCode = LockCode.func_180158_b((CompoundNBT)nbt);
    }

    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return false;
    }

    protected abstract Direction getDirection();

    protected ComputerSide remapToLocalSide(Direction globalSide) {
        return this.remapLocalSide(DirectionUtil.toLocal(this.getDirection(), globalSide));
    }

    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        return localSide;
    }

    private void updateRedstoneInput(@Nonnull ServerComputer computer, Direction dir, BlockPos targetPos) {
        Direction offsetSide = dir.func_176734_d();
        ComputerSide localDir = this.remapToLocalSide(dir);
        computer.setRedstoneInput(localDir, RedstoneUtil.getRedstoneInput(this.field_145850_b, targetPos, dir));
        computer.setBundledRedstoneInput(localDir, BundledRedstone.getOutput(this.func_145831_w(), targetPos, offsetSide));
    }

    private void refreshPeripheral(@Nonnull ServerComputer computer, Direction dir) {
        this.invalidSides &= ~(1 << dir.ordinal());
        ComputerSide localDir = this.remapToLocalSide(dir);
        if (this.isPeripheralBlockedOnSide(localDir)) {
            return;
        }
        Direction offsetSide = dir.func_176734_d();
        IPeripheral peripheral = Peripherals.getPeripheral(this.func_145831_w(), this.func_174877_v().func_177972_a(dir), offsetSide, this.invalidate[dir.ordinal()]);
        computer.setPeripheral(localDir, peripheral);
    }

    public void updateInputsImmediately() {
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateInputsImmediately(computer);
        }
    }

    private void updateInputsImmediately(@Nonnull ServerComputer computer) {
        BlockPos pos = this.func_174877_v();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.func_177972_a(dir));
            this.refreshPeripheral(computer, dir);
        }
    }

    private void updateInputAt(@Nonnull BlockPos neighbour) {
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (Direction dir : DirectionUtil.FACINGS) {
            BlockPos offset = this.func_174877_v().func_177972_a(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(computer, dir, offset);
            this.invalidSides |= 1 << dir.ordinal();
            return;
        }
        BlockPos pos = this.func_174877_v();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.func_177972_a(dir));
        }
        this.invalidSides = 63;
    }

    public void updateOutput() {
        this.updateBlock();
        for (Direction dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.func_145831_w(), this.func_174877_v(), dir);
        }
    }

    protected abstract ServerComputer createComputer(int var1);

    @Override
    public final int getComputerID() {
        return this.computerID;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setComputerID(int id) {
        if (this.func_145831_w().field_72995_K || this.computerID == id) {
            return;
        }
        this.computerID = id;
        this.func_70296_d();
    }

    @Override
    public final void setLabel(String label) {
        if (this.func_145831_w().field_72995_K || Objects.equals(this.label, label)) {
            return;
        }
        this.label = label;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setLabel(label);
        }
        this.func_70296_d();
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Nonnull
    public final ServerComputer createServerComputer() {
        if (this.func_145831_w().field_72995_K) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        boolean changed = false;
        ServerComputer computer = ServerContext.get(this.func_145831_w().func_73046_m()).registry().get(this.instanceID);
        if (computer == null) {
            if (this.computerID < 0) {
                this.computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(this.field_145850_b, "computer");
                this.updateBlock();
            }
            computer = this.createComputer(this.computerID);
            this.instanceID = computer.register();
            this.fresh = true;
            changed = true;
        }
        if (changed) {
            this.updateInputsImmediately(computer);
        }
        return computer;
    }

    @Nullable
    public ServerComputer getServerComputer() {
        return this.func_145831_w().field_72995_K ? null : ServerContext.get(this.func_145831_w().func_73046_m()).registry().get(this.instanceID);
    }

    @Nonnull
    public final SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.label != null) {
            nbt.func_74778_a(NBT_LABEL, this.label);
        }
        if (this.computerID >= 0) {
            nbt.func_74768_a(NBT_ID, this.computerID);
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT nbt) {
        this.label = nbt.func_74764_b(NBT_LABEL) ? nbt.func_74779_i(NBT_LABEL) : null;
        this.computerID = nbt.func_74764_b(NBT_ID) ? nbt.func_74762_e(NBT_ID) : -1;
    }

    protected void transferStateFrom(TileComputerBase copy) {
        if (copy.computerID != this.computerID || copy.instanceID != this.instanceID) {
            this.unload();
            this.instanceID = copy.instanceID;
            this.computerID = copy.computerID;
            this.label = copy.label;
            this.on = copy.on;
            this.startOn = copy.startOn;
            this.lockCode = copy.lockCode;
            this.updateBlock();
        }
        copy.instanceID = -1;
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.func_145818_k_() ? new StringTextComponent(this.label) : new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public boolean func_145818_k_() {
        return !Strings.isNullOrEmpty((String)this.label);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.func_145818_k_() ? new StringTextComponent(this.label) : null;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }
}

