/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.metrics.basic;

import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.shared.computer.metrics.basic.Aggregate;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AggregatedMetric {
    private static final String TRANSLATION_PREFIX = "tracking_field.computercraft.";
    private final Metric metric;
    private final Aggregate aggregate;

    public AggregatedMetric(Metric metric, Aggregate aggregate) {
        this.metric = metric;
        this.aggregate = aggregate;
    }

    public Metric metric() {
        return this.metric;
    }

    public Aggregate aggregate() {
        return this.aggregate;
    }

    public static Stream<AggregatedMetric> aggregatedMetrics() {
        Metrics.init();
        return Metric.metrics().values().stream().flatMap(m -> m instanceof Metric.Counter ? Stream.of(new AggregatedMetric((Metric)m, Aggregate.NONE)) : Arrays.stream(Aggregate.values()).map(a -> new AggregatedMetric((Metric)m, (Aggregate)((Object)((Object)a)))));
    }

    public String name() {
        return this.aggregate() == Aggregate.NONE ? this.metric.name() : this.metric().name() + "_" + this.aggregate().id();
    }

    public ITextComponent displayName() {
        TranslationTextComponent name = new TranslationTextComponent(TRANSLATION_PREFIX + this.metric().name() + ".name");
        return this.aggregate() == Aggregate.NONE ? name : new TranslationTextComponent(TRANSLATION_PREFIX + this.aggregate().id(), new Object[]{name});
    }
}

