/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpeakerPlayClientMessage
implements NetworkMessage {
    private final UUID source;
    private final SpeakerPosition.Message pos;
    private final ResourceLocation sound;
    private final float volume;
    private final float pitch;

    public SpeakerPlayClientMessage(UUID source, SpeakerPosition pos, ResourceLocation event, float volume, float pitch) {
        this.source = source;
        this.pos = pos.asMessage();
        this.sound = event;
        this.volume = volume;
        this.pitch = pitch;
    }

    public SpeakerPlayClientMessage(PacketBuffer buf) {
        this.source = buf.func_179253_g();
        this.pos = SpeakerPosition.Message.read(buf);
        this.sound = buf.func_192575_l();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        buf.func_179252_a(this.source);
        this.pos.write(buf);
        buf.func_192572_a(this.sound);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkEvent.Context context) {
        SpeakerManager.getSound(this.source).playSound(this.pos.reify(), this.sound, this.volume, this.pitch);
    }
}

