/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleRefuelEvent;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TurtleRefuelCommand
implements ITurtleCommand {
    private final int limit;

    public TurtleRefuelCommand(int limit) {
        this.limit = limit;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        int slot = turtle.getSelectedSlot();
        ItemStack stack = turtle.getInventory().func_70301_a(slot);
        if (stack.func_190926_b()) {
            return TurtleCommandResult.failure("No items to combust");
        }
        TurtleRefuelEvent event = new TurtleRefuelEvent(turtle, stack);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        if (event.getHandler() == null) {
            return TurtleCommandResult.failure("Items not combustible");
        }
        if (this.limit != 0) {
            turtle.addFuel(event.getHandler().refuel(turtle, stack, slot, this.limit));
            turtle.playAnimation(TurtleAnimation.WAIT);
        }
        return TurtleCommandResult.success();
    }
}

