/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.hooks.forge;

import me.shedaniel.architectury.hooks.forge.FluidStackHooksForge;
import me.shedaniel.architectury.utils.Fraction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidStackHooksImpl {
    public static ITextComponent getName(me.shedaniel.architectury.fluid.FluidStack stack) {
        return stack.getFluid().getAttributes().getDisplayName(FluidStackHooksForge.toForge(stack));
    }

    public static String getTranslationKey(me.shedaniel.architectury.fluid.FluidStack stack) {
        return stack.getFluid().getAttributes().getTranslationKey(FluidStackHooksForge.toForge(stack));
    }

    public static me.shedaniel.architectury.fluid.FluidStack read(PacketBuffer buf) {
        return FluidStackHooksForge.fromForge(FluidStack.readFromPacket((PacketBuffer)buf));
    }

    public static void write(me.shedaniel.architectury.fluid.FluidStack stack, PacketBuffer buf) {
        FluidStackHooksForge.toForge(stack).writeToPacket(buf);
    }

    public static me.shedaniel.architectury.fluid.FluidStack read(CompoundNBT tag) {
        return FluidStackHooksForge.fromForge(FluidStack.loadFluidStackFromNBT((CompoundNBT)tag));
    }

    public static CompoundNBT write(me.shedaniel.architectury.fluid.FluidStack stack, CompoundNBT tag) {
        return FluidStackHooksForge.toForge(stack).writeToNBT(tag);
    }

    public static Fraction bucketAmount() {
        return Fraction.ofWhole(1000L);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getStillTexture(@Nullable IBlockDisplayReader level, @Nullable BlockPos pos, @NotNull FluidState state) {
        if (state.func_206886_c() == Fluids.field_204541_a) {
            return null;
        }
        ResourceLocation texture = state.func_206886_c().getAttributes().getStillTexture(level, pos);
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getStillTexture(@NotNull me.shedaniel.architectury.fluid.FluidStack stack) {
        if (stack.getFluid() == Fluids.field_204541_a) {
            return null;
        }
        ResourceLocation texture = stack.getFluid().getAttributes().getStillTexture(FluidStackHooksForge.toForge(stack));
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getStillTexture(@NotNull Fluid fluid) {
        if (fluid == Fluids.field_204541_a) {
            return null;
        }
        ResourceLocation texture = fluid.getAttributes().getStillTexture();
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getFlowingTexture(@Nullable IBlockDisplayReader level, @Nullable BlockPos pos, @NotNull FluidState state) {
        if (state.func_206886_c() == Fluids.field_204541_a) {
            return null;
        }
        ResourceLocation texture = state.func_206886_c().getAttributes().getFlowingTexture(level, pos);
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getFlowingTexture(@NotNull me.shedaniel.architectury.fluid.FluidStack stack) {
        if (stack.getFluid() == Fluids.field_204541_a) {
            return null;
        }
        ResourceLocation texture = stack.getFluid().getAttributes().getFlowingTexture(FluidStackHooksForge.toForge(stack));
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getFlowingTexture(@NotNull Fluid fluid) {
        if (fluid == Fluids.field_204541_a) {
            return null;
        }
        ResourceLocation texture = fluid.getAttributes().getFlowingTexture();
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(@Nullable IBlockDisplayReader level, @Nullable BlockPos pos, @NotNull FluidState state) {
        if (state.func_206886_c() == Fluids.field_204541_a) {
            return -1;
        }
        return state.func_206886_c().getAttributes().getColor(level, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(@NotNull me.shedaniel.architectury.fluid.FluidStack stack) {
        if (stack.getFluid() == Fluids.field_204541_a) {
            return -1;
        }
        return stack.getFluid().getAttributes().getColor(FluidStackHooksForge.toForge(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(@NotNull Fluid fluid) {
        if (fluid == Fluids.field_204541_a) {
            return -1;
        }
        return fluid.getAttributes().getColor();
    }
}

