/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraph;
import com.refinedmods.refinedstorage.api.network.NetworkType;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.security.ISecurityManager;
import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.util.Action;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;

public interface INetwork {
    public int getEnergyUsage();

    public IEnergyStorage getEnergyStorage();

    public NetworkType getType();

    public boolean canRun();

    public void update();

    public void onRemoved();

    public INetworkNodeGraph getNodeGraph();

    public ISecurityManager getSecurityManager();

    public ICraftingManager getCraftingManager();

    public IItemGridHandler getItemGridHandler();

    public IFluidGridHandler getFluidGridHandler();

    public INetworkItemManager getNetworkItemManager();

    public IStorageCache<ItemStack> getItemStorageCache();

    public IStorageCache<FluidStack> getFluidStorageCache();

    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack var1, int var2, Action var3);

    @Nonnull
    default public ItemStack insertItemTracked(@Nonnull ItemStack stack, int size) {
        int remainder = this.getCraftingManager().track(stack, size);
        if (remainder == 0) {
            return ItemStack.field_190927_a;
        }
        return this.insertItem(stack, remainder, Action.PERFORM);
    }

    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack var1, int var2, int var3, Action var4, Predicate<IStorage<ItemStack>> var5);

    @Nonnull
    default public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, Action action) {
        return this.extractItem(stack, size, flags, action, s -> true);
    }

    @Nonnull
    default public ItemStack extractItem(@Nonnull ItemStack stack, int size, Action action) {
        return this.extractItem(stack, size, 1, action);
    }

    @Nonnull
    public FluidStack insertFluid(@Nonnull FluidStack var1, int var2, Action var3);

    @Nonnull
    default public FluidStack insertFluidTracked(@Nonnull FluidStack stack, int size) {
        int remainder = this.getCraftingManager().track(stack, size);
        if (remainder == 0) {
            return FluidStack.EMPTY;
        }
        return this.insertFluid(stack, remainder, Action.PERFORM);
    }

    @Nonnull
    public FluidStack extractFluid(@Nonnull FluidStack var1, int var2, int var3, Action var4, Predicate<IStorage<FluidStack>> var5);

    @Nonnull
    default public FluidStack extractFluid(FluidStack stack, int size, int flags, Action action) {
        return this.extractFluid(stack, size, flags, action, s -> true);
    }

    @Nonnull
    default public FluidStack extractFluid(FluidStack stack, int size, Action action) {
        return this.extractFluid(stack, size, 1, action);
    }

    public IStorageTracker<ItemStack> getItemStorageTracker();

    public IStorageTracker<FluidStack> getFluidStorageTracker();

    public World getWorld();

    public BlockPos getPosition();

    public INetwork readFromNbt(CompoundNBT var1);

    public CompoundNBT writeToNbt(CompoundNBT var1);

    public long[] getTickTimes();

    public void markDirty();
}

