/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.DestructorTile;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DestructorNetworkNode
extends NetworkNode
implements IComparable,
IWhitelistBlacklist,
IType,
ICoverable {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "destructor");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_PICKUP = "Pickup";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 20;
    private final BaseItemHandler itemFilters = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final FluidInventory fluidFilters = new FluidInventory(9).addListener(new NetworkNodeFluidInventoryListener(this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, UpgradeItem.Type.SPEED, UpgradeItem.Type.SILK_TOUCH, UpgradeItem.Type.FORTUNE_1, UpgradeItem.Type.FORTUNE_2, UpgradeItem.Type.FORTUNE_3).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        this.tool = this.createTool();
    });
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private boolean pickupItem = false;
    private ItemStack tool = this.createTool();
    private final CoverManager coverManager = new CoverManager(this);

    public DestructorNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getDestructor().getUsage() + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        super.update();
        if (this.canUpdate() && this.ticks % this.upgrades.getSpeed(20, 4) == 0 && this.world.func_195588_v(this.pos)) {
            if (this.type == 0) {
                if (this.pickupItem) {
                    this.pickupItems();
                } else {
                    this.breakBlock();
                }
            } else if (this.type == 1) {
                this.breakFluid();
            }
        }
    }

    private void pickupItems() {
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        ArrayList droppedItems = new ArrayList();
        Chunk chunk = this.world.func_175726_f(front);
        chunk.func_177414_a(null, new AxisAlignedBB(front), droppedItems, null);
        for (Entity entity : droppedItems) {
            ItemStack droppedItem;
            if (!(entity instanceof ItemEntity) || !IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, droppedItem = ((ItemEntity)entity).func_92059_d()) || !this.network.insertItem(droppedItem, droppedItem.func_190916_E(), Action.SIMULATE).func_190926_b()) continue;
            this.network.insertItemTracked(droppedItem.func_77946_l(), droppedItem.func_190916_E());
            entity.func_70106_y();
            break;
        }
    }

    private void breakBlock() {
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        BlockState frontBlockState = this.world.func_180495_p(front);
        Block frontBlock = frontBlockState.func_177230_c();
        ItemStack frontStack = frontBlock.getPickBlock(frontBlockState, (RayTraceResult)new BlockRayTraceResult(Vector3d.field_186680_a, this.getDirection().func_176734_d(), front, false), (IBlockReader)this.world, front, (PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)this.world, this.getOwner()));
        if (!frontStack.func_190926_b() && IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, frontStack) && (double)frontBlockState.func_185887_b((IBlockReader)this.world, front) != -1.0) {
            List drops = Block.func_220077_a((BlockState)frontBlockState, (ServerWorld)((ServerWorld)this.world), (BlockPos)front, (TileEntity)this.world.func_175625_s(front), (Entity)WorldUtils.getFakePlayer((ServerWorld)this.world, this.getOwner()), (ItemStack)this.tool);
            for (ItemStack drop : drops) {
                if (this.network.insertItem(drop, drop.func_190916_E(), Action.SIMULATE).func_190926_b()) continue;
                return;
            }
            BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(this.world, front, frontBlockState, (PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)this.world, this.getOwner()));
            if (!MinecraftForge.EVENT_BUS.post((Event)e)) {
                frontBlock.func_176208_a(this.world, front, frontBlockState, (PlayerEntity)WorldUtils.getFakePlayer((ServerWorld)this.world, this.getOwner()));
                this.world.func_217377_a(front, false);
                for (ItemStack drop : drops) {
                    if (this.network == null) {
                        InventoryHelper.func_180173_a((World)this.world, (double)front.func_177958_n(), (double)front.func_177956_o(), (double)front.func_177952_p(), (ItemStack)drop);
                        continue;
                    }
                    this.network.insertItemTracked(drop, drop.func_190916_E());
                }
            }
        }
    }

    private void breakFluid() {
        FluidStack simulatedDrain;
        IFluidBlock fluidBlock;
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        BlockState frontBlockState = this.world.func_180495_p(front);
        Block frontBlock = frontBlockState.func_177230_c();
        if (frontBlock instanceof FlowingFluidBlock) {
            FlowingFluid fluid;
            FluidStack stack;
            if ((Integer)frontBlockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0 && IWhitelistBlacklist.acceptsFluid(this.fluidFilters, this.mode, this.compare, stack = new FluidStack((Fluid)(fluid = ((FlowingFluidBlock)frontBlock).getFluid()), 1000)) && this.network.insertFluid(stack, stack.getAmount(), Action.SIMULATE).isEmpty()) {
                this.network.insertFluidTracked(stack, stack.getAmount());
                this.world.func_180501_a(front, Blocks.field_150350_a.func_176223_P(), 11);
            }
        } else if (frontBlock instanceof IFluidBlock && (fluidBlock = (IFluidBlock)frontBlock).canDrain(this.world, front) && IWhitelistBlacklist.acceptsFluid(this.fluidFilters, this.mode, this.compare, simulatedDrain = fluidBlock.drain(this.world, front, IFluidHandler.FluidAction.SIMULATE)) && this.network.insertFluid(simulatedDrain, simulatedDrain.getAmount(), Action.SIMULATE).isEmpty()) {
            FluidStack drained = fluidBlock.drain(this.world, front, IFluidHandler.FluidAction.EXECUTE);
            this.network.insertFluidTracked(drained, drained.getAmount());
        }
    }

    private ItemStack createTool() {
        ItemStack newTool = new ItemStack((IItemProvider)Items.field_151046_w);
        if (this.upgrades.hasUpgrade(UpgradeItem.Type.SILK_TOUCH)) {
            newTool.func_77966_a(Enchantments.field_185306_r, 1);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_3)) {
            newTool.func_77966_a(Enchantments.field_185308_t, 3);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_2)) {
            newTool.func_77966_a(Enchantments.field_185308_t, 2);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_1)) {
            newTool.func_77966_a(Enchantments.field_185308_t, 1);
        }
        return newTool;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    @Override
    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.func_74775_l(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems(this.upgrades, 1, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_218657_a(CoverManager.NBT_COVER_MANAGER, (INBT)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        return tag;
    }

    @Override
    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_PICKUP, this.pickupItem);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_PICKUP)) {
            this.pickupItem = tag.func_74767_n(NBT_PICKUP);
        }
        StackUtils.readItems(this.itemFilters, 0, tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    @Override
    public int getType() {
        return this.world.field_72995_K ? DestructorTile.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public boolean isPickupItem() {
        return this.pickupItem;
    }

    public void setPickupItem(boolean pickupItem) {
        this.pickupItem = pickupItem;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

