/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node.cover;

import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.CableNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.refinedmods.refinedstorage.item.CoverItem;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CoverManager {
    public static String NBT_COVER_MANAGER = "Cover";
    public static final ModelProperty<CoverManager> PROPERTY = new ModelProperty();
    private static final String NBT_DIRECTION = "Direction";
    private static final String NBT_ITEM = "Item";
    private static final String NBT_TYPE = "Type";
    private Map<Direction, Cover> covers = new HashMap<Direction, Cover>();
    private NetworkNode node;

    public CoverManager(NetworkNode node) {
        this.node = node;
    }

    @Nullable
    public Cover getCover(Direction facing) {
        return this.covers.get(facing);
    }

    public boolean hasCover(Direction facing) {
        return this.covers.containsKey(facing);
    }

    public boolean setCover(Direction facing, @Nullable Cover cover) {
        if (cover == null || CoverManager.isValidCover(cover.getStack()) && !this.hasCover(facing)) {
            if (cover != null && !(this.node instanceof CableNetworkNode) && facing == this.node.getDirection() && cover.getType() != CoverType.HOLLOW) {
                return false;
            }
            if (cover == null) {
                this.covers.remove(facing);
            } else {
                this.covers.put(facing, cover);
            }
            this.node.markDirty();
            if (this.node.getNetwork() != null) {
                this.node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, this.node.getNetwork().getWorld(), this.node.getNetwork().getPosition());
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Cover removeCover(Direction direction) {
        if (this.hasCover(direction)) {
            Cover cover = this.covers.remove(direction);
            this.node.markDirty();
            if (this.node.getNetwork() != null) {
                this.node.getNetwork().getNodeGraph().invalidate(Action.PERFORM, this.node.getNetwork().getWorld(), this.node.getNetwork().getPosition());
            }
            return cover;
        }
        return null;
    }

    public void readFromNbt(CompoundNBT nbt) {
        this.covers.clear();
        for (String s : nbt.func_150296_c()) {
            int type;
            CompoundNBT tag = nbt.func_74775_l(s);
            if (!tag.func_74764_b(NBT_DIRECTION) || !tag.func_74764_b(NBT_ITEM)) continue;
            Direction direction = Direction.func_82600_a((int)tag.func_74762_e(NBT_DIRECTION));
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(NBT_ITEM));
            int n = type = tag.func_74764_b(NBT_TYPE) ? tag.func_74762_e(NBT_TYPE) : 0;
            if (type >= CoverType.values().length) {
                type = 0;
            }
            if (!CoverManager.isValidCover(item)) continue;
            this.covers.put(direction, new Cover(item, CoverType.values()[type]));
        }
    }

    public CompoundNBT writeToNbt() {
        CompoundNBT list = new CompoundNBT();
        for (Map.Entry<Direction, Cover> entry : this.covers.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a(NBT_DIRECTION, entry.getKey().ordinal());
            tag.func_218657_a(NBT_ITEM, (INBT)entry.getValue().getStack().serializeNBT());
            tag.func_74768_a(NBT_TYPE, entry.getValue().getType().ordinal());
            list.func_218657_a(entry.getKey().ordinal() + "", (INBT)tag);
        }
        return list;
    }

    public IItemHandlerModifiable getAsInventory() {
        ItemStackHandler handler = new ItemStackHandler(this.covers.size());
        int i = 0;
        for (Map.Entry<Direction, Cover> entry : this.covers.entrySet()) {
            ItemStack cover = entry.getValue().getType().createStack();
            CoverItem.setItem(cover, entry.getValue().getStack());
            handler.setStackInSlot(i++, cover);
        }
        return handler;
    }

    public static boolean isValidCover(ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        Block block = CoverManager.getBlock(item);
        BlockState state = CoverManager.getBlockState(item);
        return block != null && state != null && CoverManager.isModelSupported(state) && !block.func_149653_t(state) && !block.hasTileEntity(state) && !state.func_215691_g();
    }

    private static boolean isModelSupported(BlockState state) {
        if (state.func_185901_i() != BlockRenderType.MODEL) {
            return false;
        }
        return state.func_200132_m();
    }

    @Nullable
    public static Block getBlock(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        Block block = Block.func_149634_a((Item)item.func_77973_b());
        if (block == Blocks.field_150350_a) {
            return null;
        }
        return block;
    }

    @Nullable
    public static BlockState getBlockState(ItemStack item) {
        Block block = CoverManager.getBlock(item);
        if (block == null) {
            return null;
        }
        return block.func_176223_P();
    }
}

