/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk.factory;

import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskFactory;
import com.refinedmods.refinedstorage.apiimpl.storage.FluidStorageType;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.FluidStorageDisk;
import com.refinedmods.refinedstorage.item.FluidStorageDiskItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;

public class FluidStorageDiskFactory
implements IStorageDiskFactory<FluidStack> {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "fluid");

    @Override
    public IStorageDisk<FluidStack> createFromNbt(ServerWorld world, CompoundNBT tag) {
        FluidStorageDisk disk = new FluidStorageDisk(world, tag.func_74762_e("Capacity"), tag.func_74764_b("Owner") ? tag.func_186857_a("Owner") : null);
        ListNBT list = tag.func_150295_c("Fluids", 10);
        for (int i = 0; i < list.size(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)list.func_150305_b(i));
            if (stack.isEmpty()) continue;
            disk.getRawStacks().put((Object)stack.getRawFluid(), (Object)stack);
        }
        return disk;
    }

    @Override
    public ItemStack createDiskItem(IStorageDisk<FluidStack> disk, UUID id) {
        FluidStorageDiskItem item;
        switch (disk.getCapacity()) {
            case 64000: {
                item = (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.SIXTY_FOUR_K).get();
                break;
            }
            case 256000: {
                item = (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.TWO_HUNDRED_FIFTY_SIX_K).get();
                break;
            }
            case 1024000: {
                item = (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.THOUSAND_TWENTY_FOUR_K).get();
                break;
            }
            case 4096000: {
                item = (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.FOUR_THOUSAND_NINETY_SIX_K).get();
                break;
            }
            default: {
                item = (FluidStorageDiskItem)RSItems.FLUID_STORAGE_DISKS.get((Object)FluidStorageType.CREATIVE).get();
            }
        }
        ItemStack stack = new ItemStack((IItemProvider)item);
        item.setId(stack, id);
        return stack;
    }

    @Override
    public IStorageDisk<FluidStack> create(ServerWorld world, int capacity, @Nullable UUID owner) {
        return new FluidStorageDisk(world, capacity, owner);
    }
}

