/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorListener;
import com.refinedmods.refinedstorage.container.BaseContainer;
import com.refinedmods.refinedstorage.network.craftingmonitor.CraftingMonitorUpdateMessage;
import com.refinedmods.refinedstorage.tile.craftingmonitor.CraftingMonitorTile;
import com.refinedmods.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class CraftingMonitorContainer
extends BaseContainer
implements ICraftingMonitorListener {
    private final ICraftingMonitor craftingMonitor;
    private boolean addedListener;

    public CraftingMonitorContainer(ContainerType<CraftingMonitorContainer> type, ICraftingMonitor craftingMonitor, @Nullable CraftingMonitorTile craftingMonitorTile, PlayerEntity player, int windowId) {
        super(type, craftingMonitorTile, player, windowId);
        this.craftingMonitor = craftingMonitor;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (!this.getPlayer().field_70170_p.field_72995_K) {
            ICraftingManager manager = this.craftingMonitor.getCraftingManager();
            if (manager != null && !this.addedListener) {
                manager.addListener(this);
                this.addedListener = true;
            } else if (manager == null && this.addedListener) {
                this.addedListener = false;
            }
        }
    }

    @Override
    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (!player.func_130014_f_().field_72995_K) {
            this.craftingMonitor.onClosed(player);
            ICraftingManager manager = this.craftingMonitor.getCraftingManager();
            if (manager != null && this.addedListener) {
                manager.removeListener(this);
            }
        }
    }

    public ICraftingMonitor getCraftingMonitor() {
        return this.craftingMonitor;
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = this.func_75139_a(index);
        if (slot.func_75216_d()) {
            stack = slot.func_75211_c();
            if (index < 4 ? !this.func_75135_a(stack, 4, this.field_75151_b.size(), false) : !this.func_75135_a(stack, 0, 4, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    @Override
    protected int getDisabledSlotNumber() {
        return this.craftingMonitor.getSlotId();
    }

    @Override
    public void onAttached() {
        this.onChanged();
    }

    @Override
    public void onChanged() {
        RS.NETWORK_HANDLER.sendTo((ServerPlayerEntity)this.getPlayer(), new CraftingMonitorUpdateMessage(this.craftingMonitor));
    }
}

