/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.network.node.CrafterManagerNetworkNode;
import com.refinedmods.refinedstorage.container.CrafterManagerContainer;
import com.refinedmods.refinedstorage.container.slot.CrafterManagerSlot;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.IScreenInfoProvider;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.screen.widget.SearchWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.CrafterManagerSearchBoxModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSizeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.tile.CrafterManagerTile;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.Map;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class CrafterManagerScreen
extends BaseScreen<CrafterManagerContainer>
implements IScreenInfoProvider {
    private final CrafterManagerNetworkNode crafterManager;
    private ScrollbarWidget scrollbar;
    private SearchWidget searchField;

    public CrafterManagerScreen(CrafterManagerContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 193, 0, inventory, title);
        this.crafterManager = (CrafterManagerNetworkNode)((CrafterManagerTile)container.getTile()).getNode();
    }

    @Override
    protected void onPreInit() {
        this.field_147000_g = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18;
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, NetworkNodeTile.REDSTONE_MODE));
        this.addSideButton(new CrafterManagerSearchBoxModeSideButton(this));
        this.addSideButton(new GridSizeSideButton(this, this.crafterManager::getSize, size -> TileDataManager.setParameter(CrafterManagerTile.SIZE, size)));
        this.scrollbar = new ScrollbarWidget(this, 174, this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        this.scrollbar.addListener((oldOffset, newOffset) -> ((CrafterManagerContainer)this.field_147002_h).initSlots(null));
        ((CrafterManagerContainer)this.field_147002_h).initSlots(null);
        int sx = x + 97 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new SearchWidget(this.field_230712_o_, sx, sy, 82);
            this.searchField.func_212954_a(value -> {
                this.searchField.updateJei();
                ((CrafterManagerContainer)this.field_147002_h).initSlots(null);
            });
            this.searchField.setMode(this.crafterManager.getSearchBoxMode());
        } else {
            this.searchField.field_230690_l_ = sx;
            this.searchField.field_230691_m_ = sy;
        }
        this.func_230480_a_((Widget)this.searchField);
    }

    @Override
    public void tick(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() - 1 >= this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/crafter_manager.png");
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.getTopHeight());
        int rows = this.getVisibleRows();
        int yy = y;
        for (int i = 0; i < rows; ++i) {
            yy += 18;
            int yTextureStart = this.getTopHeight();
            if (i > 0) {
                yTextureStart = i == rows - 1 ? (yTextureStart += 36) : (yTextureStart += 18);
            }
            this.func_238474_b_(matrixStack, x, yy, 0, yTextureStart, this.field_146999_f, 18);
        }
        this.func_238474_b_(matrixStack, x, yy += 18, 0, this.getTopHeight() + 54, this.field_146999_f, this.getBottomHeight());
        if (this.crafterManager.isActiveOnClient()) {
            for (Slot slot : ((CrafterManagerContainer)this.field_147002_h).field_75151_b) {
                if (!(slot instanceof CrafterManagerSlot) || !slot.func_111238_b()) continue;
                this.func_238474_b_(matrixStack, x + slot.field_75223_e - 1, y + slot.field_75221_f - 1, 0, 193, 18, 18);
            }
        }
        this.searchField.func_230430_a_(matrixStack, 0, 0, 0.0f);
        this.scrollbar.render(matrixStack);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        this.renderString(matrixStack, 7, this.getYPlayerInventory() - 12, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        if (this.field_147002_h != null && this.crafterManager.isActiveOnClient()) {
            for (Map.Entry<String, Integer> heading : ((CrafterManagerContainer)this.field_147002_h).getHeadings().entrySet()) {
                int y = heading.getValue();
                if (y < this.getTopHeight() - 1 || y >= this.getTopHeight() + this.getVisibleRows() * 18 - 1) continue;
                RenderSystem.disableLighting();
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.bindTexture("refinedstorage", "gui/crafter_manager.png");
                this.func_238474_b_(matrixStack, 7, y, 0, 174, 162, 18);
                this.renderString(matrixStack, 11, y + 6, RenderUtils.shorten(I18n.func_135052_a((String)heading.getKey(), (Object[])new Object[0]), 25));
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar.func_231044_a_(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, clickedButton);
    }

    public boolean func_231042_a_(char unknown1, int unknown2) {
        if (this.searchField.func_231042_a_(unknown1, unknown2)) {
            return true;
        }
        return super.func_231042_a_(unknown1, unknown2);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.searchField.func_231046_a_(key, scanCode, modifiers) || this.searchField.func_212955_f()) {
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public void func_212927_b(double mx, double my) {
        this.scrollbar.func_212927_b(mx, my);
        super.func_212927_b(mx, my);
    }

    public boolean func_231048_c_(double mx, double my, int button) {
        return this.scrollbar.func_231048_c_(mx, my, button) || super.func_231048_c_(mx, my, button);
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        return this.scrollbar.func_231043_a_(x, y, delta) || super.func_231043_a_(x, y, delta);
    }

    public SearchWidget getSearchField() {
        return this.searchField;
    }

    public CrafterManagerNetworkNode getCrafterManager() {
        return this.crafterManager;
    }

    @Override
    public int getTopHeight() {
        return 19;
    }

    @Override
    public int getBottomHeight() {
        return 99;
    }

    @Override
    public int getVisibleRows() {
        switch (this.crafterManager.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.field_230709_l_ - this.getTopHeight() - this.getBottomHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.CLIENT_CONFIG.getCrafterManager().getMaxRowsStretch()));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    @Override
    public int getRows() {
        return !this.crafterManager.isActiveOnClient() ? 0 : ((CrafterManagerContainer)this.field_147002_h).getRows();
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar == null ? 0 : this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return this.searchField == null ? "" : this.searchField.func_146179_b();
    }

    @Override
    public int getYPlayerInventory() {
        return this.getTopHeight() + this.getVisibleRows() * 18 + 16;
    }
}

