/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.tileentity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.blocks.signs.ICanvasSign;
import vectorwing.farmersdelight.utils.ModAtlases;

@OnlyIn(value=Dist.CLIENT)
public class CanvasSignTileEntityRenderer
extends SignTileEntityRenderer {
    public static final float TEXT_LINE_HEIGHT = 10.0f;
    public static final float TEXT_VERTICAL_OFFSET = 19.0f;
    private final SignTileEntityRenderer.SignModel model = new SignTileEntityRenderer.SignModel();

    public CanvasSignTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void func_225616_a_(SignTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float angle;
        BlockState state = tileEntityIn.func_195044_w();
        matrixStackIn.func_227860_a_();
        if (state.func_177230_c() instanceof StandingSignBlock) {
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            angle = -((float)((Integer)state.func_177229_b((Property)StandingSignBlock.field_176413_a) * 360) / 16.0f);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            this.model.field_78165_b.field_78806_j = true;
        } else {
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            angle = -((Direction)state.func_177229_b((Property)WallSignBlock.field_176412_a)).func_185119_l();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            matrixStackIn.func_227861_a_(0.0, -0.3125, -0.4375);
            this.model.field_78165_b.field_78806_j = false;
        }
        matrixStackIn.func_227860_a_();
        float signScale = 0.6666667f;
        matrixStackIn.func_227862_a_(signScale, -signScale, -signScale);
        RenderMaterial material = CanvasSignTileEntityRenderer.getMaterial(state.func_177230_c());
        IVertexBuilder vertexBuilder = material.func_229311_a_(bufferIn, arg_0 -> ((SignTileEntityRenderer.SignModel)this.model).func_228282_a_(arg_0));
        this.model.field_78166_a.func_228308_a_(matrixStackIn, vertexBuilder, combinedLightIn, combinedOverlayIn);
        this.model.field_78165_b.func_228308_a_(matrixStackIn, vertexBuilder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
        FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
        float textScale = 0.010416667f;
        matrixStackIn.func_227861_a_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStackIn.func_227862_a_(textScale, -textScale, textScale);
        int colorCode = tileEntityIn.func_214066_f().func_218388_g();
        double textBrightness = 0.6;
        int red = (int)((double)NativeImage.func_227791_b_((int)colorCode) * textBrightness);
        int green = (int)((double)NativeImage.func_227793_c_((int)colorCode) * textBrightness);
        int blue = (int)((double)NativeImage.func_227795_d_((int)colorCode) * textBrightness);
        int textColor = NativeImage.func_227787_a_((int)0, (int)blue, (int)green, (int)red);
        for (int i = 0; i < 4; ++i) {
            IReorderingProcessor reorderingProcessor = tileEntityIn.func_242686_a(i, textProps -> {
                List textLines = fontRenderer.func_238425_b_((ITextProperties)textProps, 90);
                return textLines.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)textLines.get(0);
            });
            if (reorderingProcessor == null) continue;
            float x = -fontRenderer.func_243245_a(reorderingProcessor) / 2;
            float y = (float)i * 10.0f - 19.0f;
            fontRenderer.func_238416_a_(reorderingProcessor, x, y, textColor, false, matrixStackIn.func_227866_c_().func_227870_a_(), bufferIn, false, 0, combinedLightIn);
        }
        matrixStackIn.func_227865_b_();
    }

    public static RenderMaterial getMaterial(Block blockIn) {
        DyeColor dye = null;
        if (blockIn instanceof ICanvasSign) {
            dye = ((ICanvasSign)blockIn).getBackgroundColor();
        }
        return dye != null ? ModAtlases.DYED_CANVAS_SIGN_MATERIALS.get(dye) : ModAtlases.BLANK_CANVAS_SIGN_MATERIAL;
    }
}

