/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.tileentity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.items.IItemHandler;
import vectorwing.farmersdelight.blocks.StoveBlock;
import vectorwing.farmersdelight.tile.SkilletTileEntity;

public class SkilletTileEntityRenderer
extends TileEntityRenderer<SkilletTileEntity> {
    private final Random random = new Random();

    public SkilletTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(SkilletTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = (Direction)tileEntityIn.func_195044_w().func_177229_b((Property)StoveBlock.field_185512_D);
        IItemHandler inventory = tileEntityIn.getInventory();
        ItemStack stack = inventory.getStackInSlot(0);
        int seed = stack.func_190926_b() ? 187 : Item.func_150891_b((Item)stack.func_77973_b()) + stack.func_77952_i();
        this.random.setSeed(seed);
        if (!stack.func_190926_b()) {
            int itemRenderCount = this.getModelCount(stack);
            for (int i = 0; i < itemRenderCount; ++i) {
                matrixStackIn.func_227860_a_();
                float xOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                float zOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                matrixStackIn.func_227861_a_(0.5 + (double)xOffset, 0.1 + 0.03 * (double)(i + 1), 0.5 + (double)zOffset);
                float degrees = -direction.func_185119_l();
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(degrees));
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                if (tileEntityIn.func_145831_w() != null) {
                    Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn);
                }
                matrixStackIn.func_227865_b_();
            }
        }
    }

    protected int getModelCount(ItemStack stack) {
        if (stack.func_190916_E() > 48) {
            return 5;
        }
        if (stack.func_190916_E() > 32) {
            return 4;
        }
        if (stack.func_190916_E() > 16) {
            return 3;
        }
        if (stack.func_190916_E() > 1) {
            return 2;
        }
        return 1;
    }
}

