/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vectorwing.farmersdelight.crafting.ingredients.ChanceResult;

public class CuttingBoardRecipe
implements IRecipe<RecipeWrapper> {
    public static IRecipeType<CuttingBoardRecipe> TYPE = IRecipeType.func_222147_a((String)"farmersdelight:cutting");
    public static final Serializer SERIALIZER = new Serializer();
    public static final int MAX_RESULTS = 4;
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final Ingredient tool;
    private final NonNullList<ChanceResult> results;
    private final String soundEvent;

    public CuttingBoardRecipe(ResourceLocation id, String group, Ingredient input, Ingredient tool, NonNullList<ChanceResult> results, String soundEvent) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.tool = tool;
        this.results = results;
        this.soundEvent = soundEvent;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public NonNullList<Ingredient> getIngredientsAndTool() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.input);
        nonnulllist.add((Object)this.tool);
        return nonnulllist;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public ItemStack assemble(RecipeWrapper inv) {
        return ((ChanceResult)this.results.get(0)).getStack().func_77946_l();
    }

    public ItemStack func_77571_b() {
        return ((ChanceResult)this.results.get(0)).getStack();
    }

    public List<ItemStack> getResults() {
        return this.getRollableResults().stream().map(ChanceResult::getStack).collect(Collectors.toList());
    }

    public NonNullList<ChanceResult> getRollableResults() {
        return this.results;
    }

    public List<ItemStack> rollResults(Random rand, int fortuneLevel) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            ItemStack stack = output.rollOutput(rand, fortuneLevel);
            if (stack.func_190926_b()) continue;
            results.add(stack);
        }
        return results;
    }

    public String getSoundEventID() {
        return this.soundEvent;
    }

    public boolean matches(RecipeWrapper inv, World worldIn) {
        if (inv.func_191420_l()) {
            return false;
        }
        return this.input.test(inv.func_70301_a(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.getMaxInputCount();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public boolean func_192399_d() {
        return true;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CuttingBoardRecipe> {
        Serializer() {
            this.setRegistryName(new ResourceLocation("farmersdelight", "cutting"));
        }

        public CuttingBoardRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String groupIn = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            JsonObject toolObject = JSONUtils.func_152754_s((JsonObject)json, (String)"tool");
            Ingredient toolIn = Ingredient.func_199802_a((JsonElement)toolObject);
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cutting recipe");
            }
            if (toolIn.func_203189_d()) {
                throw new JsonParseException("No tool for cutting recipe");
            }
            if (inputItemsIn.size() > 1) {
                throw new JsonParseException("Too many ingredients for cutting recipe! Please define only one ingredient");
            }
            NonNullList<ChanceResult> results = Serializer.readResults(JSONUtils.func_151214_t((JsonObject)json, (String)"result"));
            if (results.size() > 4) {
                throw new JsonParseException("Too many results for cutting recipe! The maximum quantity of unique results is 4");
            }
            String soundID = JSONUtils.func_151219_a((JsonObject)json, (String)"sound", (String)"");
            return new CuttingBoardRecipe(recipeId, groupIn, (Ingredient)inputItemsIn.get(0), toolIn, results, soundID);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static NonNullList<ChanceResult> readResults(JsonArray resultArray) {
            NonNullList results = NonNullList.func_191196_a();
            for (JsonElement result : resultArray) {
                results.add((Object)ChanceResult.deserialize(result));
            }
            return results;
        }

        @Nullable
        public CuttingBoardRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String groupIn = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient inputItemIn = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient toolIn = Ingredient.func_199566_b((PacketBuffer)buffer);
            int i = buffer.func_150792_a();
            NonNullList resultsIn = NonNullList.func_191197_a((int)i, (Object)ChanceResult.EMPTY);
            for (int j = 0; j < resultsIn.size(); ++j) {
                resultsIn.set(j, (Object)ChanceResult.read(buffer));
            }
            String soundEventIn = buffer.func_218666_n();
            return new CuttingBoardRecipe(recipeId, groupIn, inputItemIn, toolIn, (NonNullList<ChanceResult>)resultsIn, soundEventIn);
        }

        public void toNetwork(PacketBuffer buffer, CuttingBoardRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.func_199564_a(buffer);
            recipe.tool.func_199564_a(buffer);
            buffer.func_150787_b(recipe.results.size());
            for (ChanceResult result : recipe.results) {
                result.write(buffer);
            }
            buffer.func_180714_a(recipe.soundEvent);
        }
    }
}

