/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.power;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.AbstractPowerPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerPortHandlerForgeEnergy<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>>
extends AbstractPowerPortHandler<Controller, T>
implements IEnergyStorage {
    @CapabilityInject(value=IEnergyStorage.class)
    private static Capability<IEnergyStorage> CAPAP_FORGE_ENERGYSTORAGE = null;
    private IEnergyStorage _consumer = null;
    private final LazyOptional<IEnergyStorage> _capability = LazyOptional.of(() -> this);

    public PowerPortHandlerForgeEnergy(T part, IoMode mode) {
        super(EnergySystem.ForgeEnergy, part, mode);
    }

    @Override
    public WideAmount outputEnergy(WideAmount amount) {
        if (null == this._consumer || !this.isOutput() || this.isPassive()) {
            return WideAmount.ZERO;
        }
        int maxUnits = Math.min(amount.intValue(), Integer.MAX_VALUE);
        return WideAmount.asImmutable(this._consumer.receiveEnergy(maxUnits, false));
    }

    @Override
    public boolean isConnected() {
        return null != this._consumer;
    }

    @Override
    public void checkConnections(@Nullable World world, BlockPos position) {
        this._consumer = this.lookupConsumer(world, position, CAPAP_FORGE_ENERGYSTORAGE, (NonNullPredicate<TileEntity>)((NonNullPredicate)te -> te instanceof IPowerPortHandler), this._consumer);
    }

    @Override
    public void invalidate() {
        this._capability.invalidate();
    }

    @Nullable
    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction direction) {
        if (CAPAP_FORGE_ENERGYSTORAGE == capability) {
            return this._capability.cast();
        }
        return null;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.canReceive() ? this.getEnergyStorage().insertEnergy(this.getEnergySystem(), this.maxTransferRate(maxReceive), OperationMode.from(simulate)).intValue() : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.canExtract() ? this.getEnergyStorage().extractEnergy(this.getEnergySystem(), this.maxTransferRate(maxExtract), OperationMode.from(simulate)).intValue() : 0;
    }

    public int getEnergyStored() {
        return this.getEnergyStorage().getEnergyStored(this.getEnergySystem()).intValue();
    }

    public int getMaxEnergyStored() {
        return this.getEnergyStorage().getCapacity(this.getEnergySystem()).intValue();
    }

    public boolean canExtract() {
        return this.isOutput() && this.isPassive();
    }

    public boolean canReceive() {
        return this.isInput() && this.isPassive();
    }
}

