/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.power.charging;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.AbstractPowerPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.charging.IChargingPortHandler;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.handler.TileEntityItemStackHandler;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractChargingPortHandler<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>>
extends AbstractPowerPortHandler<Controller, T>
implements IChargingPortHandler,
ISyncableEntity {
    private final ItemStackHandler _input;
    private final ItemStackHandler _output;
    private WideAmount _chargingRate;

    protected AbstractChargingPortHandler(EnergySystem energySystem, T part, int inputSlotsCount, int outputSlotsCount) {
        super(energySystem, part, IoMode.Active);
        this._input = new TileEntityItemStackHandler((TileEntity)part, inputSlotsCount);
        this._output = new TileEntityItemStackHandler((TileEntity)part, outputSlotsCount);
        this._chargingRate = WideAmount.ZERO;
    }

    protected WideAmount getChargingRate() {
        if (this._chargingRate.isZero()) {
            this._chargingRate = ((IPowerPort)this.getPart()).getMaxTransferRate();
        }
        return this._chargingRate;
    }

    protected <C> LazyOptional<C> getCapabilityFromInventory(Capability<C> capability, int inputSlotIndex, boolean ejectIfNotFound) {
        ItemStack stack = this._input.getStackInSlot(inputSlotIndex);
        if (!stack.func_190926_b()) {
            LazyOptional cap = stack.getCapability(capability, null);
            if (ejectIfNotFound && !cap.isPresent()) {
                this.eject(inputSlotIndex);
            }
            return cap;
        }
        return LazyOptional.empty();
    }

    protected void eject(int inputSlotIndex) {
        ItemStack input = this._input.getStackInSlot(inputSlotIndex);
        if (!input.func_190926_b()) {
            for (int idx = 0; idx < this.getOutputSlotsCount(); ++idx) {
                if (!this._output.getStackInSlot(idx).func_190926_b()) continue;
                this._output.setStackInSlot(idx, input);
                this._input.setStackInSlot(inputSlotIndex, ItemStack.field_190927_a);
                return;
            }
        }
    }

    protected int getInputSlotsCount() {
        return this._input.getSlots();
    }

    protected int getOutputSlotsCount() {
        return this._output.getSlots();
    }

    @Override
    public IItemHandlerModifiable getItemStackHandler(IoDirection direction) {
        return direction.isInput() ? this._input : this._output;
    }

    @Override
    public void eject() {
        for (int idx = 0; idx < this.getInputSlotsCount(); ++idx) {
            this.eject(idx);
        }
    }

    @Override
    public boolean isConnected() {
        for (int idx = 0; idx < this.getInputSlotsCount(); ++idx) {
            if (this._input.getStackInSlot(idx).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkConnections(@Nullable World world, BlockPos position) {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvFrom(data, "in", this._input);
            AbstractChargingPortHandler.syncInvFrom(data, "out", this._output);
        }
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvTo(data, "in", this._input);
            AbstractChargingPortHandler.syncInvTo(data, "out", this._output);
        }
        return data;
    }

    private static void syncInvTo(CompoundNBT data, String name, ItemStackHandler inv) {
        data.func_218657_a(name, (INBT)inv.serializeNBT());
    }

    private static void syncInvFrom(CompoundNBT data, String name, ItemStackHandler inv) {
        if (data.func_74764_b(name)) {
            inv.deserializeNBT(data.func_74775_l(name));
        }
    }
}

