/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.gamecontent.debugtool;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.item.ModItem;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class DebugToolItem
extends ModItem {
    private static ITestCallback s_testCallback = null;

    public DebugToolItem() {
        super(new Item.Properties().func_200917_a(64).func_200916_a(ItemGroup.field_78040_i));
    }

    public static void setTestCallback(@Nullable ITestCallback callback) {
        s_testCallback = callback;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("zerocore:debugTool.block.tooltip1"));
        tooltip.add((ITextComponent)new TranslationTextComponent("zerocore:debugTool.block.tooltip2", new Object[]{TextFormatting.ITALIC.toString()}));
        tooltip.add((ITextComponent)new TranslationTextComponent("zerocore:debugTool.block.tooltip3", new Object[]{TextFormatting.GREEN, TextFormatting.GRAY.toString() + TextFormatting.ITALIC.toString()}));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        LogicalSide side = CodeHelper.getWorldLogicalSide(world);
        if (CodeHelper.isDevEnv() && null != s_testCallback && !stack.func_190926_b() && stack.func_190916_E() > 1 && context.func_221531_n() == Hand.MAIN_HAND) {
            s_testCallback.runTest(stack.func_190916_E(), player, world, pos);
            return ActionResultType.SUCCESS;
        }
        if (null == player || player.func_225608_bj_() != side.isClient() || world.func_175623_d(pos)) {
            return ActionResultType.PASS;
        }
        if (WorldHelper.getTile(world, pos).filter(te -> te instanceof IDebuggable).map(te -> (IDebuggable)te).map(debuggee -> MessagesPool.build(debuggee, side)).map(pool -> this.sendMessages(player, (ITextComponent)new StringTextComponent(String.format("%1$s side debug analysis report of Tile Entity at %2$d, %3$d, %4$d", CodeHelper.getWorldSideName(world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), (MessagesPool)pool)).filter(result -> result).isPresent()) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return false;
    }

    private boolean sendMessages(PlayerEntity player, ITextComponent header, MessagesPool pool) {
        if (pool.isNotEmpty()) {
            CodeHelper.sendChatMessage(player, (ITextComponent)new StringTextComponent("--------------------------------------------------"));
            CodeHelper.sendChatMessage(player, header);
            pool.forEach(message -> CodeHelper.sendChatMessage(player, message));
            return true;
        }
        return false;
    }

    private static final class MessagesPool
    implements IDebugMessages,
    Iterable<ITextComponent> {
        private final List<ITextComponent> _messages = Lists.newArrayListWithCapacity((int)2);
        private final int _depth;

        public static MessagesPool build(IDebuggable debuggee, LogicalSide side) {
            MessagesPool pool = new MessagesPool(0);
            debuggee.getDebugMessages(side, pool);
            return pool;
        }

        public boolean isNotEmpty() {
            return !this._messages.isEmpty();
        }

        @Override
        public void add(ITextComponent message) {
            this._messages.add(message);
        }

        @Override
        public void add(String messageFormatStringResourceKey, Object ... messageParameters) {
            this.add(this.getFormattedTextComponent(messageFormatStringResourceKey, messageParameters));
        }

        @Override
        public void add(LogicalSide side, IDebuggable debuggable, ITextComponent label) {
            MessagesPool other = new MessagesPool(this._depth + 1);
            debuggable.getDebugMessages(side, other);
            this.merge(other, label);
        }

        @Override
        public void add(LogicalSide side, IDebuggable debuggable, String labelFormatStringResourceKey, Object ... labelParameters) {
            this.add(side, debuggable, this.getFormattedTextComponent(labelFormatStringResourceKey, labelParameters));
        }

        @Override
        public <T> void add(T debuggee, BiConsumer<IDebugMessages, T> consumer, ITextComponent label) {
            MessagesPool other = new MessagesPool(this._depth + 1);
            consumer.accept(other, (IDebugMessages)debuggee);
            this.merge(other, label);
        }

        @Override
        public <T> void add(T debuggee, BiConsumer<IDebugMessages, T> consumer, String labelFormatStringResourceKey, Object ... labelParameters) {
            this.add(debuggee, consumer, this.getFormattedTextComponent(labelFormatStringResourceKey, labelParameters));
        }

        @Override
        public Iterator<ITextComponent> iterator() {
            return this._messages.iterator();
        }

        private MessagesPool(int depth) {
            this._depth = depth;
        }

        private void merge(MessagesPool other, ITextComponent label) {
            if (1 == other._messages.size()) {
                this.add((ITextComponent)new StringTextComponent("").func_230529_a_(label).func_240702_b_(" ").func_230529_a_(other._messages.get(0)));
            } else {
                this.add(label);
                other._messages.forEach(message -> this.add((ITextComponent)this.createPadding(other._depth).func_230529_a_(message)));
            }
        }

        private IFormattableTextComponent createPadding(int depth) {
            return new StringTextComponent("                    ".substring(0, Math.min(20, depth)));
        }

        private ITextComponent getFormattedTextComponent(String format, Object ... parameters) {
            if (parameters.length > 0) {
                return new TranslationTextComponent(format, parameters);
            }
            return new StringTextComponent(format);
        }
    }

    @FunctionalInterface
    public static interface ITestCallback {
        public void runTest(int var1, @Nullable PlayerEntity var2, World var3, BlockPos var4);
    }
}

