/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.internal.network.Network;
import it.zerono.mods.zerocore.internal.network.TileCommandMessage;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.IBlockStateUpdater;
import it.zerono.mods.zerocore.lib.block.ITileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.IVersionAwareSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractModBlockEntity
extends TileEntity
implements IBlockStateUpdater,
ISyncableEntity,
IDebuggable {
    @Deprecated
    public final IEvent<Runnable> DataUpdate;
    private static final int EVENT_CLIENT_RENDER_UPDATE = 1;
    private ITileCommandDispatcher _commandDispatcher = (source, name, parameters) -> {};

    public AbstractModBlockEntity(TileEntityType<?> type) {
        super(type);
        this.DataUpdate = new Event<Runnable>();
    }

    public Block getBlockType() {
        return this.func_195044_w().func_177230_c();
    }

    public void callOnLogicalSide(Runnable serverCode, Runnable clientCode) {
        if (null != this.field_145850_b) {
            CodeHelper.callOnLogicalSide(this.field_145850_b, serverCode, clientCode);
        }
    }

    public <T> T callOnLogicalSide(Supplier<T> serverCode, Supplier<T> clientCode, Supplier<T> invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalSide(this.field_145850_b, serverCode, clientCode);
    }

    public boolean callOnLogicalSide(BooleanSupplier serverCode, BooleanSupplier clientCode) {
        return null != this.field_145850_b && CodeHelper.callOnLogicalSide(this.field_145850_b, serverCode, clientCode);
    }

    public int callOnLogicalSide(IntSupplier serverCode, IntSupplier clientCode, IntSupplier invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue.getAsInt();
        }
        return CodeHelper.callOnLogicalSide(this.field_145850_b, serverCode, clientCode);
    }

    public long callOnLogicalSide(LongSupplier serverCode, LongSupplier clientCode, LongSupplier invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue.getAsLong();
        }
        return CodeHelper.callOnLogicalSide(this.field_145850_b, serverCode, clientCode);
    }

    public double callOnLogicalSide(DoubleSupplier serverCode, DoubleSupplier clientCode, DoubleSupplier invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue.getAsDouble();
        }
        return CodeHelper.callOnLogicalSide(this.field_145850_b, serverCode, clientCode);
    }

    public void callOnLogicalServer(Runnable code) {
        if (null != this.field_145850_b) {
            CodeHelper.callOnLogicalServer(this.field_145850_b, code);
        }
    }

    public void callOnLogicalServer(Consumer<World> code) {
        if (null != this.field_145850_b && CodeHelper.calledByLogicalServer(this.field_145850_b)) {
            code.accept(this.field_145850_b);
        }
    }

    public <T> T callOnLogicalServer(Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalServer(this.field_145850_b, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalServer(BooleanSupplier code) {
        return null != this.field_145850_b && CodeHelper.callOnLogicalServer(this.field_145850_b, code);
    }

    public int callOnLogicalServer(IntSupplier code, int invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.field_145850_b, code, invalidSideReturnValue);
    }

    public long callOnLogicalServer(LongSupplier code, long invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.field_145850_b, code, invalidSideReturnValue);
    }

    public double callOnLogicalServer(DoubleSupplier code, double invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.field_145850_b, code, invalidSideReturnValue);
    }

    public void callOnLogicalClient(Runnable code) {
        if (null != this.field_145850_b) {
            CodeHelper.callOnLogicalClient(this.field_145850_b, code);
        }
    }

    public void callOnLogicalClient(Consumer<World> code) {
        if (null != this.field_145850_b && CodeHelper.calledByLogicalClient(this.field_145850_b)) {
            code.accept(this.field_145850_b);
        }
    }

    public <T> T callOnLogicalClient(Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalClient(this.field_145850_b, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalClient(BooleanSupplier code) {
        return null != this.field_145850_b && CodeHelper.callOnLogicalClient(this.field_145850_b, code);
    }

    public int callOnLogicalClient(IntSupplier code, int invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.field_145850_b, code, invalidSideReturnValue);
    }

    public long callOnLogicalClient(LongSupplier code, long invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.field_145850_b, code, invalidSideReturnValue);
    }

    public double callOnLogicalClient(DoubleSupplier code, double invalidSideReturnValue) {
        if (null == this.field_145850_b) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.field_145850_b, code, invalidSideReturnValue);
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return false;
    }

    public boolean openGui(ServerPlayerEntity player) {
        return this.openGuiOnClient(player, buffer -> {});
    }

    public boolean openGui(ServerPlayerEntity player, Consumer<PacketBuffer> extraDataWriter) {
        return this.openGuiOnClient(player, extraDataWriter);
    }

    public static <T extends AbstractModBlockEntity> T getGuiClientBlockEntity(PacketBuffer networkData) {
        return (T)((AbstractModBlockEntity)WorldHelper.getClientTile(networkData.func_179259_c()).orElseThrow(NullPointerException::new));
    }

    public void func_230337_a_(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
        this.syncEntityDataFrom(data, ISyncableEntity.SyncReason.FullSync);
    }

    public CompoundNBT func_189515_b(CompoundNBT data) {
        return this.syncEntityDataTo(super.func_189515_b(data), ISyncableEntity.SyncReason.FullSync);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
        this.syncEntityDataFrom(data, ISyncableEntity.SyncReason.NetworkUpdate);
    }

    public CompoundNBT func_189517_E_() {
        return this.syncEntityDataTo(super.func_189517_E_(), ISyncableEntity.SyncReason.NetworkUpdate);
    }

    public final void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.syncEntityDataFrom(packet.func_148857_g(), ISyncableEntity.SyncReason.NetworkUpdate);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.syncEntityDataTo(new CompoundNBT(), ISyncableEntity.SyncReason.NetworkUpdate));
    }

    protected void onDataUpdate() {
        this.DataUpdate.raise(Runnable::run);
    }

    private void syncEntityDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        CompoundNBT dataToSync = data;
        if (syncReason.isFullSync() && data.func_74764_b("zcvase_version") && data.func_74764_b("zcvase_payload")) {
            CompoundNBT payload = dataToSync = data.func_74775_l("zcvase_payload");
            if (this instanceof IVersionAwareSyncableEntity) {
                IVersionAwareSyncableEntity vase = (IVersionAwareSyncableEntity)((Object)this);
                int dataVersion = data.func_74762_e("zcvase_version");
                if (vase.syncGetDataCurrentVersion() > dataVersion) {
                    dataToSync = vase.syncGetVersionConverter(dataVersion).apply(payload);
                }
            }
        }
        this.syncDataFrom(dataToSync, syncReason);
        this.onDataUpdate();
    }

    private CompoundNBT syncEntityDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            data.func_74768_a("zcvase_version", this.syncGetEntityDataCurrentVersion());
            data.func_218657_a("zcvase_payload", (INBT)this.syncDataTo(new CompoundNBT(), syncReason));
            return data;
        }
        return this.syncDataTo(data, syncReason);
    }

    private int syncGetEntityDataCurrentVersion() {
        return this instanceof IVersionAwareSyncableEntity ? ((IVersionAwareSyncableEntity)((Object)this)).syncGetDataCurrentVersion() : -1;
    }

    public void sendCommandToServer(String name) {
        this.sendCommandToServer(name, NBTHelper.EMPTY_COMPOUND);
    }

    public void sendCommandToServer(String name, CompoundNBT parameters) {
        Network.HANDLER.sendToServer(TileCommandMessage.create(this, name, parameters));
    }

    public void sendCommandToPlayer(ServerPlayerEntity player, String name) {
        this.sendCommandToPlayer(player, name, NBTHelper.EMPTY_COMPOUND);
    }

    public void sendCommandToPlayer(ServerPlayerEntity player, String name, CompoundNBT parameters) {
        Network.HANDLER.sendToPlayer(TileCommandMessage.create(this, name, parameters), player);
    }

    public void handleCommand(LogicalSide source, String name, CompoundNBT parameters) {
        this._commandDispatcher.dispatch(source, name, parameters);
    }

    protected void setCommandDispatcher(ITileCommandDispatcher dispatcher) {
        this._commandDispatcher = Objects.requireNonNull(dispatcher);
    }

    public void markChunkDirty() {
        World world = this.func_145831_w();
        if (null != world) {
            world.func_175646_b(this.func_174877_v(), (TileEntity)this);
        }
    }

    public void callNeighborBlockChange() {
        World world = this.func_145831_w();
        if (null != world) {
            WorldHelper.notifyNeighborsOfStateChange(world, this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
    }

    @Deprecated
    public void callNeighborTileChange() {
    }

    public void notifyBlockUpdate() {
        if (this.func_145830_o()) {
            this.notifyBlockUpdate(this.func_195044_w(), this.func_195044_w());
        }
    }

    public void notifyBlockUpdate(BlockState oldState, BlockState newState) {
        World world = this.func_145831_w();
        if (null != world) {
            WorldHelper.notifyBlockUpdate(world, this.func_174877_v(), oldState, newState);
        }
    }

    public static <T extends AbstractModBlockEntity> void notifyBlockUpdate(Collection<T> entities) {
        entities.forEach(AbstractModBlockEntity::notifyBlockUpdate);
    }

    public static <T extends AbstractModBlockEntity> void notifyBlockUpdate(Stream<T> entities) {
        entities.forEach(AbstractModBlockEntity::notifyBlockUpdate);
    }

    public void notifyTileEntityUpdate() {
        World world = this.func_145831_w();
        if (null != world) {
            this.func_70296_d();
            WorldHelper.notifyBlockUpdate(world, this.func_174877_v(), this.func_195044_w(), this.func_195044_w());
        }
    }

    public void markForRenderUpdate() {
        WorldHelper.markBlockRangeForRenderUpdate(this.func_174877_v(), this.func_174877_v());
    }

    public void requestClientRenderUpdate() {
        if (null != this.field_145850_b) {
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.getBlockType(), 1, 0);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (null != this.field_145850_b) {
            switch (id) {
                case 1: {
                    this.callOnLogicalClient(this::markForRenderUpdate);
                    return true;
                }
            }
        }
        return super.func_145842_c(id, type);
    }

    @Override
    public void updateBlockState(BlockState currentState, IWorld world, BlockPos position, @Nullable TileEntity tileEntity, int updateFlags) {
        Block block = currentState.func_177230_c();
        if (block instanceof IBlockStateUpdater) {
            ((IBlockStateUpdater)block).updateBlockState(currentState, world, position, tileEntity, updateFlags);
        } else {
            world.func_180501_a(position, this.buildUpdatedState(currentState, (IBlockReader)world, position, tileEntity), updateFlags);
        }
    }

    @Override
    @Nonnull
    public BlockState buildUpdatedState(BlockState currentState, IBlockReader reader, BlockPos position, @Nullable TileEntity tileEntity) {
        return currentState;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Tile Entity class: %1$s", this.getClass().getSimpleName());
    }

    private boolean openGuiOnClient(ServerPlayerEntity player, Consumer<PacketBuffer> extraDataWriter) {
        return this.callOnLogicalServer(() -> {
            if (this instanceof INamedContainerProvider && !(player instanceof FakePlayer)) {
                Consumer<PacketBuffer> positionWriter = buffer -> buffer.func_179255_a(this.func_174877_v());
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)this), positionWriter.andThen(extraDataWriter));
                return true;
            }
            return false;
        });
    }
}

