/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.IDragSource;
import it.zerono.mods.zerocore.lib.client.gui.IDraggable;
import it.zerono.mods.zerocore.lib.client.gui.IDropTarget;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.IWindowsManager;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Theme;
import it.zerono.mods.zerocore.lib.client.gui.Window;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

abstract class AbstractWindowsManager<C extends ModContainer>
implements IWindowsManager<C> {
    private static boolean s_debugFrame = false;
    private final ModContainerScreen<C> _guiContainer;
    private final Runnable onGuiContainerCreateHandler;
    private final Runnable onGuiContainerClosedHandler;
    private double _lastWheelMovement;
    private IControl _keyboardFocusTarget;
    private IWindow _keyboardFocusWindow;
    private IControl _mouseCaptureTarget;
    private IWindow _mouseCaptureWindow;
    private DragData _dragData;
    private float _paintPartialTicks;

    @Override
    public ModContainerScreen<C> getGuiScreen() {
        return this._guiContainer;
    }

    @Override
    public IWindow createWindow(IControlContainer rootContainer, boolean modalWindow, int x, int y, int width, int height) {
        Window wnd = new Window(this, rootContainer, x, y, width, height, modalWindow);
        this.addWindow(wnd, modalWindow);
        return wnd;
    }

    @Override
    public double getMouseWheelMovement() {
        return this._lastWheelMovement;
    }

    @Override
    public void setFocus(@Nullable IWindow wnd, @Nullable IControl newFocus) {
        if (this._keyboardFocusTarget != newFocus) {
            IControl previousFocus = this._keyboardFocusTarget;
            if (null != previousFocus) {
                previousFocus.onKillFocus(this._keyboardFocusWindow, newFocus);
            }
            this._keyboardFocusTarget = newFocus;
            this._keyboardFocusWindow = wnd;
            if (null != newFocus && null != wnd) {
                newFocus.onSetFocus(wnd, previousFocus);
            }
            this.forEachWindow(window -> window.onFocusChanged(newFocus));
        }
    }

    @Override
    public void captureMouse(IWindow wnd, IControl target) {
        this._mouseCaptureTarget = target;
        this._mouseCaptureWindow = wnd;
    }

    @Override
    public void releaseMouse() {
        this._mouseCaptureTarget = null;
        this._mouseCaptureWindow = null;
    }

    @Override
    public boolean isMouseCaptured() {
        return null != this._mouseCaptureTarget && null != this._mouseCaptureWindow;
    }

    @Override
    public void startDragging(IDraggable draggable, IDragSource source) {
        this._dragData = new DragData(draggable, source);
    }

    @Override
    public boolean isDragging() {
        return null != this._dragData && this._dragData.isDragging();
    }

    @Override
    public void hideWindow(IWindow wnd) {
        this.showWindow(wnd, false);
    }

    @Override
    public void showWindow(IWindow wnd) {
        this.showWindow(wnd, true);
    }

    @Override
    public boolean isWindowVisible(IWindow wnd) {
        return false;
    }

    @Override
    public float getPaintPartialTicks() {
        return this._paintPartialTicks;
    }

    @Override
    public void onThemeChanged(Theme newTheme) {
        this.forEachWindow(window -> window.onThemeChanged(newTheme));
    }

    public static void enableDebugFrame(boolean enable) {
        boolean bl = s_debugFrame = CodeHelper.isDevEnv() && enable;
        if (null != Minecraft.func_71410_x().field_71439_g) {
            CodeHelper.sendStatusMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITextComponent)new StringTextComponent(String.format("GUI debug hover-frame is now %s", s_debugFrame ? "enabled" : "disabled")));
        }
    }

    protected abstract void addWindow(Window<C> var1, boolean var2);

    protected abstract void showWindow(IWindow var1, boolean var2);

    protected abstract void forEachWindow(Consumer<Window<C>> var1);

    protected abstract void forEachInteractiveWindow(Consumer<Window<C>> var1);

    @Nullable
    protected abstract <R> R forEachInteractiveWindow(Function<Window<C>, R> var1, @Nullable R var2);

    protected abstract Optional<IControl> findControl(int var1, int var2);

    protected AbstractWindowsManager(ModContainerScreen<C> guiContainer) {
        this._guiContainer = guiContainer;
        this.resetState();
        this.onGuiContainerCreateHandler = this.getGuiScreen().Create.subscribe(this::onGuiContainerCreate);
        this.onGuiContainerClosedHandler = this.getGuiScreen().Close.subscribe(this::onGuiContainerClosed);
    }

    private void onGuiContainerCreate() {
        this.resetState();
    }

    private void onGuiContainerClosed() {
        this.forEachWindow(Window::onWindowClosed);
        this.getGuiScreen().Create.unsubscribe(this.onGuiContainerCreateHandler);
        this.getGuiScreen().Close.unsubscribe(this.onGuiContainerClosedHandler);
    }

    void onGuiContainerTick() {
        this.forEachWindow(Window::onTick);
    }

    void onGuiContainerPaintBackground(MatrixStack matrix, float partialTicks) {
        int mouseX = this.getGuiScreen().getClippedMouseX();
        int mouseY = this.getGuiScreen().getClippedMouseY();
        this._paintPartialTicks = partialTicks;
        this.forEachWindow(window -> window.onPaintBackground(matrix, partialTicks, mouseX, mouseY));
    }

    void onGuiContainerPaintForeground(MatrixStack matrix) {
        float partialTicks = this.getPaintPartialTicks();
        int mouseX = this.getGuiScreen().getClippedMouseX();
        int mouseY = this.getGuiScreen().getClippedMouseY();
        int guiLeft = this.getGuiScreen().getGuiX();
        int guiTop = this.getGuiScreen().getGuiY();
        RenderSystem.translatef((float)(-guiLeft), (float)(-guiTop), (float)0.0f);
        this.forEachWindow(window -> window.onPaint(matrix, partialTicks, mouseX, mouseY));
        this.forEachWindow(window -> window.onPaintOverlay(matrix, partialTicks, mouseX, mouseY));
        if (!Screen.func_231174_t_()) {
            this.forEachInteractiveWindow(w -> w.paintToolTips(matrix));
            RenderHelper.func_227783_c_();
        }
        if (this.isDragging()) {
            this._dragData.paint(matrix, mouseX, mouseY, this.getGuiScreen().getZLevel());
        }
        if (s_debugFrame) {
            this.forEachInteractiveWindow(window -> window.onPaintDebugFrame(matrix, Colour.WHITE));
        }
        RenderSystem.translatef((float)guiLeft, (float)guiTop, (float)0.0f);
    }

    boolean onGuiContainerMouseClicked(double mouseX, double mouseY, int clickedButton) {
        int mx = MathHelper.func_76140_b((double)mouseX);
        int my = MathHelper.func_76140_b((double)mouseY);
        if (this.isDragging()) {
            if (1 == clickedButton) {
                this.cancelDragging();
            } else {
                this.stopDragging(mx, my);
            }
            return true;
        }
        Boolean result = this.forEachInteractiveWindow(window -> window.onMouseClicked(mx, my, clickedButton), false);
        return null != result && result != false;
    }

    boolean onGuiContainerMouseReleased(double mouseX, double mouseY, int mouseButton) {
        int mx = MathHelper.func_76140_b((double)mouseX);
        int my = MathHelper.func_76140_b((double)mouseY);
        if (this.isDragging()) {
            this.stopDragging(mx, my);
        }
        if (s_debugFrame && 1 == mouseButton) {
            this.forEachInteractiveWindow(Window::onDisplayDebugFrameControlName);
        }
        if (-1 != mouseButton) {
            return this.raiseMouseReleased(mx, my, mouseButton);
        }
        this.raiseMouseMoved(mx, my);
        return false;
    }

    void onGuiContainerMouseMoved(double mouseX, double mouseY) {
        this.raiseMouseMoved(MathHelper.func_76140_b((double)mouseX), MathHelper.func_76140_b((double)mouseY));
    }

    boolean onGuiContainerMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        this._lastWheelMovement = scrollDelta;
        return this.raiseMouseWheel(MathHelper.func_76140_b((double)mouseX), MathHelper.func_76140_b((double)mouseY), scrollDelta);
    }

    boolean onGuiContainerCharTyped(char typedChar, int keyCode) {
        try {
            if (null != this._keyboardFocusTarget && null != this._keyboardFocusWindow && this._keyboardFocusTarget.onCharTyped(this._keyboardFocusWindow, typedChar, keyCode)) {
                return true;
            }
            Boolean result = this.forEachInteractiveWindow(window -> window.onCharTyped(typedChar, keyCode), false);
            return null != result && result != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean onGuiContainerKeyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            if (null != this._keyboardFocusTarget && null != this._keyboardFocusWindow && this._keyboardFocusTarget.onKeyPressed(this._keyboardFocusWindow, keyCode, scanCode, modifiers)) {
                return true;
            }
            Boolean result = this.forEachInteractiveWindow(window -> window.onKeyPressed(keyCode, scanCode, modifiers), false);
            return null != result && result != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean onGuiContainerKeyReleased(int keyCode, int scanCode, int modifiers) {
        try {
            if (null != this._keyboardFocusTarget && null != this._keyboardFocusWindow && this._keyboardFocusTarget.onKeyReleased(this._keyboardFocusWindow, keyCode, scanCode, modifiers)) {
                return true;
            }
            Boolean result = this.forEachInteractiveWindow(window -> window.onKeyReleased(keyCode, scanCode, modifiers), false);
            return null != result && result != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void resetState() {
        this._lastWheelMovement = 0.0;
        this._paintPartialTicks = 0.0f;
        this.releaseMouse();
        this.setFocus(null, null);
        if (null != this._dragData) {
            this._dragData.clear();
            this._dragData = null;
        }
    }

    void validate(Consumer<ITextComponent> errorReport) {
        this.forEachWindow(w -> w.validate(errorReport));
    }

    private void raiseMouseMoved(int mouseX, int mouseY) {
        if (null != this._mouseCaptureTarget) {
            Point childXY = this._mouseCaptureTarget.screenToControl(mouseX, mouseY);
            this._mouseCaptureTarget.onMouseMoved(this._mouseCaptureWindow, childXY.X, childXY.Y);
        } else {
            this.forEachInteractiveWindow(window -> window.onMouseMoved(mouseX, mouseY));
        }
    }

    private boolean raiseMouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (null != this._mouseCaptureTarget) {
            Point childXY = this._mouseCaptureTarget.screenToControl(mouseX, mouseY);
            return this._mouseCaptureTarget.onMouseReleased(this._mouseCaptureWindow, childXY.X, childXY.Y, mouseButton);
        }
        Boolean result = this.forEachInteractiveWindow(window -> window.onMouseReleased(mouseX, mouseY, mouseButton), false);
        return null != result && result != false;
    }

    private boolean raiseMouseWheel(int mouseX, int mouseY, double wheelMovement) {
        if (null != this._mouseCaptureTarget) {
            Point childXY = this._mouseCaptureTarget.screenToControl(mouseX, mouseY);
            return this._mouseCaptureTarget.onMouseWheel(this._mouseCaptureWindow, childXY.X, childXY.Y, wheelMovement);
        }
        Boolean result = this.forEachInteractiveWindow(window -> window.onMouseWheel(mouseX, mouseY, wheelMovement), false);
        return null != result && result != false;
    }

    private void cancelDragging() {
        if (this.isDragging()) {
            this._dragData.pushBack();
            this._dragData.clear();
            this._dragData = null;
        }
    }

    private void stopDragging(int mouseX, int mouseY) {
        if (!this.isDragging()) {
            return;
        }
        boolean dropped = this.findControl(mouseX, mouseY).filter(control -> control instanceof IDropTarget && this._dragData.tryDrop((IDropTarget)((Object)control))).isPresent();
        if (!dropped) {
            this._dragData.pushBack();
        }
        this._dragData.clear();
        this._dragData = null;
    }

    private static final class DragData {
        private IDraggable _draggable;
        private IDragSource _source;
        private int _paintXOffset;
        private int _paintYOffset;

        DragData(IDraggable draggable, IDragSource source) {
            this._draggable = draggable;
            this._source = source;
            this._paintXOffset = -(draggable.getWidth() / 2);
            this._paintYOffset = -(draggable.getHeight() / 2);
        }

        boolean isDragging() {
            return null != this._source && null != this._draggable;
        }

        void clear() {
            this._draggable = null;
            this._source = null;
            this._paintYOffset = 0;
            this._paintXOffset = 0;
        }

        void paint(MatrixStack matrix, int mouseX, int mouseY, float zLevel) {
            this._draggable.onPaint(matrix, mouseX + this._paintXOffset, mouseY + this._paintYOffset, zLevel, IDraggable.PaintState.Dragging);
        }

        void pushBack() {
            this._source.setDraggable(this._draggable);
            this._draggable = null;
        }

        boolean tryDrop(IDropTarget dropTarget) {
            if (dropTarget.canAcceptDrop(this._draggable)) {
                this._source.setDraggable(null);
                dropTarget.setDraggable(this._draggable);
                this._draggable = null;
                return true;
            }
            return false;
        }
    }
}

