/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.layout;

import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.layout.AbstractLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;

public class AnchoredLayoutEngine
extends AbstractLayoutEngine<AnchoredLayoutEngine> {
    @Override
    public void layout(IControlContainer controlsContainer) {
        Rectangle parentBounds = controlsContainer.getBounds();
        int horizontalMargin = this.getHorizontalMargin();
        int verticalMargin = this.getVerticalMargin();
        int undefinedWidth = this.computeUndefinedDimensionSize(controlsContainer, DesiredDimension.Width, parentBounds.Width);
        int undefinedHeight = this.computeUndefinedDimensionSize(controlsContainer, DesiredDimension.Height, parentBounds.Height);
        int bandMaxWidth = parentBounds.Width - horizontalMargin * 2;
        int bandMaxHeight = parentBounds.Height - verticalMargin * 2;
        for (IControl control : controlsContainer) {
            Rectangle newBounds;
            int controlWidth = Math.min(bandMaxWidth, this.getControlDesiredDimension(control, DesiredDimension.Width, undefinedWidth));
            int controlHeight = Math.min(bandMaxHeight, this.getControlDesiredDimension(control, DesiredDimension.Height, undefinedHeight));
            switch (this.getAnchorFrom(control)) {
                case Top: {
                    newBounds = new Rectangle(horizontalMargin, verticalMargin, bandMaxWidth, controlHeight);
                    break;
                }
                case Bottom: {
                    newBounds = new Rectangle(horizontalMargin, parentBounds.Height - controlHeight - verticalMargin, bandMaxWidth, controlHeight);
                    break;
                }
                case Left: {
                    newBounds = new Rectangle(horizontalMargin, verticalMargin, controlWidth, bandMaxHeight);
                    break;
                }
                case Right: {
                    newBounds = new Rectangle(parentBounds.Width - controlWidth - horizontalMargin, verticalMargin, controlWidth, bandMaxHeight);
                    break;
                }
                case TopLeft: {
                    newBounds = new Rectangle(horizontalMargin, verticalMargin, controlWidth, controlHeight);
                    break;
                }
                case TopRight: {
                    newBounds = new Rectangle(parentBounds.Width - controlWidth - horizontalMargin, verticalMargin, controlWidth, controlHeight);
                    break;
                }
                case BottomLeft: {
                    newBounds = new Rectangle(horizontalMargin, parentBounds.Height - controlHeight - verticalMargin, controlWidth, controlHeight);
                    break;
                }
                case BottomRight: {
                    newBounds = new Rectangle(parentBounds.Width - controlWidth - horizontalMargin, parentBounds.Height - controlHeight - verticalMargin, controlWidth, controlHeight);
                    break;
                }
                case Center: {
                    newBounds = new Rectangle((bandMaxWidth - controlWidth) / 2, (bandMaxHeight - controlHeight) / 2, controlWidth, controlHeight);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown anchor");
                }
            }
            control.setBounds(newBounds);
        }
    }

    private Anchor getAnchorFrom(IControl control) {
        return control.getLayoutEngineHint().filter(h -> h instanceof Anchor).map(h -> (Anchor)h).orElse(Anchor.TopLeft);
    }

    public static enum Anchor implements ILayoutEngine.ILayoutEngineHint
    {
        Left,
        Right,
        Top,
        Bottom,
        TopLeft,
        TopRight,
        BottomLeft,
        BottomRight,
        Center;

    }
}

