/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public final class ModRenderHelper {
    public static final float ONE_PIXEL = 0.0625f;
    public static final int GUI_TOPMOST_Z = 900;
    public static final int GUI_ITEM_Z = 600;
    public static final NonNullSupplier<FontRenderer> DEFAULT_FONT_RENDERER = () -> Minecraft.func_71410_x().field_71466_p;

    public static long getLastRenderTime() {
        return ZeroCore.getProxy().getLastRenderTime();
    }

    public static ModelManager getModelManager() {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b();
    }

    public static IUnbakedModel getModel(ResourceLocation location) {
        return ModelLoader.instance().getModelOrMissing(location);
    }

    public static IBakedModel getModel(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
    }

    public static IBakedModel getModel(ModelResourceLocation modelLocation) {
        return ModRenderHelper.getModelManager().func_174953_a(modelLocation);
    }

    public static IBakedModel getMissingModel() {
        return ModRenderHelper.getModelManager().func_174951_a();
    }

    @Nullable
    public static IBakedModel getMissingModel(Map<ResourceLocation, IBakedModel> modelRegistry) {
        return modelRegistry.get(ModelBakery.field_177604_a);
    }

    public static void bindTexture(ResourceLocation textureLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureLocation);
    }

    public static void bindTexture(ISprite sprite) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(sprite.getTextureMap().getTextureLocation());
    }

    public static void bindBlocksTexture() {
        ModRenderHelper.bindTexture(PlayerContainer.field_226615_c_);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation location) {
        return ModRenderHelper.getTextureSprite(PlayerContainer.field_226615_c_, location);
    }

    public static TextureAtlasSprite getTextureSprite(ResourceLocation atlasName, ResourceLocation spriteName) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(atlasName).apply(spriteName);
    }

    public static TextureAtlasSprite getFluidStillSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getAttributes().getStillTexture());
    }

    public static TextureAtlasSprite getFluidStillSprite(FluidStack fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getFluid().getAttributes().getStillTexture(fluid));
    }

    public static TextureAtlasSprite getFluidFlowingSprite(Fluid fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getAttributes().getFlowingTexture());
    }

    public static TextureAtlasSprite getFluidFlowingSprite(FluidStack fluid) {
        return ModRenderHelper.getTextureSprite(fluid.getFluid().getAttributes().getFlowingTexture(fluid));
    }

    public static TextureAtlasSprite getMissingTexture(ResourceLocation atlasName) {
        return ModRenderHelper.getTextureSprite(atlasName, MissingTextureSprite.func_195675_b());
    }

    public static TextureAtlasSprite getMissingTexture() {
        return ModRenderHelper.getTextureSprite(MissingTextureSprite.func_195675_b());
    }

    @Nullable
    public static TextureAtlasSprite getFluidOverlaySprite(Fluid fluid) {
        ResourceLocation rl = fluid.getAttributes().getOverlayTexture();
        return null != rl ? ModRenderHelper.getTextureSprite(rl) : null;
    }

    @Nullable
    public static TextureAtlasSprite getFluidOverlaySprite(FluidStack fluid) {
        ResourceLocation rl = fluid.getFluid().getAttributes().getOverlayTexture();
        return null != rl ? ModRenderHelper.getTextureSprite(rl) : null;
    }

    public static ISprite getStillFluidSprite(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(fluid), null);
    }

    public static ISprite getStillFluidSpriteWithOverlay(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidStillSprite(fluid), ModRenderHelper.getFluidOverlaySprite(fluid));
    }

    public static ISprite getFlowingFluidSprite(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(fluid), null);
    }

    public static ISprite getFlowingFluidSpriteWithOverlay(Fluid fluid) {
        return ModRenderHelper.buildSprite(ModRenderHelper.getFluidFlowingSprite(fluid), ModRenderHelper.getFluidOverlaySprite(fluid));
    }

    private static ISprite buildSprite(TextureAtlasSprite main, @Nullable TextureAtlasSprite overlay) {
        ISprite s = AtlasSpriteTextureMap.from(main).sprite(main);
        if (null != overlay) {
            return s.copyWith(AtlasSpriteTextureMap.from(overlay).sprite(overlay));
        }
        return s;
    }

    public static List<ITextProperties> splitLines(FontRenderer font, String line, int maxLineWidth) {
        return ModRenderHelper.splitLines(font, line, maxLineWidth, Style.field_240709_b_);
    }

    public static List<ITextProperties> splitLines(FontRenderer font, String line, int maxLineWidth, Style lineStyle) {
        return font.func_238420_b_().func_238365_g_(line, maxLineWidth, lineStyle);
    }

    public static List<ITextProperties> splitLines(FontRenderer font, ITextProperties line, int maxLineWidth) {
        return ModRenderHelper.splitLines(font, line, maxLineWidth, Style.field_240709_b_);
    }

    public static List<ITextProperties> splitLines(FontRenderer font, ITextProperties line, int maxLineWidth, Style lineStyle) {
        return font.func_238420_b_().func_238362_b_(line, maxLineWidth, lineStyle);
    }

    @Deprecated
    public static List<ITextProperties> wrapLines(ITextProperties line, int maxLineWidth, FontRenderer font) {
        return ModRenderHelper.wrapLines(line, Style.field_240709_b_, maxLineWidth, font);
    }

    @Deprecated
    public static List<ITextProperties> wrapLines(ITextProperties line, Style lineStyle, int maxLineWidth, FontRenderer font) {
        return font.func_238420_b_().func_238362_b_(line, maxLineWidth, lineStyle);
    }

    @Deprecated
    public static List<String> wrapLines(String text, int maxLineWidth, FontRenderer font) {
        LinkedList lines = Lists.newLinkedList();
        int spaceWidth = font.func_78256_a(" ");
        String[] tokens = text.split("\\s+");
        Integer[] tokenWidths = (Integer[])Arrays.stream(tokens).map(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).toArray(Integer[]::new);
        StringBuilder wrappedLine = new StringBuilder(text.length());
        int lineWidth = 0;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int tokenWidth = tokenWidths[i];
            if (lineWidth + tokenWidth + spaceWidth > maxLineWidth) {
                lines.add(wrappedLine.toString());
                wrappedLine = new StringBuilder(text.length());
                lineWidth = 0;
            }
            if (i < tokens.length - 1 && lineWidth + tokenWidth + spaceWidth + tokenWidths[i + 1] <= maxLineWidth) {
                wrappedLine.append(token);
                wrappedLine.append(" ");
                lineWidth += tokenWidth + spaceWidth;
                continue;
            }
            wrappedLine.append(token);
            lineWidth += tokenWidth;
        }
        if (wrappedLine.length() > 0) {
            lines.add(wrappedLine.toString());
        }
        return lines;
    }

    public static void renderQuads(MatrixStack matrix, IVertexBuilder builder, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        MatrixStack.Entry entry = matrix.func_227866_c_();
        for (BakedQuad quad : quads) {
            builder.addVertexData(entry, quad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderQuads(MatrixStack matrix, IVertexBuilder builder, List<BakedQuad> quads, int combinedLight, int combinedOverlay, Function<Integer, Colour> quadTintGetter) {
        MatrixStack.Entry entry = matrix.func_227866_c_();
        for (BakedQuad quad : quads) {
            float blue;
            float green;
            float red;
            if (quad.func_178212_b()) {
                Colour tint = quadTintGetter.apply(quad.func_178211_c());
                red = tint.R;
                green = tint.G;
                blue = tint.B;
            } else {
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            builder.addVertexData(entry, quad, red, green, blue, combinedLight, combinedOverlay, true);
        }
    }

    public static void renderModel(IBakedModel model, IModelData data, MatrixStack matrix, IVertexBuilder builder, int combinedLight, int combinedOverlay) {
        for (Direction direction : CodeHelper.DIRECTIONS) {
            ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, direction, CodeHelper.fakeRandom(), data), combinedLight, combinedOverlay);
        }
        ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, null, CodeHelper.fakeRandom(), data), combinedLight, combinedOverlay);
    }

    public static void renderModel(IBakedModel model, IModelData data, MatrixStack matrix, IVertexBuilder builder, int combinedLight, int combinedOverlay, Function<Integer, Colour> quadTintGetter) {
        for (Direction direction : CodeHelper.DIRECTIONS) {
            ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, direction, CodeHelper.fakeRandom(), data), combinedLight, combinedOverlay, quadTintGetter);
        }
        ModRenderHelper.renderQuads(matrix, builder, model.getQuads(null, null, CodeHelper.fakeRandom(), data), combinedLight, combinedOverlay, quadTintGetter);
    }

    public static Vector3d[] getQuadVerticesFor(Direction face, float width, float height, float depth) {
        return ModRenderHelper.getQuadVerticesFor(face, width, height, depth, Vector3d.ZERO);
    }

    public static Vector3d[] getQuadVerticesFor(Direction face, float width, float height, float depth, Vector3d offset) {
        Vector3d nearToFar;
        Vector3d bottomToTop;
        Vector3d leftToRight;
        switch (face) {
            case NORTH: {
                leftToRight = Vector3d.XN;
                bottomToTop = Vector3d.YP;
                nearToFar = Vector3d.ZN;
                break;
            }
            case SOUTH: {
                leftToRight = Vector3d.XP;
                bottomToTop = Vector3d.YP;
                nearToFar = Vector3d.ZP;
                break;
            }
            case EAST: {
                leftToRight = Vector3d.ZN;
                bottomToTop = Vector3d.YP;
                nearToFar = Vector3d.XP;
                break;
            }
            default: {
                leftToRight = Vector3d.ZP;
                bottomToTop = Vector3d.YP;
                nearToFar = Vector3d.XN;
                break;
            }
            case UP: {
                leftToRight = Vector3d.XN;
                bottomToTop = Vector3d.ZP;
                nearToFar = Vector3d.YP;
                break;
            }
            case DOWN: {
                leftToRight = Vector3d.XP;
                bottomToTop = Vector3d.ZP;
                nearToFar = Vector3d.YN;
            }
        }
        leftToRight = leftToRight.multiply((double)width * 0.5);
        bottomToTop = bottomToTop.multiply((double)height * 0.5);
        nearToFar = nearToFar.multiply((double)depth * 0.5);
        Vector3d[] vertices = new Vector3d[]{Vector3d.HALF.subtract(leftToRight).subtract(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.add(leftToRight).subtract(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.add(leftToRight).add(bottomToTop).add(nearToFar).add(offset), Vector3d.HALF.subtract(leftToRight).add(bottomToTop).add(nearToFar).add(offset)};
        return vertices;
    }

    public static void paintVoxelShape(MatrixStack matrix, VoxelShape shape, IVertexBuilder vertexBuilder, double originX, double originY, double originZ, Colour colour) {
        Matrix4f m = matrix.func_227866_c_().func_227870_a_();
        float red = colour.glRed();
        float green = colour.glGreen();
        float blue = colour.glBlue();
        float alpha = colour.glAlpha();
        shape.func_197754_a((x1, y1, z1, x2, y2, z2) -> {
            vertexBuilder.func_227888_a_(m, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            vertexBuilder.func_227888_a_(m, (float)(x2 + originX), (float)(y2 + originY), (float)(z2 + originZ)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
    }

    public static void paintSprite(MatrixStack matrix, ISprite sprite, Point screenXY, int zLevel, int width, int height) {
        ModRenderHelper.paintSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, width, height);
    }

    public static void paintSprite(MatrixStack matrix, ISprite sprite, int x, int y, int zLevel, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ModRenderHelper.bindTexture(sprite);
        ModRenderHelper.blitSprite(matrix, x, x + width, y, y + height, zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight());
        RenderSystem.disableBlend();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(matrix, o, x, y, zLevel, width, height)));
    }

    public static void paintSprite(MatrixStack matrix, ISprite sprite, int xOffset, int yOffset, int zLevel, Padding padding, int width, int height, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ModRenderHelper.bindTexture(sprite);
        int x = xOffset + padding.getLeft() + maskLeft;
        int y = yOffset + padding.getTop() + maskTop;
        int u = sprite.getU() + maskLeft;
        int v = sprite.getV() + maskTop;
        int paintWidth = width - maskRight - maskLeft;
        int paintHeight = height - maskBottom - maskTop;
        float widthRatio = 1.0f / (float)sprite.getTextureMap().getWidth();
        float heightRatio = 1.0f / (float)sprite.getTextureMap().getHeight();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(pose, (float)x, (float)(y + paintHeight), (float)zLevel).func_225583_a_((float)u * widthRatio, ((float)v + (float)paintHeight) * heightRatio).func_181675_d();
        bufferbuilder.func_227888_a_(pose, (float)(x + paintWidth), (float)(y + paintHeight), (float)zLevel).func_225583_a_(((float)u + (float)paintWidth) * widthRatio, ((float)v + (float)paintHeight) * heightRatio).func_181675_d();
        bufferbuilder.func_227888_a_(pose, (float)(x + paintWidth), (float)y, (float)zLevel).func_225583_a_(((float)u + (float)paintWidth) * widthRatio, (float)v * heightRatio).func_181675_d();
        bufferbuilder.func_227888_a_(pose, (float)x, (float)y, (float)zLevel).func_225583_a_((float)u * widthRatio, (float)v * heightRatio).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(matrix, o, xOffset, yOffset, zLevel, padding, width, height, maskTop, maskBottom, maskLeft, maskRight)));
    }

    public static int paintVerticalProgressSprite(MatrixStack matrix, ISprite sprite, Colour tint, Point screenXY, int zLevel, Rectangle area, int skip, double progress) {
        return ModRenderHelper.paintVerticalProgressSprite(matrix, sprite, tint, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, skip, progress);
    }

    public static int paintVerticalProgressSprite(MatrixStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int areaWidth, int areaHeight, int skip, double progress) {
        if (progress < 0.01) {
            return 0;
        }
        int filledHeight = (int)((double)areaHeight * progress);
        int y2 = y + areaHeight - skip;
        int y1 = y2 - filledHeight;
        ModRenderHelper.paintProgressSprite(matrix, sprite, tint, x, y1, x + areaWidth, y2, zLevel);
        return filledHeight;
    }

    @Deprecated
    public static void paintVerticalProgressBarSprite(MatrixStack matrix, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress) {
        ModRenderHelper.paintVerticalProgressBarSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, progress, Colour.WHITE);
    }

    @Deprecated
    public static void paintVerticalProgressBarSprite(MatrixStack matrix, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress, Colour tint) {
        ModRenderHelper.paintVerticalProgressBarSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, progress, tint);
    }

    @Deprecated
    public static void paintVerticalProgressBarSprite(MatrixStack matrix, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress) {
        ModRenderHelper.paintVerticalProgressBarSprite(matrix, sprite, x, y, zLevel, areaWidth, areaHeight, progress, Colour.WHITE);
    }

    @Deprecated
    public static void paintVerticalProgressBarSprite(MatrixStack matrix, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress, Colour tint) {
        if (progress < 0.01) {
            return;
        }
        int filledHeight = (int)((double)areaHeight * progress);
        int y1 = y + (areaHeight - filledHeight);
        int y2 = y + areaHeight;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ModRenderHelper.bindTexture(sprite);
        if (sprite.getHeight() == areaHeight) {
            ModRenderHelper.blitSprite(matrix, x, x + sprite.getWidth(), y, y + sprite.getHeight(), zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
        } else {
            int spriteHeight = sprite.getHeight();
            float verticalSlices = (float)filledHeight / (float)spriteHeight;
            int verticalSliceIdx = 0;
            while ((float)verticalSliceIdx <= verticalSlices - 1.0f) {
                int sliceY2 = y2 - verticalSliceIdx * spriteHeight;
                int sliceY1 = sliceY2 - spriteHeight;
                ModRenderHelper.blitSprite(matrix, x, x + areaWidth + 16, sliceY1, sliceY2, zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
                verticalSliceIdx = 5;
                ++verticalSliceIdx;
            }
            float missing = verticalSlices - (float)verticalSliceIdx;
            if (missing > 0.0f) {
                int sliceY2 = y2 - verticalSliceIdx * spriteHeight;
                int sliceY1 = sliceY2 - (int)Math.ceil((float)spriteHeight * missing);
                ModRenderHelper.blitSprite(matrix, x, x + areaWidth, sliceY1, sliceY2, zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
            }
        }
        RenderSystem.disableBlend();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(matrix, o, x, y, zLevel, areaWidth, areaHeight)));
    }

    @Deprecated
    public static void paintFlippedVerticalProgressBarSprite(MatrixStack matrix, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress) {
        ModRenderHelper.paintFlippedVerticalProgressBarSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, progress, Colour.WHITE);
    }

    @Deprecated
    public static void paintFlippedVerticalProgressBarSprite(MatrixStack matrix, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress, Colour tint) {
        ModRenderHelper.paintFlippedVerticalProgressBarSprite(matrix, sprite, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, progress, tint);
    }

    @Deprecated
    public static void paintFlippedVerticalProgressBarSprite(MatrixStack matrix, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress) {
        ModRenderHelper.paintFlippedVerticalProgressBarSprite(matrix, sprite, x, y, zLevel, areaWidth, areaHeight, progress, Colour.WHITE);
    }

    @Deprecated
    public static void paintFlippedVerticalProgressBarSprite(MatrixStack matrix, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress, Colour tint) {
        if (progress < 0.01) {
            return;
        }
        int spriteHeight = sprite.getHeight();
        int filledHeight = (int)((double)areaHeight * progress);
        int y1 = y;
        int y2 = y + filledHeight;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ModRenderHelper.bindTexture(sprite);
        if (spriteHeight == areaHeight) {
            ModRenderHelper.blitSprite(matrix, x, x + areaWidth, y1, y2, zLevel, sprite.getWidth(), filledHeight, sprite.getU(), sprite.getV() + (sprite.getHeight() - filledHeight), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
        } else {
            float verticalSlices = (float)filledHeight / 16.0f;
            int verticalSliceIdx = 0;
            while ((float)verticalSliceIdx <= verticalSlices - 1.0f) {
                int sliceY1 = y1 + verticalSliceIdx * 16;
                int sliceY2 = sliceY1 + 16;
                ModRenderHelper.blitSprite(matrix, x, x + areaWidth, sliceY1, sliceY2, zLevel, sprite.getWidth(), sprite.getHeight(), sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
                ++verticalSliceIdx;
            }
            float missing = verticalSlices - (float)verticalSliceIdx;
            if (missing > 0.0f) {
                int h = (int)Math.ceil(16.0f * missing);
                int sliceY1 = y1 + verticalSliceIdx * 16;
                int sliceY2 = sliceY1 + h;
                ModRenderHelper.blitSprite(matrix, x, x + areaWidth, sliceY1, sliceY2, zLevel, sprite.getWidth(), h, sprite.getU(), sprite.getV(), sprite.getTextureMap().getWidth(), sprite.getTextureMap().getHeight(), tint);
            }
        }
        RenderSystem.disableBlend();
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintSprite(matrix, o, x, y, zLevel, areaWidth, areaHeight)));
    }

    @Deprecated
    public static int paintHorizontalProgressSprite(MatrixStack matrix, ISprite sprite, Colour tint, Point screenXY, int zLevel, Rectangle area, int skip, double progress) {
        return ModRenderHelper.paintHorizontalProgressSprite(matrix, sprite, tint, screenXY.X, screenXY.Y, zLevel, area.Width, area.Height, skip, progress);
    }

    @Deprecated
    public static int paintHorizontalProgressSprite(MatrixStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int areaWidth, int areaHeight, int skip, double progress) {
        if (progress < 0.01) {
            return 0;
        }
        int filledWidth = (int)((double)areaWidth * progress);
        int x1 = x + skip;
        int x2 = x1 + filledWidth;
        ModRenderHelper.paintProgressSprite(matrix, sprite, tint, x1, y, x2, y + areaHeight, zLevel);
        return filledWidth;
    }

    @Deprecated
    private static void paintProgressSprite(MatrixStack matrix, ISprite sprite, Colour tint, int x1, int y1, int x2, int y2, int zLevel) {
        ModRenderHelper.bindTexture(sprite);
        ModRenderHelper.blitSprite(matrix.func_227866_c_().func_227870_a_(), x1, x2, y1, y2, zLevel, sprite.getMinU(), sprite.getMaxU(), sprite.getMinV(), sprite.getMaxV(), tint);
        sprite.applyOverlay((NonNullConsumer<ISprite>)((NonNullConsumer)o -> ModRenderHelper.paintProgressSprite(matrix, o, tint, x1, y1, x2, y2, zLevel)));
    }

    public static void paintOrientedProgressBarSprite(MatrixStack matrix, Orientation orientation, ISprite sprite, Point screenXY, int zLevel, Rectangle area, double progress, Colour tint) {
        switch (orientation) {
            case BottomToTop: {
                ModRenderHelper.paintBottomToTopTiledSprite(matrix, sprite, tint, screenXY.X, screenXY.Y + area.Height, zLevel, area.Width, (int)((double)area.Height * progress));
                break;
            }
            case TopToBottom: {
                ModRenderHelper.paintTopToBottomTiledSprite(matrix, sprite, tint, screenXY.X, screenXY.Y, zLevel, area.Width, (int)((double)area.Height * progress));
                break;
            }
            case LeftToRight: {
                ModRenderHelper.paintLeftToRightTiledSprite(matrix, sprite, tint, screenXY.X, screenXY.Y, zLevel, (int)((double)area.Width * progress), area.Height);
                break;
            }
            case RightToLeft: {
                ModRenderHelper.paintRightToLeftTiledSprite(matrix, sprite, tint, screenXY.X + area.Width, screenXY.Y, zLevel, (int)((double)area.Width * progress), area.Height);
            }
        }
    }

    public static void paintOrientedProgressBarSprite(MatrixStack matrix, Orientation orientation, ISprite sprite, int x, int y, int zLevel, int areaWidth, int areaHeight, double progress, Colour tint) {
        switch (orientation) {
            case BottomToTop: {
                ModRenderHelper.paintBottomToTopTiledSprite(matrix, sprite, tint, x, y + areaHeight, zLevel, areaWidth, (int)((double)areaHeight * progress));
                break;
            }
            case TopToBottom: {
                ModRenderHelper.paintTopToBottomTiledSprite(matrix, sprite, tint, x, y, zLevel, areaWidth, (int)((double)areaHeight * progress));
                break;
            }
            case LeftToRight: {
                ModRenderHelper.paintLeftToRightTiledSprite(matrix, sprite, tint, x, y, zLevel, (int)((double)areaWidth * progress), areaHeight);
                break;
            }
            case RightToLeft: {
                ModRenderHelper.paintRightToLeftTiledSprite(matrix, sprite, tint, x + areaWidth, y, zLevel, (int)((double)areaWidth * progress), areaHeight);
            }
        }
    }

    public static void paintTopToBottomTiledSprite(MatrixStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int tileY1 = y + verticalTile * spriteHeight;
                int tileY2 = tileY1 + height;
                bufferBuilder.func_227888_a_(pose, (float)tileX1, (float)tileY2, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(spriteMinU, tileMaxV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX2, (float)tileY2, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(tileMaxU, tileMaxV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX2, (float)tileY1, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(tileMaxU, spriteMinV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX1, (float)tileY1, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(spriteMinU, spriteMinV).func_181675_d();
            }
        }
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void paintBottomToTopTiledSprite(MatrixStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMinV = spriteMaxV - deltaV * (float)height / (float)spriteHeight;
                int baseY = y - (verticalTile + 1) * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.func_227888_a_(pose, (float)tileX1, (float)tileY2, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(spriteMinU, spriteMaxV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX2, (float)tileY2, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(tileMaxU, spriteMaxV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX2, (float)tileY1, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(tileMaxU, tileMinV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX1, (float)tileY1, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(spriteMinU, tileMinV).func_181675_d();
            }
        }
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void paintLeftToRightTiledSprite(MatrixStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMaxU = spriteMaxU - deltaU * (float)skippedWidth / (float)spriteWidth;
            int tileX1 = x + horizontalTile * spriteWidth;
            int tileX2 = tileX1 + spriteWidth - skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int baseY = y + verticalTile * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.func_227888_a_(pose, (float)tileX1, (float)tileY2, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(spriteMinU, tileMaxV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX2, (float)tileY2, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(tileMaxU, tileMaxV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX2, (float)tileY1, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(tileMaxU, spriteMinV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX1, (float)tileY1, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(spriteMinU, spriteMinV).func_181675_d();
            }
        }
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void paintRightToLeftTiledSprite(MatrixStack matrix, ISprite sprite, Colour tint, int x, int y, int zLevel, int paintWidth, int paintHeight) {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        float spriteMinU = sprite.getMinU();
        float spriteMaxU = sprite.getMaxU();
        float spriteMinV = sprite.getMinV();
        float spriteMaxV = sprite.getMaxV();
        float deltaU = spriteMaxU - spriteMinU;
        float deltaV = spriteMaxV - spriteMinV;
        int spriteWidth = sprite.getWidth();
        int spriteHeight = sprite.getHeight();
        int horizontalTiles = paintWidth / spriteWidth;
        int verticalTiles = paintHeight / spriteHeight;
        int leftoverWidth = paintWidth - horizontalTiles * spriteWidth;
        int leftoverHeight = paintHeight - verticalTiles * spriteHeight;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        ModRenderHelper.bindTexture(sprite);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        block0: for (int horizontalTile = 0; horizontalTile <= horizontalTiles; ++horizontalTile) {
            int width;
            int n = width = horizontalTile == horizontalTiles ? leftoverWidth : spriteWidth;
            if (0 == width) break;
            int skippedWidth = spriteWidth - width;
            float tileMinU = spriteMaxU - deltaU * (float)width / (float)spriteWidth;
            int tileX2 = x - horizontalTile * spriteWidth;
            int tileX1 = tileX2 - spriteWidth + skippedWidth;
            for (int verticalTile = 0; verticalTile <= verticalTiles; ++verticalTile) {
                int height;
                int n2 = height = verticalTile == verticalTiles ? leftoverHeight : spriteHeight;
                if (0 == height) continue block0;
                int skippedHeight = spriteHeight - height;
                float tileMaxV = spriteMaxV - deltaV * (float)skippedHeight / (float)spriteHeight;
                int baseY = y + verticalTile * spriteHeight;
                int tileY1 = baseY + skippedHeight;
                int tileY2 = baseY + spriteHeight;
                bufferBuilder.func_227888_a_(pose, (float)tileX1, (float)tileY2, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(tileMinU, tileMaxV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX2, (float)tileY2, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(spriteMaxU, tileMaxV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX2, (float)tileY1, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(spriteMaxU, spriteMinV).func_181675_d();
                bufferBuilder.func_227888_a_(pose, (float)tileX1, (float)tileY1, (float)zLevel).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(tileMinU, spriteMinV).func_181675_d();
            }
        }
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void paintSolidRect(MatrixStack matrix, Point screenXY1, Point screenXY2, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.func_227866_c_().func_227870_a_(), screenXY1.X, screenXY1.Y, screenXY2.X, screenXY2.Y, zLevel, colour.toARGB());
    }

    public static void paintSolidRect(MatrixStack matrix, int x1, int y1, int x2, int y2, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.func_227866_c_().func_227870_a_(), x1, y1, x2, y2, zLevel, colour.toARGB());
    }

    public static void paintHollowRect(MatrixStack matrix, Point screenXY, int width, int height, int zLevel, Colour colour) {
        ModRenderHelper.paintHollowRect(matrix, screenXY.X, screenXY.Y, width, height, zLevel, colour);
    }

    public static void paintHollowRect(MatrixStack matrix, int x1, int y1, int width, int height, int zLevel, Colour colour) {
        ModRenderHelper.paintHorizontalLine(matrix, x1, y1, width, zLevel, colour);
        ModRenderHelper.paintVerticalLine(matrix, x1 + width - 1, y1 + 1, height - 2, zLevel, colour);
        ModRenderHelper.paintHorizontalLine(matrix, x1, y1 + height - 1, width, zLevel, colour);
        ModRenderHelper.paintVerticalLine(matrix, x1, y1 + 1, height - 2, zLevel, colour);
    }

    public static void paintTriangularGradientRect(MatrixStack matrix, int x, int y, int width, int height, int zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        builder.func_225582_a_((double)x2, (double)y, (double)zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, (double)zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x, (double)y2, (double)zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x2, (double)y2, (double)zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void paintHorizontalLine(MatrixStack matrix, Point screenXY, int length, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.func_227866_c_().func_227870_a_(), screenXY.X, screenXY.Y, screenXY.X + length + 1, screenXY.Y + 1, zLevel, colour.toARGB());
    }

    public static void paintHorizontalLine(MatrixStack matrix, int x, int y, int length, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.func_227866_c_().func_227870_a_(), x, y, x + length, y + 1, zLevel, colour.toARGB());
    }

    public static void paintVerticalLine(MatrixStack matrix, Point screenXY, int length, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.func_227866_c_().func_227870_a_(), screenXY.X, screenXY.Y, screenXY.X + 1, screenXY.Y + length + 1, zLevel, colour.toARGB());
    }

    public static void paintVerticalLine(MatrixStack matrix, int x, int y, int length, int zLevel, Colour colour) {
        ModRenderHelper.fill(matrix.func_227866_c_().func_227870_a_(), x, y, x + 1, y + length, zLevel, colour.toARGB());
    }

    public static void paintButton3D(MatrixStack matrix, Point screenXY, int width, int height, int zLevel, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintButton3D(matrix, screenXY.X, screenXY.Y, width, height, zLevel, darkOutlineColour, gradientLightColour, gradientDarkColour, borderLightColour, borderDarkColour);
    }

    public static void paintButton3D(MatrixStack matrix, int x, int y, int width, int height, int zLevel, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintHollowRect(matrix, x, y, width, height, zLevel, darkOutlineColour);
        ModRenderHelper.paintTriangularGradientRect(matrix, x + 2, y + 2, width - 3, height - 3, zLevel, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintHorizontalLine(matrix, x + 1, y + 1, width - 3 + 1, zLevel, borderLightColour);
        ModRenderHelper.paintVerticalLine(matrix, x + 1, y + 1, height - 3, zLevel, borderLightColour);
        ModRenderHelper.paintHorizontalLine(matrix, x + 1, y + height - 2, width - 2, zLevel, borderDarkColour);
        ModRenderHelper.paintVerticalLine(matrix, x + width - 2, y + 1 + 1, height - 3, zLevel, borderDarkColour);
    }

    public static void paintButton3D(MatrixStack matrix, Point screenXY, int width, int height, int zLevel, Colour darkOutlineColour, Colour flatBackgroundColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintButton3D(matrix, screenXY.X, screenXY.Y, width, height, zLevel, darkOutlineColour, flatBackgroundColour, borderLightColour, borderDarkColour);
    }

    public static void paintButton3D(MatrixStack matrix, int x, int y, int width, int height, int zLevel, Colour darkOutlineColour, Colour flatBackgroundColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintHollowRect(matrix, x, y, width, height, zLevel, darkOutlineColour);
        ModRenderHelper.paintSolidRect(matrix, x + 2, y + 2, x + 2 + width - 3, y + 2 + height - 3, zLevel, flatBackgroundColour);
        ModRenderHelper.paintHorizontalLine(matrix, x + 1, y + 1, width - 3 + 1, zLevel, borderLightColour);
        ModRenderHelper.paintVerticalLine(matrix, x + 1, y + 1, height - 3, zLevel, borderLightColour);
        ModRenderHelper.paintHorizontalLine(matrix, x + 1, y + height - 2, width - 2, zLevel, borderDarkColour);
        ModRenderHelper.paintVerticalLine(matrix, x + width - 2, y + 1 + 1, height - 3, zLevel, borderDarkColour);
    }

    public static void paintMessage(MatrixStack matrix, IRichText message, int x, int y, int zLevel, int margin, Colour background, Colour highlight1, Colour highlight2) {
        Rectangle boxBounds = message.bounds().expand(margin * 2, margin * 2).offset(x, y);
        ModRenderHelper.paintVerticalLine(matrix, boxBounds.getX1(), boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, background);
        ModRenderHelper.paintSolidRect(matrix, boxBounds.getX1() + 1, boxBounds.getY1(), boxBounds.getX2(), boxBounds.getY2() + 1, zLevel, background);
        ModRenderHelper.paintVerticalLine(matrix, boxBounds.getX2(), boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, background);
        ModRenderHelper.paintVerticalGradientLine(matrix, boxBounds.getX1() + 1, boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(matrix, boxBounds.getX1() + 2, boxBounds.getY1() + 1, boxBounds.Width - 4, zLevel, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(matrix, boxBounds.getX1() + 2, boxBounds.getY2() - 1, boxBounds.Width - 4, zLevel, highlight1, highlight2);
        ModRenderHelper.paintVerticalGradientLine(matrix, boxBounds.getX2() - 1, boxBounds.getY1() + 1, boxBounds.Height - 2, zLevel, highlight1, highlight2);
        message.paint(matrix, boxBounds.getX1() + margin, boxBounds.getY1() + margin, zLevel + 1);
    }

    private static void blitSprite(Matrix4f matrix, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, (float)blitOffset).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, (float)blitOffset).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, (float)blitOffset).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, (float)blitOffset).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    private static void blitSprite(Matrix4f matrix, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, Colour tint) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, (float)blitOffset).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, (float)blitOffset).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, (float)blitOffset).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, (float)blitOffset).func_225586_a_((int)tint.R, (int)tint.G, (int)tint.B, (int)tint.A).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    private static void blitSprite(MatrixStack matrix, int x1, int x2, int y1, int y2, int blitOffset, int spriteWidth, int spriteHeight, float u, float v, int textureWidth, int textureHeight) {
        ModRenderHelper.blitSprite(matrix.func_227866_c_().func_227870_a_(), x1, x2, y1, y2, blitOffset, (u + 0.0f) / (float)textureWidth, (u + (float)spriteWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)spriteHeight) / (float)textureHeight);
    }

    private static void blitSprite(MatrixStack matrix, int x1, int x2, int y1, int y2, int blitOffset, int spriteWidth, int spriteHeight, float u, float v, int textureWidth, int textureHeight, Colour tint) {
        ModRenderHelper.blitSprite(matrix.func_227866_c_().func_227870_a_(), x1, x2, y1, y2, blitOffset, (u + 0.0f) / (float)textureWidth, (u + (float)spriteWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)spriteHeight) / (float)textureHeight, tint);
    }

    private static void fill(Matrix4f matrix, int minX, int minY, int maxX, int maxY, int zLevel, int color) {
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_227888_a_(matrix, (float)minX, (float)maxY, (float)zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)maxX, (float)maxY, (float)zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)maxX, (float)minY, (float)zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)minX, (float)minY, (float)zLevel).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static boolean paintItemStack(MatrixStack matrix, ItemStack stack, int x, int y, String text, boolean highlight) {
        if (stack.func_190926_b()) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ItemRenderer itemRenderer = mc.func_175599_af();
        float saveZ = itemRenderer.field_77023_b;
        if (highlight) {
            ModRenderHelper.fill(matrix.func_227866_c_().func_227870_a_(), x, y, x + 16, y + 16, 599, -2130706433);
        }
        itemRenderer.field_77023_b = 600.0f;
        RenderSystem.enableDepthTest();
        itemRenderer.func_184391_a((LivingEntity)mc.field_71439_g, stack, x, y);
        itemRenderer.func_180453_a(mc.field_71466_p, stack, x + 4, y, text);
        itemRenderer.field_77023_b = saveZ;
        return true;
    }

    public static boolean paintItemStackWithCount(MatrixStack matrix, ItemStack stack, int x, int y, boolean highlight) {
        return !stack.func_190926_b() && ModRenderHelper.paintItemStack(matrix, stack, x, y, CodeHelper.formatAsHumanReadableNumber(stack.func_190916_E(), ""), highlight);
    }

    public static void paintSolidLines(MatrixStack matrix, Colour colour, double thickness, double zLevel, double ... vertices) {
        GlStateManager.func_227740_m_();
        GlStateManager.func_227621_I_();
        GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        GlStateManager.func_227701_d_((float)((float)thickness));
        int verticesCount = vertices.length;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < verticesCount; i += 2) {
            builder.func_225582_a_(vertices[i], vertices[i + 1], zLevel).func_225586_a_((int)colour.R, (int)colour.G, (int)colour.B, (int)colour.A).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
    }

    public static void paintSolidRects(MatrixStack matrix, Colour colour, double zLevel, int ... vertices) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227621_I_();
        GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        ModRenderHelper.glSetColour(colour);
        builder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        int verticesCount = vertices.length;
        for (int i = 0; i < verticesCount; i += 4) {
            double x1 = vertices[i];
            double y1 = vertices[i + 1];
            double x2 = vertices[i + 2];
            double y2 = vertices[i + 3];
            builder.func_225582_a_(x1, y2, zLevel).func_181675_d();
            builder.func_225582_a_(x2, y2, zLevel).func_181675_d();
            builder.func_225582_a_(x2, y1, zLevel).func_181675_d();
            builder.func_225582_a_(x1, y1, zLevel).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
    }

    public static void paintSolidTriangles(MatrixStack matrix, Colour colour, double zLevel, int ... vertices) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227621_I_();
        GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        ModRenderHelper.glSetColour(colour);
        builder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        int verticesCount = vertices.length;
        for (int i = 0; i < verticesCount; i += 6) {
            double x1 = vertices[i];
            double y1 = vertices[i + 1];
            double x2 = vertices[i + 2];
            double y2 = vertices[i + 3];
            double x3 = vertices[i + 4];
            double y3 = vertices[i + 5];
            builder.func_225582_a_(x1, y1, zLevel).func_181675_d();
            builder.func_225582_a_(x2, y2, zLevel).func_181675_d();
            builder.func_225582_a_(x3, y3, zLevel).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
    }

    public static void paintHorizontalGradientLine(MatrixStack matrix, int x, int y, int length, double zLevel, Colour startColour, Colour endColour) {
        ModRenderHelper.paintHorizontalGradientRect(matrix, x, y, x + length, y + 1, zLevel, startColour, endColour);
    }

    public static void paintVerticalGradientLine(MatrixStack matrix, int x, int y, int length, double zLevel, Colour startColour, Colour endColour) {
        ModRenderHelper.paintVerticalGradientRect(matrix, x, y, x + 1, y + length, zLevel, startColour, endColour);
    }

    public static void paintVerticalGradientRect(MatrixStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour startColour, Colour endColour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        float startAlpha = startColour.glAlpha();
        float startRed = startColour.glRed();
        float startGreen = startColour.glGreen();
        float startBlue = startColour.glBlue();
        float endAlpha = endColour.glAlpha();
        float endRed = endColour.glRed();
        float endGreen = endColour.glGreen();
        float endBlue = endColour.glBlue();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        RenderSystem.shadeModel((int)7425);
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_((double)x2, (double)y1, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x1, (double)y1, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x1, (double)y2, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_((double)x2, (double)y2, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void paintHorizontalGradientRect(MatrixStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour startColour, Colour endColour) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        float startAlpha = startColour.glAlpha();
        float startRed = startColour.glRed();
        float startGreen = startColour.glGreen();
        float startBlue = startColour.glBlue();
        float endAlpha = endColour.glAlpha();
        float endRed = endColour.glRed();
        float endGreen = endColour.glGreen();
        float endBlue = endColour.glBlue();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        RenderSystem.shadeModel((int)7425);
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_((double)x1, (double)y1, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x1, (double)y2, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x2, (double)y2, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_((double)x2, (double)y1, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void paint3DGradientRect(MatrixStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_((double)x2, (double)y1, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x1, (double)y1, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x1, (double)y2, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_((double)x2, (double)y2, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void paint3DGradientTriangle(MatrixStack matrix, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour lightColour, Colour darkColour) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        float startAlpha = lightColour.glAlpha();
        float startRed = lightColour.glRed();
        float startGreen = lightColour.glGreen();
        float startBlue = lightColour.glBlue();
        float endAlpha = darkColour.glAlpha();
        float endRed = darkColour.glRed();
        float endGreen = darkColour.glGreen();
        float endBlue = darkColour.glBlue();
        builder.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_(x1, y1, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(x3, y3, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_(x2, y2, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void paint3DSolidTriangle(MatrixStack matrix, double x1, double y1, double x2, double y2, double x3, double y3, double zLevel, Colour colour) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        float startAlpha = colour.glAlpha();
        float startRed = colour.glRed();
        float startGreen = colour.glGreen();
        float startBlue = colour.glBlue();
        float endAlpha = colour.glAlpha();
        float endRed = colour.glRed();
        float endGreen = colour.glGreen();
        float endBlue = colour.glBlue();
        builder.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_(x1, y1, zLevel).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        builder.func_225582_a_(x3, y3, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        builder.func_225582_a_(x2, y2, zLevel).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void paintTexturedRect(MatrixStack matrix, int x, int y, double zLevel, int width, int height, int minU, int minV) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        float textureScale = 0.00390625f;
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_225582_a_((double)x, (double)(y + height), zLevel).func_225583_a_(0.00390625f * (float)minU, 0.00390625f * (float)(minV + height)).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225583_a_(0.00390625f * (float)(minU + width), 0.00390625f * (float)(minV + height)).func_181675_d();
        builder.func_225582_a_((double)(x + width), (double)y, zLevel).func_225583_a_(0.00390625f * (float)(minU + width), 0.00390625f * (float)minV).func_181675_d();
        builder.func_225582_a_((double)x, (double)y, zLevel).func_225583_a_(0.00390625f * (float)minU, 0.00390625f * (float)minV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void paint3DSunkenBox(MatrixStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paint3DGradientRect(matrix, x1 + 1, y1 + 1, x2 - 1, y2 - 1, zLevel, gradientLightColour, gradientDarkColour);
        ModRenderHelper.paintSolidRects(matrix, borderDarkColour, zLevel, x1, y1, x2, y1 + 1, x1, y1, x1 + 1, y2);
        ModRenderHelper.paintSolidRects(matrix, borderLightColour, zLevel, x1, y2 - 1, x2, y2, x2 - 1, y1, x2, y2);
    }

    public static void paint3DSunkenBox(MatrixStack matrix, int x1, int y1, int x2, int y2, double zLevel, Colour gradientLightColour, Colour borderLightColour, Colour borderDarkColour) {
        ModRenderHelper.paintSolidRect(matrix, x1 + 1, y1 + 1, x2 - 1, y2 - 1, (int)zLevel, gradientLightColour);
        ModRenderHelper.paintSolidRects(matrix, borderDarkColour, zLevel, x1, y1, x2, y1 + 1, x1, y1, x1 + 1, y2);
        ModRenderHelper.paintSolidRects(matrix, borderLightColour, zLevel, x1, y2 - 1, x2, y2, x2 - 1, y1, x2, y2);
    }

    public static void glSetColour(Colour colour) {
        RenderSystem.color4f((float)colour.glRed(), (float)colour.glGreen(), (float)colour.glBlue(), (float)colour.glAlpha());
    }

    public static void glSetViewport(int x, int y, int width, int height) {
        RenderSystem.viewport((int)x, (int)y, (int)width, (int)height);
    }

    public static void glSetViewport(double x, double y, double width, double height) {
        RenderSystem.viewport((int)MathHelper.func_76128_c((double)x), (int)MathHelper.func_76128_c((double)y), (int)MathHelper.func_76128_c((double)width), (int)MathHelper.func_76128_c((double)height));
    }

    public static void glSetDefaultViewport() {
        RenderSystem.viewport((int)0, (int)0, (int)Minecraft.func_71410_x().func_228018_at_().func_198109_k(), (int)Minecraft.func_71410_x().func_228018_at_().func_198091_l());
    }

    public static Matrix4f glPerspectiveMatrix(float fov, float aspect, float zNear, float zFar) {
        return Matrix4f.func_195876_a((double)fov, (float)aspect, (float)zNear, (float)zFar);
    }

    public static void glPerspective(float fov, float aspect, float zNear, float zFar) {
        RenderSystem.multMatrix((Matrix4f)ModRenderHelper.glPerspectiveMatrix(fov, aspect, zNear, zFar));
    }

    private ModRenderHelper() {
    }
}

