/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.jei.drawable;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.compat.jei.drawable.SpriteDrawable;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import net.minecraftforge.common.util.NonNullSupplier;

public class ProgressBarDrawable
extends SpriteDrawable {
    protected final int _areaWidth;
    protected final int _areaHeight;
    protected final Orientation _orientation;
    protected Colour _tint = Colour.WHITE;
    protected double _progress;

    public static ProgressBarDrawable empty() {
        return new ProgressBarDrawable(() -> Sprite.EMPTY, 0, Padding.ZERO, 0, 0, Orientation.BottomToTop){

            @Override
            public void draw(MatrixStack matrix, int xOffset, int yOffset) {
            }

            @Override
            public void draw(MatrixStack matrix, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
            }
        };
    }

    @Deprecated
    public static ProgressBarDrawable vertical(NonNullSupplier<ISprite> sprite, int zLevel, Padding padding, int areaWidth, int areaHeight) {
        return new ProgressBarDrawable(sprite, zLevel, padding, areaWidth, areaHeight, Orientation.BottomToTop);
    }

    @Deprecated
    public static ProgressBarDrawable flippedVertical(NonNullSupplier<ISprite> sprite, int zLevel, Padding padding, int areaWidth, int areaHeight) {
        return new ProgressBarDrawable(sprite, zLevel, padding, areaWidth, areaHeight, Orientation.TopToBottom);
    }

    public void setProgress(double progress) {
        this._progress = progress;
    }

    public void setProgress(double maxValue, double currentValue) {
        this._progress = currentValue / maxValue;
    }

    public double getProgress() {
        return this._progress;
    }

    public void setTint(Colour tint) {
        this._tint = tint;
    }

    public ProgressBarDrawable(NonNullSupplier<ISprite> sprite, int zLevel, Padding padding, int areaWidth, int areaHeight, Orientation orientation) {
        super(sprite, zLevel, padding);
        this._areaWidth = areaWidth;
        this._areaHeight = areaHeight;
        this._orientation = orientation;
        this._progress = 0.0;
    }

    @Override
    public void draw(MatrixStack matrix, int xOffset, int yOffset) {
        ModRenderHelper.paintOrientedProgressBarSprite(matrix, this._orientation, this.getSprite(), xOffset + this.getPadding().getLeft(), yOffset + this.getPadding().getTop(), this.getZLevel(), this._areaWidth, this._areaHeight, this.getProgress(), this._tint);
    }

    @Override
    public void draw(MatrixStack matrix, int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        ModRenderHelper.paintOrientedProgressBarSprite(matrix, this._orientation, this.getSprite(), xOffset + this.getPadding().getLeft() + maskLeft, yOffset + this.getPadding().getTop() + maskTop, this.getZLevel(), this._areaWidth - maskRight - maskLeft, this._areaHeight - maskBottom - maskTop, this.getProgress(), this._tint);
    }
}

