/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public final class NBTHelper {
    public static final CompoundNBT EMPTY_COMPOUND = new CompoundNBT();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<CompoundNBT> nbtFrom(File file) {
        if (!file.exists()) return Optional.empty();
        try (FileInputStream stream = new FileInputStream(file);){
            Optional<CompoundNBT> optional = Optional.of(CompressedStreamTools.func_74796_a((InputStream)stream));
            return optional;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean nbtTo(File file, CompoundNBT data) {
        try (FileOutputStream stream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((CompoundNBT)data, (OutputStream)stream);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static <E extends Enum<E>> CompoundNBT nbtSetEnum(CompoundNBT nbt, String key, E value) {
        nbt.func_74778_a(key, value.name());
        return nbt;
    }

    public static <E extends Enum<E>> E nbtGetEnum(CompoundNBT nbt, String key, Class<E> enumClass) throws IllegalArgumentException {
        return Enum.valueOf(enumClass, nbt.func_74779_i(key));
    }

    public static boolean nbtContainsEnum(CompoundNBT nbt, String key) {
        return nbt.func_150297_b(key, 8);
    }

    public static <E extends Enum<E>> E nbtGetEnum(CompoundNBT nbt, String key, Function<String, E> enumFactory, E defaultValue) {
        String value;
        if (nbt.func_74764_b(key) && !Strings.isNullOrEmpty((String)(value = nbt.func_74779_i(key)))) {
            return (E)((Enum)enumFactory.apply(nbt.func_74779_i(key)));
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> CompoundNBT nbtSetEnumSet(CompoundNBT nbt, String key, EnumSet<E> value) {
        ListNBT tagList = new ListNBT();
        for (Enum enumValue : value) {
            tagList.add((Object)NBTHelper.nbtSetEnum(new CompoundNBT(), "enum", enumValue));
        }
        nbt.func_218657_a(key, (INBT)tagList);
        return nbt;
    }

    public static boolean nbtContainsEnumSet(CompoundNBT nbt, String key) {
        return nbt.func_150297_b(key, 9);
    }

    public static <E extends Enum<E>> EnumSet<E> nbtGetEnumSet(CompoundNBT nbt, String key, Class<E> enumClass) throws IllegalArgumentException {
        ListNBT tagList = nbt.func_150295_c(key, 8);
        ArrayList valueList = Lists.newArrayList();
        for (int i = 0; i < tagList.size(); ++i) {
            E enumValue = NBTHelper.nbtGetEnum(tagList.func_150305_b(i), "enum", enumClass);
            valueList.add(enumValue);
        }
        return EnumSet.copyOf(valueList);
    }

    private NBTHelper() {
    }
}

