/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.function.ObjIntConsumer;

public interface IStackHolder<Holder extends IStackHolder<Holder, Stack>, Stack> {
    public boolean isStackValid(int var1, Stack var2);

    public boolean isEmpty(int var1);

    public Holder setOnContentsChangedListener(ObjIntConsumer<ChangeType> var1);

    public Holder setOnLoadListener(Runnable var1);

    default public void setMaxCapacity(Int2IntFunction maxCapacityProvider) {
    }

    default public void setMaxCapacity(int maxCapacity) {
        this.setMaxCapacity($ -> maxCapacity);
    }

    default public int getMaxCapacity(int index) {
        return 0;
    }

    default public int getAmount(int index) {
        return 0;
    }

    default public int getFreeSpace(int index) {
        return this.getMaxCapacity(index) - this.getAmount(index);
    }

    public static enum ChangeType {
        Added,
        Grown,
        Replaced,
        Removed,
        Shrunk;


        public boolean fullChange() {
            return this == Added || this == Replaced || this == Removed;
        }

        public boolean amountChange() {
            return this == Grown || this == Shrunk;
        }
    }
}

