/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemHelper {
    public static final String INVENTORY = "inventory";
    public static final IItemHandlerModifiable EMPTY_ITEM_HANDLER = (IItemHandlerModifiable)EmptyHandler.INSTANCE;

    public static ResourceLocation getItemId(IItemProvider item) {
        return Objects.requireNonNull(item.func_199767_j().getRegistryName());
    }

    public static ResourceLocation getItemId(ItemStack stack) {
        return Objects.requireNonNull(stack.func_77973_b().getRegistryName());
    }

    public static IFormattableTextComponent getItemName(Item item) {
        return new TranslationTextComponent(item.func_77658_a());
    }

    public static IFormattableTextComponent getItemName(ItemStack stack) {
        return new TranslationTextComponent(stack.func_77977_a());
    }

    @Nullable
    public static Item getItemFrom(String id) {
        return ItemHelper.getItemFrom(new ResourceLocation(id));
    }

    public static Item getItemFromOrAir(String id) {
        return ItemHelper.getItemFromOrAir(new ResourceLocation(id));
    }

    @Nullable
    public static Item getItemFrom(ResourceLocation id) {
        return (Item)ForgeRegistries.ITEMS.getValue(id);
    }

    public static Item getItemFromOrAir(ResourceLocation id) {
        return ForgeRegistries.ITEMS.containsKey(id) ? (Item)Objects.requireNonNull(ForgeRegistries.ITEMS.getValue(id)) : Items.field_190931_a;
    }

    public static boolean stackMatch(ItemStack stackA, ItemStack stackB, EnumSet<MatchOption> options) {
        if (stackA.func_190926_b() || stackB.func_190926_b()) {
            return false;
        }
        if (options.isEmpty()) {
            return true;
        }
        boolean result = true;
        if (options.contains((Object)MatchOption.Item)) {
            boolean bl = result = stackA.func_77973_b() == stackB.func_77973_b();
        }
        if (result && options.contains((Object)MatchOption.Size)) {
            boolean bl = result = stackA.func_190916_E() == stackB.func_190916_E();
        }
        if (result && options.contains((Object)MatchOption.Damage)) {
            boolean bl = result = stackA.func_77952_i() == stackB.func_77952_i();
        }
        if (result && options.contains((Object)MatchOption.NBT)) {
            result = ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
        }
        if (result && options.contains((Object)MatchOption.Capabilities)) {
            result = stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        if (result && options.contains((Object)MatchOption.Tags)) {
            result = ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
        }
        return result;
    }

    public static ItemStack stackFrom(IItemProvider provider) {
        return ItemHelper.stackFrom(provider, 1, null);
    }

    public static <T extends IItemProvider> ItemStack stackFrom(Supplier<T> supplier) {
        return ItemHelper.stackFrom(supplier, 1, null);
    }

    public static ItemStack stackFrom(IItemProvider provider, int amount) {
        return ItemHelper.stackFrom(provider, amount, null);
    }

    public static <T extends IItemProvider> ItemStack stackFrom(Supplier<T> supplier, int amount) {
        return ItemHelper.stackFrom(supplier, amount, null);
    }

    public static ItemStack stackFrom(IItemProvider provider, int amount, int damage) {
        ItemStack stack = ItemHelper.stackFrom(provider, amount);
        stack.func_196085_b(damage);
        return stack;
    }

    public static <T extends IItemProvider> ItemStack stackFrom(Supplier<T> supplier, int amount, int damage) {
        ItemStack stack = ItemHelper.stackFrom(supplier, amount);
        if (!stack.func_190926_b()) {
            stack.func_196085_b(damage);
        }
        return stack;
    }

    public static ItemStack stackFrom(IItemProvider provider, int amount, @Nullable CompoundNBT nbt) {
        return new ItemStack(provider, amount, nbt);
    }

    public static <T extends IItemProvider> ItemStack stackFrom(Supplier<T> supplier, int amount, @Nullable CompoundNBT nbt) {
        IItemProvider provider = (IItemProvider)supplier.get();
        return null != provider ? new ItemStack(provider, amount, nbt) : ItemHelper.stackEmpty();
    }

    public static ItemStack stackFrom(BlockState state, int amount) {
        return ItemHelper.stackFrom((IItemProvider)state.func_177230_c(), amount, null);
    }

    public static ItemStack stackFrom(CompoundNBT nbt) {
        return ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    public static CompoundNBT stackToNBT(ItemStack stack) {
        return stack.func_77955_b(new CompoundNBT());
    }

    public static ItemStack stackFrom(JsonElement json) {
        JsonObject o = json.getAsJsonObject();
        Item item = JSONHelper.jsonGetItem(o, "item");
        int count = JSONHelper.jsonGetInt(o, "count", 1);
        if (o.has("nbt")) {
            return ItemHelper.stackFrom((IItemProvider)item, count, JSONHelper.jsonGetNBT(o, "nbt"));
        }
        return ItemHelper.stackFrom((IItemProvider)item, count);
    }

    public static JsonElement stackToJSON(ItemStack stack) {
        JsonObject json = new JsonObject();
        int count = stack.func_190916_E();
        JSONHelper.jsonSetItem(json, "item", (IItemProvider)stack.func_77973_b());
        if (count > 1) {
            JSONHelper.jsonSetInt(json, "count", count);
        }
        if (stack.func_77942_o()) {
            JSONHelper.jsonSetNBT(json, "nbt", Objects.requireNonNull(stack.func_77978_p()));
        }
        return json;
    }

    public static ItemStack stackFrom(ItemStack stack) {
        return stack.func_77946_l();
    }

    public static ItemStack stackFrom(ItemStack stack, int amount) {
        ItemStack newStack = ItemHelper.stackFrom(stack);
        if (newStack.func_190926_b()) {
            return ItemHelper.stackEmpty();
        }
        ItemHelper.stackSetSize(newStack, amount);
        return newStack;
    }

    public static ItemStack stackSetSize(ItemStack stack, int amount) {
        stack.func_190920_e(Math.max(amount, 0));
        return stack;
    }

    public static ItemStack stackEmpty(ItemStack stack) {
        stack.func_190920_e(0);
        return stack;
    }

    @Deprecated
    public static ItemStack stackEmpty() {
        return ItemStack.field_190927_a;
    }

    public static Optional<CompoundNBT> stackGetTag(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p());
    }

    public static boolean stackHasData(ItemStack stack, String key) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"'key' must not be empty");
        return ItemHelper.stackGetTag(stack).map(tag -> tag.func_74764_b(key)).orElse(false);
    }

    public static Optional<INBT> stackGetData(ItemStack stack, String key) {
        return ItemHelper.stackGetTag(stack).map(tag -> tag.func_74781_a(key));
    }

    public static void stackSetData(ItemStack stack, String key, INBT value) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"'key' must not be empty");
        CodeHelper.optionalIfPresentOrElse(ItemHelper.stackGetTag(stack), tag -> tag.func_218657_a(key, value), () -> {
            CompoundNBT newTag = new CompoundNBT();
            newTag.func_218657_a(key, value);
            stack.func_77982_d(newTag);
        });
    }

    public static ItemStack removeStackFromSlot(IItemHandlerModifiable inventory, int slot) {
        ItemStack stack = inventory.getStackInSlot(slot);
        inventory.setStackInSlot(slot, ItemHelper.stackEmpty());
        return stack;
    }

    public static void inventoryDropItems(IItemHandlerModifiable inventory, World world, BlockPos position) {
        double x = position.func_177958_n();
        double y = position.func_177956_o();
        double z = position.func_177952_p();
        IntStream.range(0, inventory.getSlots()).mapToObj(slot -> ItemHelper.removeStackFromSlot(inventory, slot)).filter(stack -> !stack.func_190926_b()).forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)stack));
    }

    private ItemHelper() {
    }

    public static enum MatchOption {
        Item,
        Size,
        Damage,
        NBT,
        Capabilities,
        Tags;

        public static final EnumSet<MatchOption> MATCH_ALWAYS;
        public static final EnumSet<MatchOption> MATCH_ALL;
        public static final EnumSet<MatchOption> MATCH_ITEM;
        public static final EnumSet<MatchOption> MATCH_ITEM_SIZE;
        public static final EnumSet<MatchOption> MATCH_ITEM_NBT;
        public static final EnumSet<MatchOption> MATCH_ITEM_DAMAGE;
        public static final EnumSet<MatchOption> MATCH_ITEM_DAMAGE_NBT;
        public static final EnumSet<MatchOption> MATCH_EXISTING_STACK;

        static {
            MATCH_ALWAYS = EnumSet.noneOf(MatchOption.class);
            MATCH_ALL = EnumSet.of(Item, new MatchOption[]{Size, Damage, NBT, Capabilities, Tags});
            MATCH_ITEM = EnumSet.of(Item);
            MATCH_ITEM_SIZE = EnumSet.of(Item, Size);
            MATCH_ITEM_NBT = EnumSet.of(Item, NBT);
            MATCH_ITEM_DAMAGE = EnumSet.of(Item, Damage);
            MATCH_ITEM_DAMAGE_NBT = EnumSet.of(Item, Damage, NBT);
            MATCH_EXISTING_STACK = EnumSet.of(Item, Damage, NBT, Capabilities, Tags);
        }
    }
}

