/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container;

import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ModTileContainer<T extends AbstractModBlockEntity>
extends ModContainer {
    private final T _tile;

    public ModTileContainer(ContainerFactory factory, ContainerType<? extends ModTileContainer<T>> type, int windowId, T tile) {
        super(factory, type, windowId);
        this._tile = tile;
        if (tile instanceof IConditionallySyncableEntity) {
            this.syncFrom((IConditionallySyncableEntity)tile);
        }
    }

    public ModTileContainer(ContainerFactory factory, ContainerType<? extends ModTileContainer<T>> type, int windowId, T tile, ServerPlayerEntity player) {
        this(factory, type, windowId, tile);
        if (this._tile instanceof INetworkTileEntitySyncProvider) {
            ((INetworkTileEntitySyncProvider)this._tile).enlistForUpdates(player, true);
        }
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(ContainerType<? extends ModTileContainer<T>> type, int windowId, T tile) {
        return new ModTileContainer<T>(ContainerFactory.EMPTY, type, windowId, tile){

            public void func_75141_a(int slotID, ItemStack stack) {
            }
        };
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(ContainerType<? extends ModTileContainer<T>> type, int windowId, T tile, ServerPlayerEntity player) {
        return new ModTileContainer<T>(ContainerFactory.EMPTY, type, windowId, tile, player){

            public void func_75141_a(int slotID, ItemStack stack) {
            }
        };
    }

    public static <T extends AbstractModBlockEntity> ModTileContainer<T> empty(ContainerType<? extends ModTileContainer<T>> type, int windowId, PacketBuffer data) {
        return ModTileContainer.empty(type, windowId, AbstractModBlockEntity.getGuiClientBlockEntity(data));
    }

    public T getTileEntity() {
        return this._tile;
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        return ModTileContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)Objects.requireNonNull(this._tile.func_145831_w()), (BlockPos)this._tile.func_174877_v()), (PlayerEntity)player, (Block)((AbstractModBlockEntity)this._tile).getBlockType());
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        if (this._tile instanceof INetworkTileEntitySyncProvider && player instanceof ServerPlayerEntity) {
            ((INetworkTileEntitySyncProvider)this._tile).delistFromUpdates((ServerPlayerEntity)player);
        }
    }
}

