/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.filter;

import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.filter.FilterBehavior;
import it.zerono.mods.zerocore.lib.item.inventory.filter.FilterManager;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilter;
import it.zerono.mods.zerocore.lib.item.inventory.filter.IFilterCondition;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public abstract class Filter
implements IFilter {
    private final Map<String, IFilterCondition> _conditions = Maps.newHashMap();
    private FilterBehavior _behavior = FilterBehavior.BlackList;
    private EnumSet<ItemHelper.MatchOption> _matchOptions = ItemHelper.MatchOption.MATCH_ALWAYS;
    private static final String NBT_BEHAVIOR_KEY = "Behavior";
    private static final String NBT_OPTIONS_KEY = "Options";
    private static final String NBT_CONDITIONS_KEY = "Conditions";

    @Override
    public boolean canAccept(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (IFilterCondition condition : this._conditions.values()) {
            if (!condition.match(stack, this.getMatchOptions())) continue;
            return FilterBehavior.WhiteList == this.getBehavior();
        }
        return FilterBehavior.BlackList == this.getBehavior();
    }

    @Override
    public Optional<IFilterCondition> getCondition(String name) {
        return Optional.ofNullable(this._conditions.get(name));
    }

    @Override
    public void addCondition(String name, IFilterCondition condition) {
        this._conditions.put(name, condition);
    }

    @Override
    public void removeCondition(String name) {
        this._conditions.remove(name);
    }

    @Override
    public FilterBehavior getBehavior() {
        return this._behavior;
    }

    @Override
    public void setBehavior(FilterBehavior behavior) {
        this._behavior = behavior;
    }

    @Override
    public EnumSet<ItemHelper.MatchOption> getMatchOptions() {
        return this._matchOptions;
    }

    @Override
    public void setMatchOptions(EnumSet<ItemHelper.MatchOption> options) {
        this._matchOptions = options;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT conditionsList = new ListNBT();
        this._conditions.forEach((name, condition) -> {
            CompoundNBT nameTag = new CompoundNBT();
            nameTag.func_74778_a("name", name);
            conditionsList.add((Object)nameTag);
            conditionsList.add((Object)FilterManager.getInstance().storeComponentToNBT((IFilterCondition)condition));
        });
        nbt.func_218657_a(NBT_CONDITIONS_KEY, (INBT)conditionsList);
        NBTHelper.nbtSetEnum(nbt, NBT_BEHAVIOR_KEY, this._behavior);
        NBTHelper.nbtSetEnumSet(nbt, NBT_OPTIONS_KEY, this._matchOptions);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b(NBT_CONDITIONS_KEY)) {
            ListNBT conditionsList = nbt.func_150295_c(NBT_CONDITIONS_KEY, 10);
            this._conditions.clear();
            for (int i = 0; i < conditionsList.size(); i += 2) {
                CompoundNBT nameTag = conditionsList.func_150305_b(i);
                if (!nameTag.func_74764_b("name") || i + 1 >= conditionsList.size()) continue;
                Optional<IFilterCondition> condition = FilterManager.getInstance().loadComponentFromNBT(conditionsList.func_150305_b(i + 1));
                condition.ifPresent(c -> this._conditions.put(nameTag.func_74779_i("name"), (IFilterCondition)c));
            }
        }
        if (nbt.func_74764_b(NBT_BEHAVIOR_KEY)) {
            this._behavior = NBTHelper.nbtGetEnum(nbt, NBT_BEHAVIOR_KEY, FilterBehavior.class);
        }
        if (nbt.func_74764_b(NBT_OPTIONS_KEY)) {
            this._matchOptions = NBTHelper.nbtGetEnumSet(nbt, NBT_OPTIONS_KEY, ItemHelper.MatchOption.class);
        }
    }
}

