/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.tag;

import com.google.common.collect.Iterables;
import it.zerono.mods.zerocore.lib.tag.CollectionProviders;
import it.zerono.mods.zerocore.lib.tag.TagSource;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class TagsHelper<T>
extends TagSource<T> {
    public static final TagsHelper<Block> BLOCKS = new TagsHelper<Block>(CollectionProviders.BLOCKS_PROVIDER, id -> ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)id), rl -> ForgeTagHandler.createOptionalTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)rl));
    public static final TagsHelper<Item> ITEMS = new TagsHelper<Item>(CollectionProviders.ITEMS_PROVIDER, id -> ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)id), rl -> ForgeTagHandler.createOptionalTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)rl));
    public static final TagsHelper<Fluid> FLUIDS = new TagsHelper<Fluid>(CollectionProviders.FLUIDS_PROVIDER, id -> ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)id), rl -> ForgeTagHandler.createOptionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)rl));
    public static final ITag.INamedTag<Item> TAG_WRENCH = ITEMS.createForgeOptionalTag("tools/wrench");
    private final NonNullFunction<ResourceLocation, ITag.INamedTag<T>> _factory;
    private final NonNullFunction<ResourceLocation, Tags.IOptionalNamedTag<T>> _optionalFactory;

    public static <T> T getTagFirstElement(ITag<T> tag) {
        return (T)Iterables.get((Iterable)tag.func_230236_b_(), (int)0);
    }

    public ITag.INamedTag<T> createTag(ResourceLocation tagId) {
        return (ITag.INamedTag)this._factory.apply((Object)tagId);
    }

    public Tags.IOptionalNamedTag<T> createOptionalTag(ResourceLocation tagId) {
        return (Tags.IOptionalNamedTag)this._optionalFactory.apply((Object)tagId);
    }

    public ITag.INamedTag<T> createTag(String tagId) {
        return this.createTag(new ResourceLocation(tagId));
    }

    public Tags.IOptionalNamedTag<T> createOptionalTag(String tagId) {
        return this.createOptionalTag(new ResourceLocation(tagId));
    }

    public ITag.INamedTag<T> createModTag(String modId, String tagName) {
        return this.createTag(new ResourceLocation(modId, tagName));
    }

    public Tags.IOptionalNamedTag<T> createModOptionalTag(String modId, String tagName) {
        return this.createOptionalTag(new ResourceLocation(modId, tagName));
    }

    public ITag.INamedTag<T> createForgeTag(String tagName) {
        return this.createTag(new ResourceLocation("forge", tagName));
    }

    public Tags.IOptionalNamedTag<T> createForgeOptionalTag(String tagName) {
        return this.createOptionalTag(new ResourceLocation("forge", tagName));
    }

    public boolean tagExist(ResourceLocation tagId) {
        return this.getTag(tagId).isPresent();
    }

    public boolean tagExistWithContent(ResourceLocation tagId) {
        return this.getTag(tagId).filter(tag -> tag.func_230236_b_().size() > 0).isPresent();
    }

    public Optional<T> getFirstElement(ITag<T> tag) {
        return tag.func_230236_b_().isEmpty() ? Optional.empty() : Optional.of(TagsHelper.getTagFirstElement(tag));
    }

    public Optional<T> getFirstElement(ResourceLocation tagId) {
        return this.getTag(tagId).filter(tag -> !tag.func_230236_b_().isEmpty()).map(TagsHelper::getTagFirstElement);
    }

    public List<T> getMatchingElements(ITag<T> tag) {
        try {
            return tag.func_230236_b_();
        }
        catch (IllegalStateException e) {
            return Collections.emptyList();
        }
    }

    private TagsHelper(NonNullSupplier<ITagCollection<T>> provider, NonNullFunction<ResourceLocation, ITag.INamedTag<T>> factory, NonNullFunction<ResourceLocation, Tags.IOptionalNamedTag<T>> optionalFactory) {
        super(provider);
        this._factory = factory;
        this._optionalFactory = optionalFactory;
    }
}

