/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientEventHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.DynamicModelLoader;
import blusunrize.immersiveengineering.client.IEDefaultColourHandlers;
import blusunrize.immersiveengineering.client.IEManual;
import blusunrize.immersiveengineering.client.ItemKeybindConflictContext;
import blusunrize.immersiveengineering.client.ShaderHelper;
import blusunrize.immersiveengineering.client.fx.FluidSplashParticle;
import blusunrize.immersiveengineering.client.fx.FractalParticle;
import blusunrize.immersiveengineering.client.fx.IEParticles;
import blusunrize.immersiveengineering.client.gui.AlloySmelterScreen;
import blusunrize.immersiveengineering.client.gui.ArcFurnaceScreen;
import blusunrize.immersiveengineering.client.gui.AssemblerScreen;
import blusunrize.immersiveengineering.client.gui.AutoWorkbenchScreen;
import blusunrize.immersiveengineering.client.gui.BlastFurnaceScreen;
import blusunrize.immersiveengineering.client.gui.ChemTurretScreen;
import blusunrize.immersiveengineering.client.gui.CircuitTableScreen;
import blusunrize.immersiveengineering.client.gui.ClocheScreen;
import blusunrize.immersiveengineering.client.gui.CokeOvenScreen;
import blusunrize.immersiveengineering.client.gui.CraftingTableScreen;
import blusunrize.immersiveengineering.client.gui.CrateScreen;
import blusunrize.immersiveengineering.client.gui.FermenterScreen;
import blusunrize.immersiveengineering.client.gui.FluidSorterScreen;
import blusunrize.immersiveengineering.client.gui.GunTurretScreen;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.ItemBatcherScreen;
import blusunrize.immersiveengineering.client.gui.LogicUnitScreen;
import blusunrize.immersiveengineering.client.gui.MaintenanceKitScreen;
import blusunrize.immersiveengineering.client.gui.MixerScreen;
import blusunrize.immersiveengineering.client.gui.ModWorkbenchScreen;
import blusunrize.immersiveengineering.client.gui.RedstoneConnectorScreen;
import blusunrize.immersiveengineering.client.gui.RedstoneProbeScreen;
import blusunrize.immersiveengineering.client.gui.RefineryScreen;
import blusunrize.immersiveengineering.client.gui.RevolverScreen;
import blusunrize.immersiveengineering.client.gui.SorterScreen;
import blusunrize.immersiveengineering.client.gui.SqueezerScreen;
import blusunrize.immersiveengineering.client.gui.ToolboxBlockScreen;
import blusunrize.immersiveengineering.client.gui.ToolboxScreen;
import blusunrize.immersiveengineering.client.manual.ManualElementBlueprint;
import blusunrize.immersiveengineering.client.manual.ManualElementMultiblock;
import blusunrize.immersiveengineering.client.models.ModelConfigurableSides;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.client.models.ModelCoresample;
import blusunrize.immersiveengineering.client.models.ModelItemDynamicOverride;
import blusunrize.immersiveengineering.client.models.ModelPowerpack;
import blusunrize.immersiveengineering.client.models.PotionBucketModel;
import blusunrize.immersiveengineering.client.models.connection.BakedConnectionModel;
import blusunrize.immersiveengineering.client.models.connection.ConnectionLoader;
import blusunrize.immersiveengineering.client.models.connection.FeedthroughLoader;
import blusunrize.immersiveengineering.client.models.connection.FeedthroughModel;
import blusunrize.immersiveengineering.client.models.multilayer.MultiLayerLoader;
import blusunrize.immersiveengineering.client.models.obj.IEOBJLoader;
import blusunrize.immersiveengineering.client.models.obj.IESmartObjModel;
import blusunrize.immersiveengineering.client.models.split.SplitModelLoader;
import blusunrize.immersiveengineering.client.render.IEBipedLayerRenderer;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.client.render.entity.ChemthrowerShotRenderer;
import blusunrize.immersiveengineering.client.render.entity.FluorescentTubeRenderer;
import blusunrize.immersiveengineering.client.render.entity.IEExplosiveRenderer;
import blusunrize.immersiveengineering.client.render.entity.IEMinecartRenderer;
import blusunrize.immersiveengineering.client.render.entity.NoneRenderer;
import blusunrize.immersiveengineering.client.render.entity.RailgunShotRenderer;
import blusunrize.immersiveengineering.client.render.entity.RevolvershotRenderer;
import blusunrize.immersiveengineering.client.render.entity.SawbladeRenderer;
import blusunrize.immersiveengineering.client.render.entity.ShaderMinecartRenderer;
import blusunrize.immersiveengineering.client.render.tile.ArcFurnaceRenderer;
import blusunrize.immersiveengineering.client.render.tile.AutoWorkbenchRenderer;
import blusunrize.immersiveengineering.client.render.tile.BlastFurnacePreheaterRenderer;
import blusunrize.immersiveengineering.client.render.tile.BottlingMachineRenderer;
import blusunrize.immersiveengineering.client.render.tile.BucketWheelRenderer;
import blusunrize.immersiveengineering.client.render.tile.ChargingStationRenderer;
import blusunrize.immersiveengineering.client.render.tile.ClocheRenderer;
import blusunrize.immersiveengineering.client.render.tile.CoresampleRenderer;
import blusunrize.immersiveengineering.client.render.tile.CrusherRenderer;
import blusunrize.immersiveengineering.client.render.tile.DieselGeneratorRenderer;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.MetalPressRenderer;
import blusunrize.immersiveengineering.client.render.tile.MixerRenderer;
import blusunrize.immersiveengineering.client.render.tile.ModWorkbenchRenderer;
import blusunrize.immersiveengineering.client.render.tile.SampleDrillRenderer;
import blusunrize.immersiveengineering.client.render.tile.SawmillRenderer;
import blusunrize.immersiveengineering.client.render.tile.ShaderBannerRenderer;
import blusunrize.immersiveengineering.client.render.tile.SheetmetalTankRenderer;
import blusunrize.immersiveengineering.client.render.tile.SiloRenderer;
import blusunrize.immersiveengineering.client.render.tile.SqueezerRenderer;
import blusunrize.immersiveengineering.client.render.tile.TeslaCoilRenderer;
import blusunrize.immersiveengineering.client.render.tile.TurretRenderer;
import blusunrize.immersiveengineering.client.render.tile.WatermillRenderer;
import blusunrize.immersiveengineering.client.render.tile.WindmillRenderer;
import blusunrize.immersiveengineering.client.utils.VertexBufferHolder;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorProbeTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TeslaCoilTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.BasicConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.DropConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.RedstoneConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.SplitConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.VerticalConveyor;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.crafting.RecipeReloadListener;
import blusunrize.immersiveengineering.common.entities.BarrelMinecartEntity;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.entities.CrateMinecartEntity;
import blusunrize.immersiveengineering.common.entities.FluorescentTubeEntity;
import blusunrize.immersiveengineering.common.entities.IEExplosiveEntity;
import blusunrize.immersiveengineering.common.entities.MetalBarrelMinecartEntity;
import blusunrize.immersiveengineering.common.entities.RailgunShotEntity;
import blusunrize.immersiveengineering.common.entities.ReinforcedCrateMinecartEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotFlareEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotHomingEntity;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.entities.WolfpackShotEntity;
import blusunrize.immersiveengineering.common.gui.GuiHandler;
import blusunrize.immersiveengineering.common.items.DrillheadItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.RockcutterItem;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.sound.IETickableSound;
import blusunrize.immersiveengineering.common.util.sound.IETileSound;
import blusunrize.immersiveengineering.common.util.sound.SkyhookSound;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.BreakingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy
extends CommonProxy {
    public static KeyBinding keybind_magnetEquip = new KeyBinding("key.immersiveengineering.magnetEquip", 83, "key.categories.immersiveengineering");
    public static KeyBinding keybind_chemthrowerSwitch = new KeyBinding("key.immersiveengineering.chemthrowerSwitch", -1, "key.categories.immersiveengineering");
    public static KeyBinding keybind_railgunZoom = new KeyBinding("key.immersiveengineering.railgunZoom", InputMappings.Type.MOUSE, 2, "key.categories.immersiveengineering");
    public static boolean stencilEnabled = false;
    HashMap<String, IETickableSound> tickableSoundMap = new HashMap();
    HashMap<BlockPos, IETileSound> tileSoundMap = new HashMap();

    @Override
    public void modConstruction() {
        super.modConstruction();
        if (Minecraft.func_71410_x() != null) {
            ClientProxy.populateAPI();
            ClientProxy.requestModelsAndTextures();
        }
    }

    @SubscribeEvent
    public static void registerModelLoaders(ModelRegistryEvent ev) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)IEOBJLoader.LOADER_NAME, (IModelLoader)IEOBJLoader.instance);
        ModelLoaderRegistry.registerLoader((ResourceLocation)ConnectionLoader.LOADER_NAME, (IModelLoader)new ConnectionLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)ModelConfigurableSides.Loader.NAME, (IModelLoader)new ModelConfigurableSides.Loader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)ModelConveyor.ConveyorLoader.LOCATION, (IModelLoader)new ModelConveyor.ConveyorLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)ModelCoresample.CoresampleLoader.LOCATION, (IModelLoader)new ModelCoresample.CoresampleLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)MultiLayerLoader.LOCATION, (IModelLoader)new MultiLayerLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)FeedthroughLoader.LOCATION, (IModelLoader)new FeedthroughLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)SplitModelLoader.LOCATION, (IModelLoader)new SplitModelLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)PotionBucketModel.Loader.LOADER_NAME, (IModelLoader)new PotionBucketModel.Loader());
    }

    @Override
    public void preInit(ParallelDispatchEvent ev) {
        if (((Boolean)IEClientConfig.stencilBufferEnabled.get()).booleanValue()) {
            ev.enqueueWork(() -> {
                Minecraft.func_71410_x().func_147110_a().enableStencil();
                stencilEnabled = true;
            });
        }
        RenderingRegistry.registerEntityRenderingHandler(RevolvershotEntity.TYPE, RevolvershotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RevolvershotFlareEntity.TYPE, RevolvershotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RevolvershotHomingEntity.TYPE, RevolvershotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(WolfpackShotEntity.TYPE, RevolvershotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SkylineHookEntity.TYPE, NoneRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ChemthrowerShotEntity.TYPE, ChemthrowerShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(RailgunShotEntity.TYPE, RailgunShotRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(IEExplosiveEntity.TYPE, IEExplosiveRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(FluorescentTubeEntity.TYPE, FluorescentTubeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(BarrelMinecartEntity.TYPE, IEMinecartRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(CrateMinecartEntity.TYPE, IEMinecartRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ReinforcedCrateMinecartEntity.TYPE, IEMinecartRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(MetalBarrelMinecartEntity.TYPE, IEMinecartRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SawbladeEntity.TYPE, SawbladeRenderer::new);
    }

    @Override
    public void preInitEnd() {
        for (IECompatModule compat : IECompatModule.modules) {
            try {
                compat.clientPreInit();
            }
            catch (Exception exception) {
                IELogger.error("Compat module for " + compat + " could not be client pre-initialized");
            }
        }
    }

    @Override
    public void init() {
        super.init();
        ClientEventHandler handler = new ClientEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        ((IReloadableResourceManager)ClientUtils.mc().func_195551_G()).func_219534_a((IFutureReloadListener)handler);
        MinecraftForge.EVENT_BUS.register((Object)new RecipeReloadListener(null));
        IKeyConflictContext noKeyConflict = new IKeyConflictContext(){

            public boolean isActive() {
                return ClientUtils.mc().field_71462_r == null;
            }

            public boolean conflicts(IKeyConflictContext other) {
                return false;
            }
        };
        keybind_magnetEquip.setKeyConflictContext(noKeyConflict);
        ClientRegistry.registerKeyBinding((KeyBinding)keybind_magnetEquip);
        keybind_railgunZoom.setKeyConflictContext((IKeyConflictContext)new ItemKeybindConflictContext((stack, player) -> stack.func_77973_b() instanceof ZoomHandler.IZoomTool && ((ZoomHandler.IZoomTool)stack.func_77973_b()).canZoom((ItemStack)stack, (PlayerEntity)player)));
        ClientRegistry.registerKeyBinding((KeyBinding)keybind_railgunZoom);
        keybind_chemthrowerSwitch.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientRegistry.registerKeyBinding((KeyBinding)keybind_chemthrowerSwitch);
        ShaderHelper.initShaders();
        TeslaCoilTileEntity.effectMap = ArrayListMultimap.create();
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.CHARGING_STATION.get()), ChargingStationRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.SAMPLE_DRILL.get()), SampleDrillRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.TESLACOIL.get()), TeslaCoilRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.TURRET_CHEM.get()), TurretRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.TURRET_GUN.get()), TurretRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.CLOCHE.get()), ClocheRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.BLASTFURNACE_PREHEATER.get()), BlastFurnacePreheaterRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.METAL_PRESS.get()), MetalPressRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.CRUSHER.get()), CrusherRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.SAWMILL.get()), SawmillRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.SHEETMETAL_TANK.get()), SheetmetalTankRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.SILO.get()), SiloRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.SQUEEZER.get()), SqueezerRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.DIESEL_GENERATOR.get()), DieselGeneratorRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.BUCKET_WHEEL.get()), BucketWheelRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.ARC_FURNACE.get()), ArcFurnaceRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.AUTO_WORKBENCH.get()), AutoWorkbenchRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.BOTTLING_MACHINE.get()), BottlingMachineRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.MIXER.get()), MixerRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.WATERMILL.get()), WatermillRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.WINDMILL.get()), WindmillRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.MOD_WORKBENCH.get()), ModWorkbenchRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.CORE_SAMPLE.get()), CoresampleRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)IETileTypes.SHADER_BANNER.get()), ShaderBannerRenderer::new);
        for (Item item : IEContent.registeredIEItems) {
            if (!(item instanceof IEItemInterfaces.IColouredItem) || !((IEItemInterfaces.IColouredItem)item).hasCustomItemColours()) continue;
            ClientUtils.mc().getItemColors().func_199877_a((IItemColor)IEDefaultColourHandlers.INSTANCE, new IItemProvider[]{item});
        }
        for (Block block : IEContent.registeredIEBlocks) {
            if (!(block instanceof IEBlockInterfaces.IColouredBlock) || !((IEBlockInterfaces.IColouredBlock)block).hasCustomBlockColours()) continue;
            ClientUtils.mc().func_184125_al().func_186722_a((IBlockColor)IEDefaultColourHandlers.INSTANCE, new Block[]{block});
        }
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        PlayerRenderer render = (PlayerRenderer)skinMap.get("default");
        render.func_177094_a(new IEBipedLayerRenderer(render));
        render = (PlayerRenderer)skinMap.get("slim");
        render.func_177094_a(new IEBipedLayerRenderer(render));
    }

    @Override
    public void initEnd() {
        for (IECompatModule compat : IECompatModule.modules) {
            try {
                compat.clientInit();
            }
            catch (Exception exception) {
                IELogger.error("Compat module for " + compat + " could not be client pre-initialized");
            }
        }
    }

    @Override
    public void postInit() {
        IEManual.addIEManualEntries();
    }

    @Override
    public void postInitEnd() {
        for (IECompatModule compat : IECompatModule.modules) {
            try {
                compat.clientPostInit();
            }
            catch (Exception exception) {
                IELogger.error("Compat module for " + compat + " could not be client pre-initialized");
            }
        }
    }

    @Override
    public void serverStarting() {
    }

    @SubscribeEvent
    public static void textureStichPre(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        IELogger.info("Stitching Revolver Textures!");
        RevolverItem.addRevolverTextures(event);
        for (ShaderRegistry.ShaderRegistryEntry entry : ShaderRegistry.shaderRegistry.values()) {
            for (ShaderCase sCase : entry.getCases()) {
                if (!sCase.stitchIntoSheet()) continue;
                for (ShaderLayer layer : sCase.getLayers()) {
                    if (layer.getTexture() == null) continue;
                    event.addSprite(layer.getTexture());
                }
            }
        }
    }

    @SubscribeEvent
    public static void textureStichPost(TextureStitchEvent.Post event) {
        if (!event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        ImmersiveEngineering.proxy.clearRenderCaches();
        RevolverItem.retrieveRevolverTextures(event.getMap());
        for (DrillheadItem.DrillHeadPerm p : DrillheadItem.DrillHeadPerm.ALL_PERMS) {
            p.sprite = event.getMap().func_195424_a(p.texture);
            Preconditions.checkNotNull((Object)p.sprite);
        }
        WireType.iconDefaultWire = event.getMap().func_195424_a(new ResourceLocation("immersiveengineering", "block/wire"));
    }

    public void registerItemModel(Item item, String path, String renderCase) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_199311_a(item, new ModelResourceLocation(path, renderCase));
    }

    public static String getPropertyString(Map<Property, Comparable> propertyMap) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<Property, Comparable> entry : propertyMap.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            Property iproperty = entry.getKey();
            Comparable comparable = entry.getValue();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(iproperty.func_177702_a(comparable));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    @Override
    public boolean isSoundPlaying(String key) {
        return this.tickableSoundMap.containsKey(key);
    }

    @Override
    public void playTickableSound(SoundEvent soundEvent, SoundCategory category, String key, float volume, float pitch, Supplier<Boolean> tickFunction) {
        IETickableSound sound = new IETickableSound(soundEvent, category, volume, pitch, tickFunction, ieTickableSound -> this.tickableSoundMap.remove(key));
        ClientUtils.mc().func_147118_V().func_147682_a((ISound)sound);
        this.tickableSoundMap.put(key, sound);
    }

    @Override
    public void handleTileSound(SoundEvent soundEvent, TileEntity tile, boolean tileActive, float volume, float pitch) {
        BlockPos pos = tile.func_174877_v();
        IETileSound sound = this.tileSoundMap.get(pos);
        if (sound == null && tileActive) {
            if (tile instanceof IEBlockInterfaces.ISoundTile && ClientUtils.mc().field_71439_g.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)((IEBlockInterfaces.ISoundTile)tile).getSoundRadiusSq()) {
                return;
            }
            sound = ClientUtils.generatePositionedIESound(soundEvent, volume, pitch, true, 0, pos);
            this.tileSoundMap.put(pos, sound);
        } else if (sound != null && (sound.donePlaying || !tileActive)) {
            sound.donePlaying = true;
            ClientUtils.mc().func_147118_V().func_147683_b((ISound)sound);
            this.tileSoundMap.remove(pos);
        }
    }

    @Override
    public void stopTileSound(String soundName, TileEntity tile) {
        IETileSound sound = this.tileSoundMap.get(tile.func_174877_v());
        if (sound != null) {
            ClientUtils.mc().func_147118_V().func_147683_b((ISound)sound);
        }
    }

    @Override
    public void onWorldLoad() {
        if (!ShaderMinecartRenderer.rendersReplaced) {
            EntityRendererManager rendererManager = ClientUtils.mc().func_175598_ae();
            for (EntityType type : rendererManager.field_78729_o.keySet()) {
                ShaderMinecartRenderer.overrideModelIfMinecart(type);
            }
            ShaderMinecartRenderer.rendersReplaced = true;
        }
        if (!IEBipedLayerRenderer.rendersAssigned) {
            for (Object render : ClientUtils.mc().func_175598_ae().field_78729_o.values()) {
                if (BipedRenderer.class.isAssignableFrom(render.getClass())) {
                    ((BipedRenderer)render).func_177094_a(new IEBipedLayerRenderer((BipedRenderer)render));
                    continue;
                }
                if (!ArmorStandRenderer.class.isAssignableFrom(render.getClass())) continue;
                ((ArmorStandRenderer)render).func_177094_a(new IEBipedLayerRenderer((ArmorStandRenderer)render));
            }
            IEBipedLayerRenderer.rendersAssigned = true;
        }
    }

    @Override
    public void spawnBucketWheelFX(BucketWheelTileEntity tile, ItemStack stack) {
        if (stack != null && ((Boolean)IEServerConfig.MACHINES.excavator_particles.get()).booleanValue()) {
            Direction facing = tile.getFacing();
            int sign = tile.getIsMirrored() ^ facing.func_176743_c() == Direction.AxisDirection.NEGATIVE ? 1 : -1;
            double x = (double)tile.func_174877_v().func_177958_n() + 0.5;
            double y = (double)tile.func_174877_v().func_177956_o() + 2.5;
            double z = (double)tile.func_174877_v().func_177952_p() + 0.5;
            double fixPosOffset = 0.5 * (double)sign;
            double fixVelOffset = 0.075 * (double)sign;
            for (int i = 0; i < 16; ++i) {
                double mX = (tile.getWorldNonnull().field_73012_v.nextDouble() - 0.5) * 0.01;
                double mY = tile.func_145831_w().field_73012_v.nextDouble() * -0.05;
                double mZ = (tile.getWorldNonnull().field_73012_v.nextDouble() - 0.5) * 0.01;
                double rndPosOffset = 0.2 * (tile.getWorldNonnull().field_73012_v.nextDouble() - 0.5);
                Particle particle = facing.func_176740_k() == Direction.Axis.X ? new BreakingParticle.Factory().func_199234_a(new ItemParticleData(ParticleTypes.field_197591_B, stack), (ClientWorld)tile.getWorldNonnull(), x + fixPosOffset, y, z + rndPosOffset, mX + fixVelOffset, mY, mZ) : new BreakingParticle.Factory().func_199234_a(new ItemParticleData(ParticleTypes.field_197591_B, stack), (ClientWorld)tile.getWorldNonnull(), x + rndPosOffset, y, z + fixPosOffset, mX, mY, mZ + fixVelOffset);
                ClientUtils.mc().field_71452_i.func_78873_a(particle);
            }
        }
    }

    @Override
    public void spawnRedstoneFX(World world, double x, double y, double z, double mx, double my, double mz, float size, float r, float g, float b) {
        world.func_195594_a((IParticleData)new RedstoneParticleData(r, g, b, size), x, y, z, mx, my, mz);
    }

    @Override
    public void spawnFluidSplashFX(World world, FluidStack fs, double x, double y, double z, double mx, double my, double mz) {
        world.func_195594_a((IParticleData)new FluidSplashParticle.Data(fs.getFluid()), x, y, z, mx, my, mz);
    }

    @Override
    public void spawnBubbleFX(World world, FluidStack fs, double x, double y, double z, double mx, double my, double mz) {
        world.func_195594_a((IParticleData)IEParticles.IE_BUBBLE, x, y, z, mx, my, mz);
    }

    @Override
    public void spawnFractalFX(World world, double x, double y, double z, Vector3d direction, double scale, int prefixColour, float[][] colour) {
        if (prefixColour >= 0) {
            colour = prefixColour == 1 ? FractalParticle.COLOUR_ORANGE : (prefixColour == 2 ? FractalParticle.COLOUR_RED : FractalParticle.COLOUR_LIGHTNING);
        }
        FractalParticle.Data particle = new FractalParticle.Data(direction, scale, 10, 16, colour[0], colour[1]);
        world.func_195594_a((IParticleData)particle, x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public World getClientWorld() {
        return ClientUtils.mc().field_71441_e;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return ClientUtils.mc().field_71439_g;
    }

    @Override
    public String getNameFromUUID(String uuid) {
        return ClientUtils.mc().func_152347_ac().fillProfileProperties(new GameProfile(UUID.fromString(uuid.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")), null), false).getName();
    }

    @Override
    public void reInitGui() {
        Screen currentScreen = ClientUtils.mc().field_71462_r;
        if (currentScreen instanceof IEContainerScreen) {
            currentScreen.func_231158_b_(ClientUtils.mc(), currentScreen.field_230708_k_, currentScreen.field_230709_l_);
        }
    }

    @Override
    public void resetManual() {
        if (ClientUtils.mc().field_71462_r instanceof ManualScreen) {
            ClientUtils.mc().func_147108_a(null);
        }
        if (ManualHelper.getManual() != null) {
            ManualHelper.getManual().reset();
        }
    }

    @Override
    public void clearRenderCaches() {
        for (Runnable r : IEApi.renderCacheClearers) {
            r.run();
        }
    }

    @Override
    public void startSkyhookSound(SkylineHookEntity hook) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SkyhookSound(hook, new ResourceLocation("immersiveengineering", "skyhook")));
    }

    @Override
    public void openManual() {
        Minecraft.func_71410_x().func_147108_a((Screen)ManualHelper.getManual().getGui());
    }

    @Override
    public void openTileScreen(ResourceLocation guiId, TileEntity tileEntity) {
        if (guiId == Lib.GUIID_RedstoneConnector && tileEntity instanceof ConnectorRedstoneTileEntity) {
            Minecraft.func_71410_x().func_147108_a((Screen)new RedstoneConnectorScreen((ConnectorRedstoneTileEntity)tileEntity, (ITextComponent)tileEntity.func_195044_w().func_177230_c().func_235333_g_()));
        }
        if (guiId == Lib.GUIID_RedstoneProbe && tileEntity instanceof ConnectorProbeTileEntity) {
            Minecraft.func_71410_x().func_147108_a((Screen)new RedstoneProbeScreen((ConnectorProbeTileEntity)tileEntity, (ITextComponent)tileEntity.func_195044_w().func_177230_c().func_235333_g_()));
        }
    }

    @Override
    public void registerContainersAndScreens() {
        super.registerContainersAndScreens();
        this.registerScreen(Lib.GUIID_CokeOven, CokeOvenScreen::new);
        this.registerScreen(Lib.GUIID_AlloySmelter, AlloySmelterScreen::new);
        this.registerScreen(Lib.GUIID_BlastFurnace, BlastFurnaceScreen::new);
        this.registerScreen(Lib.GUIID_CraftingTable, CraftingTableScreen::new);
        this.registerScreen(Lib.GUIID_WoodenCrate, CrateScreen::new);
        this.registerScreen(Lib.GUIID_Workbench, ModWorkbenchScreen::new);
        this.registerScreen(Lib.GUIID_CircuitTable, CircuitTableScreen::new);
        this.registerScreen(Lib.GUIID_Assembler, AssemblerScreen::new);
        this.registerScreen(Lib.GUIID_Sorter, SorterScreen::new);
        this.registerScreen(Lib.GUIID_ItemBatcher, ItemBatcherScreen::new);
        this.registerScreen(Lib.GUIID_LogicUnit, LogicUnitScreen::new);
        this.registerScreen(Lib.GUIID_Squeezer, SqueezerScreen::new);
        this.registerScreen(Lib.GUIID_Fermenter, FermenterScreen::new);
        this.registerScreen(Lib.GUIID_Refinery, RefineryScreen::new);
        this.registerScreen(Lib.GUIID_ArcFurnace, ArcFurnaceScreen::new);
        this.registerScreen(Lib.GUIID_AutoWorkbench, AutoWorkbenchScreen::new);
        this.registerScreen(Lib.GUIID_Mixer, MixerScreen::new);
        this.registerScreen(Lib.GUIID_Turret_Gun, GunTurretScreen::new);
        this.registerScreen(Lib.GUIID_Turret_Chem, ChemTurretScreen::new);
        this.registerScreen(Lib.GUIID_FluidSorter, FluidSorterScreen::new);
        this.registerScreen(Lib.GUIID_Cloche, ClocheScreen::new);
        this.registerScreen(Lib.GUIID_ToolboxBlock, ToolboxBlockScreen::new);
        this.registerScreen(Lib.GUIID_Toolbox, ToolboxScreen::new);
        this.registerScreen(Lib.GUIID_Revolver, RevolverScreen::new);
        this.registerScreen(Lib.GUIID_MaintenanceKit, MaintenanceKitScreen::new);
        this.registerScreen(Lib.GUIID_CartCrate, CrateScreen::new);
        this.registerScreen(Lib.GUIID_CartReinforcedCrate, CrateScreen::new);
    }

    public <C extends Container, S extends Screen> void registerScreen(ResourceLocation containerName, ScreenManager.IScreenFactory<C, S> factory) {
        ContainerType<?> type = GuiHandler.getContainerType(containerName);
        ScreenManager.func_216911_a(type, factory);
    }

    @Override
    public Item.Properties useIEOBJRenderer(Item.Properties props) {
        return super.useIEOBJRenderer(props).setISTER(() -> () -> IEOBJItemRenderer.INSTANCE);
    }

    private static void requestModelsAndTextures() {
        DynamicModelLoader.requestTexture(SawbladeRenderer.SAWBLADE);
        DynamicModelLoader.requestTexture(ArcFurnaceRenderer.HOT_METLA_FLOW);
        DynamicModelLoader.requestTexture(ArcFurnaceRenderer.HOT_METLA_STILL);
        for (DrillheadItem.DrillHeadPerm p : DrillheadItem.DrillHeadPerm.ALL_PERMS) {
            DynamicModelLoader.requestTexture(p.texture);
        }
        DynamicModelLoader.requestTexture(RockcutterItem.texture);
        DynamicModelLoader.requestTexture(new ResourceLocation("immersiveengineering", "block/wire"));
        DynamicModelLoader.requestTexture(new ResourceLocation("immersiveengineering", "block/shaders/greyscale_fire"));
        for (ResourceLocation rl : ModelConveyor.rl_casing) {
            DynamicModelLoader.requestTexture(rl);
        }
        DynamicModelLoader.requestTexture(ConveyorHandler.textureConveyorColour);
        DynamicModelLoader.requestTexture(BasicConveyor.texture_off);
        DynamicModelLoader.requestTexture(BasicConveyor.texture_on);
        DynamicModelLoader.requestTexture(DropConveyor.texture_off);
        DynamicModelLoader.requestTexture(DropConveyor.texture_on);
        DynamicModelLoader.requestTexture(VerticalConveyor.texture_off);
        DynamicModelLoader.requestTexture(VerticalConveyor.texture_on);
        DynamicModelLoader.requestTexture(SplitConveyor.texture_off);
        DynamicModelLoader.requestTexture(SplitConveyor.texture_on);
        DynamicModelLoader.requestTexture(SplitConveyor.texture_casing);
        DynamicModelLoader.requestTexture(RedstoneConveyor.texture_panel);
        DynamicModelLoader.requestTexture(new ResourceLocation("immersiveengineering", "item/shader_slot"));
        ArcFurnaceRenderer.ELECTRODES = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/arc_furnace_electrodes.obj.ie"), "arc_furnace_electrodes", DynamicModel.ModelType.IE_OBJ);
        AutoWorkbenchRenderer.DYNAMIC = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/auto_workbench_animated.obj.ie"), "auto_workbench_animated", DynamicModel.ModelType.IE_OBJ);
        BottlingMachineRenderer.DYNAMIC = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/bottling_machine_animated.obj.ie"), "bottling_machine", DynamicModel.ModelType.IE_OBJ);
        BucketWheelRenderer.WHEEL = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "block/metal_multiblock/bucket_wheel.obj.ie"), "bucket_wheel", DynamicModel.ModelType.IE_OBJ);
        CrusherRenderer.BARREL = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/crusher_drum.obj"), "crusher_barrel", DynamicModel.ModelType.OBJ);
        SawmillRenderer.BLADE = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/sawmill_animated.obj"), "blade", DynamicModel.ModelType.OBJ);
        DieselGeneratorRenderer.FAN = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/diesel_generator_fan.obj"), "diesel_gen", DynamicModel.ModelType.OBJ);
        MetalPressRenderer.PISTON = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "block/metal_multiblock/metal_press_piston.obj"), "metal_press_piston", DynamicModel.ModelType.OBJ);
        MixerRenderer.AGITATOR = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/mixer_agitator.obj"), "mixer", DynamicModel.ModelType.OBJ);
        SampleDrillRenderer.DRILL = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "block/metal_device/core_drill_center.obj"), "sample_drill", DynamicModel.ModelType.OBJ);
        SqueezerRenderer.PISTON = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/squeezer_piston.obj"), "squeezer", DynamicModel.ModelType.OBJ);
        WatermillRenderer.MODEL = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "block/wooden_device/watermill.obj.ie"), "watermill", DynamicModel.ModelType.IE_OBJ);
        WindmillRenderer.MODEL = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "block/wooden_device/windmill.obj.ie"), "windmill", DynamicModel.ModelType.IE_OBJ);
        RedstoneConveyor.MODEL_PANEL = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/conveyor_redstone.obj.ie"), "conveyor_redstone", DynamicModel.ModelType.IE_OBJ);
        SawbladeRenderer.MODEL = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "item/buzzsaw_diesel.obj.ie"), "sawblade_entity", DynamicModel.ModelType.IE_OBJ);
        BlastFurnacePreheaterRenderer.MODEL = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "block/metal_device/blastfurnace_fan.obj"), "blastfurnace_preheater_fan", DynamicModel.ModelType.IE_OBJ);
    }

    public static void populateAPI() {
        SetRestrictedField.startInitializing(true);
        VertexBufferHolder.addToAPI();
        ManualHelper.MAKE_MULTIBLOCK_ELEMENT.setValue(mb -> new ManualElementMultiblock(ManualHelper.getManual(), mb));
        ManualHelper.MAKE_BLUEPRINT_ELEMENT.setValue(stacks -> new ManualElementBlueprint(ManualHelper.getManual(), stacks));
        IEManual.initManual();
        SetRestrictedField.lock(true);
    }

    static {
        IEApi.renderCacheClearers.add(() -> IESmartObjModel.modelCache.invalidateAll());
        IEApi.renderCacheClearers.add(() -> IESmartObjModel.cachedBakedItemModels.invalidateAll());
        IEApi.renderCacheClearers.add(() -> BakedConnectionModel.cache.invalidateAll());
        IEApi.renderCacheClearers.add(ModelConveyor.modelCache::clear);
        IEApi.renderCacheClearers.add(FluidPipeTileEntity.cachedOBJStates::clear);
        IEApi.renderCacheClearers.add(ClocheRenderer::reset);
        IEApi.renderCacheClearers.add(WatermillRenderer::reset);
        IEApi.renderCacheClearers.add(WindmillRenderer::reset);
        IEApi.renderCacheClearers.add(BucketWheelRenderer::reset);
        IEApi.renderCacheClearers.add(ModelCoresample::clearCache);
        IEApi.renderCacheClearers.add(ModelItemDynamicOverride.modelCache::clear);
        IEApi.renderCacheClearers.add(() -> ModelPowerpack.catenaryCacheLeft.invalidateAll());
        IEApi.renderCacheClearers.add(() -> ModelPowerpack.catenaryCacheRight.invalidateAll());
        IEApi.renderCacheClearers.add(() -> FeedthroughModel.CACHE.invalidateAll());
    }
}

