/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.util.IEExplosion;
import blusunrize.immersiveengineering.mixin.accessors.TNTEntityAccess;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class IEExplosiveEntity
extends TNTEntity {
    public static final EntityType<IEExplosiveEntity> TYPE = EntityType.Builder.func_220322_a(IEExplosiveEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.98f, 0.98f).func_206830_a("immersiveengineering:explosive");
    private float size;
    private Explosion.Mode mode = Explosion.Mode.BREAK;
    private boolean isFlaming = false;
    private float explosionDropChance;
    public BlockState block;
    private ITextComponent name;
    private static final DataParameter<Optional<BlockState>> dataMarker_block;
    private static final DataParameter<Integer> dataMarker_fuse;

    public IEExplosiveEntity(EntityType<IEExplosiveEntity> type, World world) {
        super(type, world);
    }

    public IEExplosiveEntity(World world, double x, double y, double z, LivingEntity igniter, BlockState blockstate, float size) {
        super(TYPE, world);
        this.func_70107_b(x, y, z);
        double jumpingDirection = world.field_73012_v.nextDouble() * 2.0 * Math.PI;
        this.func_213293_j(-Math.sin(jumpingDirection) * 0.02, 0.2, -Math.cos(jumpingDirection) * 0.02);
        this.func_184534_a(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        ((TNTEntityAccess)((Object)this)).setOwner(igniter);
        this.size = size;
        this.block = blockstate;
        this.explosionDropChance = 1.0f / size;
        this.setBlockSynced();
    }

    public IEExplosiveEntity(World world, BlockPos pos, LivingEntity igniter, BlockState blockstate, float size) {
        this(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, igniter, blockstate, size);
    }

    public IEExplosiveEntity setMode(Explosion.Mode smoke) {
        this.mode = smoke;
        return this;
    }

    public IEExplosiveEntity setFlaming(boolean fire) {
        this.isFlaming = fire;
        return this;
    }

    public IEExplosiveEntity setDropChance(float chance) {
        this.explosionDropChance = chance;
        return this;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarker_block, Optional.empty());
        this.field_70180_af.func_187214_a(dataMarker_fuse, (Object)0);
    }

    private void setBlockSynced() {
        if (this.block != null) {
            this.field_70180_af.func_187227_b(dataMarker_block, Optional.of(this.block));
            this.field_70180_af.func_187227_b(dataMarker_fuse, (Object)this.func_184536_l());
        }
    }

    private void getBlockSynced() {
        this.block = ((Optional)this.field_70180_af.func_187225_a(dataMarker_block)).orElse(null);
        this.func_184534_a((Integer)this.field_70180_af.func_187225_a(dataMarker_fuse));
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        ItemStack s;
        if (this.block != null && this.name == null && !(s = new ItemStack((IItemProvider)this.block.func_177230_c(), 1)).func_190926_b() && s.func_77973_b() != Items.field_190931_a) {
            this.name = s.func_200301_q();
        }
        if (this.name != null) {
            return this.name;
        }
        return super.func_200200_C_();
    }

    protected void func_213281_b(CompoundNBT tagCompound) {
        super.func_213281_b(tagCompound);
        tagCompound.func_74776_a("explosionPower", this.size);
        tagCompound.func_74768_a("explosionSmoke", this.mode.ordinal());
        tagCompound.func_74757_a("explosionFire", this.isFlaming);
        if (this.block != null) {
            tagCompound.func_74768_a("block", Block.func_196246_j((BlockState)this.block));
        }
    }

    protected void func_70037_a(CompoundNBT tagCompound) {
        super.func_70037_a(tagCompound);
        this.size = tagCompound.func_74760_g("explosionPower");
        this.mode = Explosion.Mode.values()[tagCompound.func_74762_e("explosionSmoke")];
        this.isFlaming = tagCompound.func_74767_n("explosionFire");
        if (tagCompound.func_150297_b("block", 3)) {
            this.block = Block.func_196257_b((int)tagCompound.func_74762_e("block"));
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.block == null) {
            this.getBlockSynced();
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
        }
        int newFuse = this.func_184536_l() - 1;
        this.func_184534_a(newFuse);
        if (newFuse <= 0) {
            this.func_70106_y();
            IEExplosion explosion = new IEExplosion(this.field_70170_p, (Entity)this, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 16.0f), this.func_226281_cx_(), this.size, this.isFlaming, this.mode).setDropChance(this.explosionDropChance);
            if (!ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        } else {
            this.func_233566_aG_();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    @Nonnull
    public EntityType<?> func_200600_R() {
        return TYPE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static {
        TYPE.setRegistryName("immersiveengineering", "explosive");
        dataMarker_block = EntityDataManager.func_187226_a(IEExplosiveEntity.class, (IDataSerializer)DataSerializers.field_187197_g);
        dataMarker_fuse = EntityDataManager.func_187226_a(IEExplosiveEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    }
}

