/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxConnection;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxContainerItem;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyHelper {
    static HashMap<Item, Boolean> reverseInsertion = new HashMap();

    public static int forceExtractFlux(ItemStack stack, int energy, boolean simulate) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Boolean b = reverseInsertion.get(stack.func_77973_b());
        if (b == Boolean.TRUE) {
            int stored = EnergyHelper.getEnergyStored((ICapabilityProvider)stack);
            EnergyHelper.insertFlux((ICapabilityProvider)stack, -energy, simulate);
            return stored - EnergyHelper.getEnergyStored((ICapabilityProvider)stack);
        }
        int drawn = EnergyHelper.extractFlux((ICapabilityProvider)stack, energy, simulate);
        if (b == null) {
            int stored = EnergyHelper.getEnergyStored((ICapabilityProvider)stack);
            EnergyHelper.insertFlux((ICapabilityProvider)stack, -energy, simulate);
            drawn = stored - EnergyHelper.getEnergyStored((ICapabilityProvider)stack);
            reverseInsertion.put(stack.func_77973_b(), drawn > 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        return drawn;
    }

    public static int getEnergyStored(ICapabilityProvider stack) {
        return EnergyHelper.getEnergyStored(stack, null);
    }

    public static int getEnergyStored(ICapabilityProvider stack, @Nullable Direction side) {
        if (stack == null) {
            return 0;
        }
        return stack.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public static int getMaxEnergyStored(ICapabilityProvider stack) {
        return EnergyHelper.getMaxEnergyStored(stack, null);
    }

    public static int getMaxEnergyStored(ICapabilityProvider stack, @Nullable Direction side) {
        if (stack == null) {
            return 0;
        }
        return stack.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public static boolean isFluxReceiver(ICapabilityProvider tile) {
        return EnergyHelper.isFluxReceiver(tile, null);
    }

    public static boolean isFluxReceiver(ICapabilityProvider tile, @Nullable Direction facing) {
        if (tile == null) {
            return false;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, facing).map(IEnergyStorage::canReceive).orElse(false);
    }

    public static boolean isFluxRelated(ICapabilityProvider tile) {
        return EnergyHelper.isFluxRelated(tile, null);
    }

    public static boolean isFluxRelated(ICapabilityProvider tile, @Nullable Direction facing) {
        if (tile == null) {
            return false;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, facing).isPresent();
    }

    public static int insertFlux(ICapabilityProvider tile, int energy, boolean simulate) {
        return EnergyHelper.insertFlux(tile, null, energy, simulate);
    }

    public static int insertFlux(ICapabilityProvider tile, @Nullable Direction facing, int energy, boolean simulate) {
        if (tile == null) {
            return 0;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, facing).map(storage -> storage.receiveEnergy(energy, simulate)).orElse(0);
    }

    public static int extractFlux(ICapabilityProvider tile, int energy, boolean simulate) {
        return EnergyHelper.extractFlux(tile, null, energy, simulate);
    }

    public static int extractFlux(ICapabilityProvider tile, @Nullable Direction facing, int energy, boolean simulate) {
        if (tile == null) {
            return 0;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, facing).map(storage -> storage.extractEnergy(energy, simulate)).orElse(0);
    }

    public static int distributeFlux(Collection<IEnergyStorage> storages, int amount, boolean simulate) {
        int finalAmount = amount;
        storages = storages.stream().filter(Objects::nonNull).map(storage -> Pair.of((Object)storage, (Object)storage.receiveEnergy(finalAmount, true))).sorted(Comparator.comparingInt(Pair::getRight)).map(Pair::getLeft).collect(Collectors.toList());
        int remainingOutputs = storages.size();
        for (IEnergyStorage storage2 : storages) {
            int possibleOutput = (int)Math.ceil((float)amount / (float)remainingOutputs);
            int inserted = storage2.receiveEnergy(possibleOutput, simulate);
            amount -= inserted;
            --remainingOutputs;
        }
        return amount;
    }

    public static class ItemEnergyStorage
    implements IEnergyStorage {
        ItemStack stack;
        IIEEnergyItem ieEnergyItem;

        public ItemEnergyStorage(ItemStack item) {
            assert (item.func_77973_b() instanceof IIEEnergyItem);
            this.stack = item;
            this.ieEnergyItem = (IIEEnergyItem)item.func_77973_b();
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.ieEnergyItem.receiveEnergy(this.stack, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.ieEnergyItem.extractEnergy(this.stack, maxExtract, simulate);
        }

        public int getEnergyStored() {
            return this.ieEnergyItem.getEnergyStored(this.stack);
        }

        public int getMaxEnergyStored() {
            return this.ieEnergyItem.getMaxEnergyStored(this.stack);
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    public static interface IIEEnergyItem
    extends IFluxContainerItem {
        @Override
        default public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
            return ItemNBTHelper.insertFluxItem(container, energy, this.getMaxEnergyStored(container), simulate);
        }

        @Override
        default public int extractEnergy(ItemStack container, int energy, boolean simulate) {
            return ItemNBTHelper.extractFluxFromItem(container, energy, simulate);
        }

        @Override
        default public int getEnergyStored(ItemStack container) {
            return ItemNBTHelper.getFluxStoredInItem(container);
        }
    }

    public static class IEForgeEnergyWrapper
    implements IEnergyStorage {
        final IIEInternalFluxConnector fluxHandler;
        public final Direction side;

        public IEForgeEnergyWrapper(IIEInternalFluxConnector fluxHandler, Direction side) {
            this.fluxHandler = fluxHandler;
            this.side = side;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).receiveEnergy(this.side, maxReceive, simulate);
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).extractEnergy(this.side, maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getEnergyStored(this.side);
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getMaxEnergyStored(this.side);
            }
            return 0;
        }

        public boolean canExtract() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getFluxStorage().getLimitExtract() > 0;
            }
            return false;
        }

        public boolean canReceive() {
            if (this.fluxHandler instanceof IIEInternalFluxHandler) {
                return ((IIEInternalFluxHandler)this.fluxHandler).getFluxStorage().getLimitReceive() > 0;
            }
            return false;
        }

        public static IEForgeEnergyWrapper[] getDefaultWrapperArray(IIEInternalFluxConnector handler) {
            return new IEForgeEnergyWrapper[]{new IEForgeEnergyWrapper(handler, Direction.DOWN), new IEForgeEnergyWrapper(handler, Direction.UP), new IEForgeEnergyWrapper(handler, Direction.NORTH), new IEForgeEnergyWrapper(handler, Direction.SOUTH), new IEForgeEnergyWrapper(handler, Direction.WEST), new IEForgeEnergyWrapper(handler, Direction.EAST)};
        }
    }

    public static interface IIEInternalFluxConnector
    extends IFluxConnection {
        @Nonnull
        public IEEnums.IOSideConfig getEnergySideConfig(@Nullable Direction var1);

        @Override
        default public boolean canConnectEnergy(@Nullable Direction fd) {
            return this.getEnergySideConfig(fd) != IEEnums.IOSideConfig.NONE;
        }

        @Nullable
        public IEForgeEnergyWrapper getCapabilityWrapper(Direction var1);
    }

    public static interface IIEInternalFluxHandler
    extends IIEInternalFluxConnector,
    IFluxReceiver,
    IFluxProvider {
        @Nonnull
        public FluxStorage getFluxStorage();

        default public void postEnergyTransferUpdate(int energy, boolean simulate) {
        }

        @Override
        default public int extractEnergy(@Nullable Direction fd, int amount, boolean simulate) {
            if (((TileEntity)this).func_145831_w().field_72995_K || this.getEnergySideConfig(fd) != IEEnums.IOSideConfig.OUTPUT) {
                return 0;
            }
            int r = this.getFluxStorage().extractEnergy(amount, simulate);
            this.postEnergyTransferUpdate(-r, simulate);
            return r;
        }

        @Override
        default public int getEnergyStored(@Nullable Direction fd) {
            return this.getFluxStorage().getEnergyStored();
        }

        @Override
        default public int getMaxEnergyStored(@Nullable Direction fd) {
            return this.getFluxStorage().getMaxEnergyStored();
        }

        @Override
        default public int receiveEnergy(@Nullable Direction fd, int amount, boolean simulate) {
            if (((TileEntity)this).func_145831_w().field_72995_K || this.getEnergySideConfig(fd) != IEEnums.IOSideConfig.INPUT) {
                return 0;
            }
            int r = this.getFluxStorage().receiveEnergy(amount, simulate);
            this.postEnergyTransferUpdate(r, simulate);
            return r;
        }
    }
}

