/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobSpawnInfo {
    public static final Logger field_242550_a = LogManager.getLogger();
    public static final MobSpawnInfo field_242551_b = new MobSpawnInfo(0.1f, (Map)Stream.of(EntityClassification.values()).collect(ImmutableMap.toImmutableMap(entityClassification -> entityClassification, entityClassification -> ImmutableList.of())), (Map<EntityType<?>, SpawnCosts>)ImmutableMap.of(), false);
    public static final MapCodec<MobSpawnInfo> field_242552_c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(mobSpawnInfo -> Float.valueOf(mobSpawnInfo.field_242553_d)), (App)Codec.simpleMap(EntityClassification.field_233667_g_, (Codec)Spawners.field_242587_b.listOf().promotePartial(Util.func_240982_a_("Spawn data: ", arg_0 -> ((Logger)field_242550_a).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_(EntityClassification.values())).fieldOf("spawners").forGetter(mobSpawnInfo -> mobSpawnInfo.field_242554_e), (App)Codec.simpleMap(Registry.field_212629_r, SpawnCosts.field_242579_a, Registry.field_212629_r).fieldOf("spawn_costs").forGetter(mobSpawnInfo -> mobSpawnInfo.field_242555_f), (App)Codec.BOOL.fieldOf("player_spawn_friendly").orElse((Object)false).forGetter(MobSpawnInfo::func_242562_b)).apply((Applicative)instance, MobSpawnInfo::new));
    private final float field_242553_d;
    private final Map<EntityClassification, List<Spawners>> field_242554_e;
    private final Map<EntityType<?>, SpawnCosts> field_242555_f;
    private final boolean field_242556_g;

    private MobSpawnInfo(float f, Map<EntityClassification, List<Spawners>> map, Map<EntityType<?>, SpawnCosts> map2, boolean bl) {
        this.field_242553_d = f;
        this.field_242554_e = map;
        this.field_242555_f = map2;
        this.field_242556_g = bl;
    }

    public List<Spawners> func_242559_a(EntityClassification entityClassification) {
        return this.field_242554_e.getOrDefault(entityClassification, (List<Spawners>)ImmutableList.of());
    }

    @Nullable
    public SpawnCosts func_242558_a(EntityType<?> entityType) {
        return this.field_242555_f.get(entityType);
    }

    public float func_242557_a() {
        return this.field_242553_d;
    }

    public boolean func_242562_b() {
        return this.field_242556_g;
    }

    public static class Builder {
        private final Map<EntityClassification, List<Spawners>> field_242567_a = (Map)Stream.of(EntityClassification.values()).collect(ImmutableMap.toImmutableMap(entityClassification -> entityClassification, entityClassification -> Lists.newArrayList()));
        private final Map<EntityType<?>, SpawnCosts> field_242568_b = Maps.newLinkedHashMap();
        private float field_242569_c = 0.1f;
        private boolean field_242570_d;

        public Builder func_242575_a(EntityClassification entityClassification, Spawners spawners) {
            this.field_242567_a.get(entityClassification).add(spawners);
            return this;
        }

        public Builder func_242573_a(EntityType<?> entityType, double d, double d2) {
            this.field_242568_b.put(entityType, new SpawnCosts(d2, d));
            return this;
        }

        public Builder func_242572_a(float f) {
            this.field_242569_c = f;
            return this;
        }

        public Builder func_242571_a() {
            this.field_242570_d = true;
            return this;
        }

        public MobSpawnInfo func_242577_b() {
            return new MobSpawnInfo(this.field_242569_c, (Map)this.field_242567_a.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableList.copyOf((Collection)((Collection)entry.getValue())))), (Map)ImmutableMap.copyOf(this.field_242568_b), this.field_242570_d);
        }
    }

    public static class SpawnCosts {
        public static final Codec<SpawnCosts> field_242579_a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(spawnCosts -> spawnCosts.field_242580_b), (App)Codec.DOUBLE.fieldOf("charge").forGetter(spawnCosts -> spawnCosts.field_242581_c)).apply((Applicative)instance, SpawnCosts::new));
        private final double field_242580_b;
        private final double field_242581_c;

        private SpawnCosts(double d, double d2) {
            this.field_242580_b = d;
            this.field_242581_c = d2;
        }

        public double func_242582_a() {
            return this.field_242580_b;
        }

        public double func_242585_b() {
            return this.field_242581_c;
        }
    }

    public static class Spawners
    extends WeightedRandom.Item {
        public static final Codec<Spawners> field_242587_b = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212629_r.fieldOf("type").forGetter(spawners -> spawners.field_242588_c), (App)Codec.INT.fieldOf("weight").forGetter(spawners -> spawners.field_76292_a), (App)Codec.INT.fieldOf("minCount").forGetter(spawners -> spawners.field_242589_d), (App)Codec.INT.fieldOf("maxCount").forGetter(spawners -> spawners.field_242590_e)).apply((Applicative)instance, Spawners::new));
        public final EntityType<?> field_242588_c;
        public final int field_242589_d;
        public final int field_242590_e;

        public Spawners(EntityType<?> entityType, int n, int n2, int n3) {
            super(n);
            this.field_242588_c = entityType.func_220339_d() == EntityClassification.MISC ? EntityType.field_200784_X : entityType;
            this.field_242589_d = n2;
            this.field_242590_e = n3;
        }

        public String toString() {
            return EntityType.func_200718_a(this.field_242588_c) + "*(" + this.field_242589_d + "-" + this.field_242590_e + "):" + this.field_76292_a;
        }
    }
}

