/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.gui;

import fabric.net.mca.MCA;
import fabric.net.mca.client.gui.InteractScreen;
import fabric.net.mca.client.gui.MCAScreens;
import fabric.net.mca.client.resources.Icon;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.entity.ai.relationship.RelationshipState;
import fabric.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import fabric.net.mca.network.c2s.GetFamilyTreeRequest;
import fabric.net.mca.util.compat.RenderSystemCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FamilyTreeScreen
extends class_437 {
    private static final int HORIZONTAL_SPACING = 20;
    private static final int VERTICAL_SPACING = 60;
    private static final int SPOUSE_HORIZONTAL_SPACING = 50;
    private UUID focusedEntityId;
    private final Map<UUID, FamilyTreeNode> family = new HashMap<UUID, FamilyTreeNode>();
    private final TreeNode emptyNode;
    private TreeNode tree = this.emptyNode = new TreeNode();
    @Nullable
    private TreeNode focused;
    private double scrollX;
    private double scrollY;
    private final class_437 parent;

    public FamilyTreeScreen(UUID entityId) {
        super((class_2561)new class_2588("gui.family_tree.title"));
        this.focusedEntityId = entityId;
        this.parent = class_310.method_1551().field_1755;
    }

    public boolean method_25421() {
        return false;
    }

    public void setFamilyData(UUID uuid, Map<UUID, FamilyTreeNode> family) {
        this.focusedEntityId = uuid;
        this.family.putAll(family);
        this.rebuildTree();
    }

    private boolean focusEntity(UUID id) {
        this.focusedEntityId = id;
        NetworkHandler.sendToServer(new GetFamilyTreeRequest(id));
        return false;
    }

    public void method_25426() {
        this.focusEntity(this.focusedEntityId);
        this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 - 25, 200, 20, (class_2561)new class_2588("gui.done"), sender -> this.method_25419()));
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.scrollX += deltaX;
            this.scrollY += deltaY;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.focused != null) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            if (this.focusEntity(this.focused.id)) {
                this.rebuildTree();
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        FamilyTreeScreen.method_25294((class_4587)matrices, (int)0, (int)30, (int)this.field_22789, (int)(this.field_22790 - 30), (int)0x66000000);
        this.focused = null;
        class_1041 window = class_310.method_1551().method_22683();
        double f = window.method_4495();
        int windowHeight = (int)Math.round((double)window.method_4502() * f);
        int x = 0;
        int y = (int)(30.0 * f);
        int w = (int)((double)this.field_22789 * f);
        int h = (int)((double)(this.field_22790 - 60) * f);
        GL11.glScissor((int)x, (int)(windowHeight - h - y), (int)w, (int)h);
        GL11.glEnable((int)3089);
        matrices.method_22903();
        int xx = (int)(this.scrollX + (double)(this.field_22789 / 2));
        int yy = (int)(this.scrollY + (double)(this.field_22790 / 2));
        matrices.method_22904((double)xx, (double)yy, 0.0);
        this.tree.render(matrices, mouseX - xx, mouseY - yy);
        matrices.method_22909();
        GL11.glDisable((int)3089);
        FamilyTreeNode selected = this.family.get(this.focusedEntityId);
        class_2561 label = selected == null ? this.field_22785 : new class_2585(selected.getName()).method_27693("'s ").method_10852(this.field_22785);
        FamilyTreeScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)label, (int)(this.field_22789 / 2), (int)10, (int)0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void rebuildTree() {
        this.scrollX = 14.0;
        this.scrollY = -69.0;
        FamilyTreeNode focusedNode = this.family.get(this.focusedEntityId);
        this.focused = null;
        this.tree = this.emptyNode;
        if (focusedNode != null) {
            this.tree = this.insertParents(new TreeNode(focusedNode, true), focusedNode, 2);
        }
    }

    private TreeNode insertParents(TreeNode root, FamilyTreeNode focusedNode, int levels) {
        @Nullable FamilyTreeNode father = this.family.get(focusedNode.father());
        @Nullable FamilyTreeNode mother = this.family.get(focusedNode.mother());
        @Nullable FamilyTreeNode newRoot = father != null ? father : mother;
        TreeNode fNode = newRoot == null ? new TreeNode() : new TreeNode(newRoot, false);
        fNode.children.add(root);
        @Nullable FamilyTreeNode spouse = newRoot == father ? mother : father;
        TreeNode treeNode = fNode.spouse = spouse == null ? new TreeNode() : new TreeNode(spouse, false);
        if (newRoot != null && levels > 0) {
            return this.insertParents(fNode, newRoot, levels - 1);
        }
        return fNode;
    }

    private final class TreeNode {
        private boolean widthComputed;
        private int width;
        private int labelWidth;
        private final List<class_2561> label = new ArrayList<class_2561>();
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private Bounds bounds;
        TreeNode spouse;
        final UUID id;
        final boolean deceased;
        private final RelationshipState relationship;
        private final String defaultNodeName = "???";

        private TreeNode() {
            this.id = null;
            this.deceased = false;
            this.relationship = RelationshipState.SINGLE;
            this.label.add((class_2561)new class_2585("???"));
        }

        public TreeNode(FamilyTreeNode node, boolean recurse) {
            this(node, new HashSet<UUID>(), recurse);
        }

        public TreeNode(FamilyTreeNode node, Set<UUID> parsed, boolean recurse) {
            this.id = node.id();
            this.deceased = node.isDeceased();
            this.relationship = node.getRelationshipState();
            class_2585 text = new class_2585(MCA.isBlankString(node.getName()) ? "???" : node.getName());
            this.label.add((class_2561)text.method_10862(text.method_10866().method_27703(class_5251.method_27717((int)node.gender().getColor()))));
            this.label.add((class_2561)node.getProfessionText().method_27692(class_124.field_1080));
            FamilyTreeNode father = (FamilyTreeNode)FamilyTreeScreen.this.family.get(node.father());
            FamilyTreeNode mother = (FamilyTreeNode)FamilyTreeScreen.this.family.get(node.mother());
            if ((father == null || father.isDeceased()) && (mother == null || mother.isDeceased())) {
                this.label.add((class_2561)new class_2588("gui.family_tree.label.orphan").method_27692(class_124.field_1080));
            }
            if (node.getRelationshipState() != RelationshipState.SINGLE) {
                this.label.add((class_2561)new class_2588("marriage." + node.getRelationshipState().base().getIcon()));
            }
            if (recurse) {
                node.children().forEach(child -> {
                    FamilyTreeNode e = (FamilyTreeNode)FamilyTreeScreen.this.family.get(child);
                    if (e != null) {
                        this.children.add(new TreeNode(e, parsed, parsed.add((UUID)child)));
                    }
                });
                FamilyTreeNode spouse = (FamilyTreeNode)FamilyTreeScreen.this.family.get(node.partner());
                if (spouse != null) {
                    this.spouse = new TreeNode(spouse, parsed, false);
                } else if (!this.children.isEmpty()) {
                    this.spouse = new TreeNode();
                }
            }
        }

        public void render(class_4587 matrices, int mouseX, int mouseY) {
            boolean isFocused;
            Bounds bounds = this.getBounds();
            boolean bl = isFocused = this.id != null && bounds.contains(mouseX, mouseY);
            if (isFocused) {
                FamilyTreeScreen.this.focused = this;
            }
            int childrenStartX = -this.getWidth() / 2;
            for (TreeNode node : this.children) {
                int x = (childrenStartX += (node.getWidth() + 20) / 2) + 10;
                int y = 60;
                this.drawHook(matrices, x, y);
                matrices.method_22903();
                matrices.method_22904((double)x, (double)y, 0.0);
                node.render(matrices, mouseX - x, mouseY - y);
                matrices.method_22909();
                childrenStartX += (node.getWidth() + 20) / 2;
            }
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 400.0);
            int fillColor = isFocused ? -267386816 : -267386864;
            int borderColor = isFocused ? -14155649 : 0x505000FF;
            class_332.method_25294((class_4587)matrices, (int)bounds.left, (int)(bounds.top + 1), (int)(bounds.left + 1), (int)(bounds.bottom - 1), (int)fillColor);
            class_332.method_25294((class_4587)matrices, (int)(bounds.right - 1), (int)(bounds.top + 1), (int)bounds.right, (int)(bounds.bottom - 1), (int)fillColor);
            class_332.method_25294((class_4587)matrices, (int)(bounds.left + 1), (int)bounds.top, (int)(bounds.right - 1), (int)bounds.bottom, (int)fillColor);
            class_332.method_25294((class_4587)matrices, (int)(bounds.left + 1), (int)(bounds.top + 1), (int)(bounds.left + 2), (int)(bounds.bottom - 1), (int)borderColor);
            class_332.method_25294((class_4587)matrices, (int)(bounds.right - 2), (int)(bounds.top + 1), (int)(bounds.right - 1), (int)(bounds.bottom - 1), (int)borderColor);
            class_332.method_25294((class_4587)matrices, (int)(bounds.left + 2), (int)(bounds.top + 1), (int)(bounds.right - 2), (int)(bounds.top + 2), (int)borderColor);
            class_332.method_25294((class_4587)matrices, (int)(bounds.left + 2), (int)(bounds.bottom - 2), (int)(bounds.right - 2), (int)(bounds.bottom - 1), (int)borderColor);
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            int l = bounds.top + 5;
            int k = bounds.left + 6;
            if (this.deceased) {
                k += 20;
            }
            class_1159 matrix4f = matrices.method_23760().method_23761();
            class_327 r = class_310.method_1551().field_1772;
            for (int s = 0; s < this.label.size(); ++s) {
                class_2561 line = this.label.get(s);
                if (line != null) {
                    r.method_30882(line, (float)k, (float)l, -1, true, matrix4f, (class_4597)immediate, false, 0, 0xF000F0);
                }
                if (s == 0) {
                    l += 2;
                }
                l += 10;
            }
            immediate.method_22993();
            matrices.method_22909();
            RenderSystemCompat.setShaderTexture(0, InteractScreen.ICON_TEXTURES);
            if (this.deceased) {
                Icon icon = MCAScreens.getInstance().getIcon("deceased");
                class_332.method_25291((class_4587)matrices, (int)(bounds.left + 6), (int)(bounds.top + 6), (int)0, (float)icon.u(), (float)icon.v(), (int)16, (int)16, (int)256, (int)256);
                if (isFocused && mouseX <= bounds.left + 20) {
                    matrices.method_22903();
                    matrices.method_22904(0.0, 0.0, 20.0);
                    FamilyTreeScreen.this.method_25424(matrices, (class_2561)new class_2588("gui.family_tree.label.deceased"), mouseX, mouseY);
                    matrices.method_22909();
                }
            }
            if (this.spouse != null) {
                int x = bounds.left - 50;
                int y = bounds.top + bounds.bottom / 2;
                FamilyTreeScreen.this.method_25292(matrices, x, bounds.left - 1, y, -1);
                if (this.relationship == RelationshipState.MARRIED_TO_PLAYER || this.relationship == RelationshipState.MARRIED_TO_VILLAGER || this.relationship == RelationshipState.ENGAGED || this.relationship == RelationshipState.PROMISED || this.relationship == RelationshipState.WIDOW) {
                    Icon icon = MCAScreens.getInstance().getIcon(this.relationship.getIcon());
                    class_332.method_25291((class_4587)matrices, (int)(bounds.left - 25 - 8), (int)(y - 8), (int)0, (float)icon.u(), (float)icon.v(), (int)16, (int)16, (int)256, (int)256);
                }
                int n = this.spouse.label.size();
                Objects.requireNonNull(FamilyTreeScreen.this.field_22793);
                matrices.method_22903();
                matrices.method_22904((double)(x -= this.spouse.getWidth() / 2 - 6), (double)(y -= n * 9 / 2), 0.0);
                this.spouse.render(matrices, mouseX - x, mouseY - y);
                matrices.method_22909();
            }
        }

        private void drawHook(class_4587 matrices, int endX, int endY) {
            int midY = endY / 2;
            FamilyTreeScreen.this.method_25301(matrices, 0, 0, midY, -1);
            FamilyTreeScreen.this.method_25292(matrices, 0, endX, midY, -1);
            FamilyTreeScreen.this.method_25301(matrices, endX, midY, endY, -1);
        }

        public int getWidth() {
            if (!this.widthComputed) {
                this.widthComputed = true;
                this.labelWidth = this.label.stream().mapToInt(arg_0 -> ((class_327)FamilyTreeScreen.this.field_22793).method_27525(arg_0)).max().orElse(0);
                if (this.deceased) {
                    this.labelWidth += 20;
                }
                this.width = Math.max(this.labelWidth + 10, this.children.stream().mapToInt(TreeNode::getWidth).sum()) + 10;
                if (this.spouse != null) {
                    this.width += this.spouse.getWidth() + 50;
                }
            }
            return this.width;
        }

        public Bounds getBounds() {
            if (this.bounds == null) {
                this.getWidth();
                int padding = 4;
                int n = -this.labelWidth / 2 - padding;
                int n2 = this.labelWidth / 2 + padding * 2;
                int n3 = -padding;
                Objects.requireNonNull(FamilyTreeScreen.this.field_22793);
                this.bounds = new Bounds(n, n2, n3, 9 * this.label.size() + padding * 2);
            }
            return this.bounds;
        }
    }

    static final class Bounds {
        final int left;
        final int right;
        final int top;
        final int bottom;

        public Bounds(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public Bounds add(int x, int y) {
            return new Bounds(this.left + x, this.right + x, this.top + y, this.bottom + y);
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.left && mouseY >= this.top && mouseX <= this.right && mouseY <= this.bottom;
        }
    }
}

