/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.model;

import com.google.common.base.Preconditions;
import fabric.net.mca.util.compat.model.ModelTransform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3532;
import net.minecraft.class_630;

public interface ModelTransformSet {
    public Transformer get(String var1);

    default public ModelTransformSet interpolate(ModelTransformSet to, float delta) {
        if (delta <= 0.0f) {
            return this;
        }
        if (delta >= 1.0f) {
            return to;
        }
        Transformer[] components = new Transformer[2];
        Transformer combined = (part, op, scale) -> {
            components[0].applyTo(part, Op.LERP, delta);
            components[1].applyTo(part, Op.LERP, 1.0f - delta);
        };
        return key -> {
            components[0] = (Transformer)Preconditions.checkNotNull((Object)this.get(key), (Object)("Cannot interpolate because the source set was missing key `" + key + "`"));
            components[1] = (Transformer)Preconditions.checkNotNull((Object)to.get(key), (Object)("Cannot interpolate because the target set was missing key `" + key + "`"));
            return combined;
        };
    }

    public static interface Transformer {
        default public void applyTo(class_630 part) {
            this.applyTo(part, Op.SET, 1.0f);
        }

        public void applyTo(class_630 var1, Op var2, float var3);
    }

    public static interface Op {
        public static final Op KEEP = (delta, a, b) -> a;
        public static final Op SET = (delta, a, b) -> b;
        public static final Op ADD = (delta, a, b) -> a + b;
        public static final Op LERP = class_3532::method_16439;

        public float apply(float var1, float var2, float var3);
    }

    public static class Builder {
        private static final float TO_RADIANS = (float)Math.PI / 180;
        private final Map<String, Transformer> transforms = new HashMap<String, Transformer>();

        public Builder with(String key, float x, float y, float z, float pitch, float yaw, float roll) {
            return this.with(key, x, y, z, pitch, yaw, roll, Op.SET, Op.SET);
        }

        public Builder with(String key, float x, float y, float z, float pitch, float yaw, float roll, Op pivot) {
            return this.with(key, x, y, z, pitch, yaw, roll, pivot, Op.SET);
        }

        public Builder rotate(String key, float pitch, float yaw, float roll) {
            return this.rotate(key, pitch, yaw, roll, Op.SET);
        }

        public Builder rotate(String key, float pitch, float yaw, float roll, Op op) {
            return this.with(key, 0.0f, 0.0f, 0.0f, pitch, yaw, roll, Op.KEEP, op);
        }

        public Builder with(String key, float x, float y, float z, float pitch, float yaw, float roll, Op pivot, Op rotate) {
            ModelTransform transform = Builder.createTransform(x, y, z, pitch, yaw, roll);
            this.transforms.put(key, (part, op, delta) -> {
                part.field_3657 = op.apply(delta, part.field_3657, pivot.apply(delta, part.field_3657, transform.pivotX));
                part.field_3656 = op.apply(delta, part.field_3656, pivot.apply(delta, part.field_3656, transform.pivotY));
                part.field_3655 = op.apply(delta, part.field_3655, pivot.apply(delta, part.field_3655, transform.pivotZ));
                part.field_3654 = op.apply(delta, part.field_3654, rotate.apply(delta, part.field_3654, transform.pitch));
                part.field_3675 = op.apply(delta, part.field_3675, rotate.apply(delta, part.field_3675, transform.yaw));
                part.field_3674 = op.apply(delta, part.field_3674, rotate.apply(delta, part.field_3674, transform.roll));
            });
            return this;
        }

        public static ModelTransform createTransform(float x, float y, float z, float pitch, float yaw, float roll) {
            return ModelTransform.of(x, y, z, pitch * ((float)Math.PI / 180), yaw * ((float)Math.PI / 180), roll * ((float)Math.PI / 180));
        }

        public ModelTransformSet build() {
            return new HashMap<String, Transformer>(this.transforms)::get;
        }
    }
}

