/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.model;

import com.google.common.collect.ImmutableList;
import fabric.net.mca.client.model.VillagerEntityBaseModelMCA;
import fabric.net.mca.util.compat.model.Dilation;
import fabric.net.mca.util.compat.model.ModelData;
import fabric.net.mca.util.compat.model.ModelPartBuilder;
import fabric.net.mca.util.compat.model.ModelPartCompat;
import fabric.net.mca.util.compat.model.ModelPartData;
import fabric.net.mca.util.compat.model.ModelTransform;
import fabric.net.mca.util.compat.model.PlayerEntityModelCompat;
import net.minecraft.class_1309;
import net.minecraft.class_572;
import net.minecraft.class_630;

public class VillagerEntityModelMCA<T extends class_1309>
extends VillagerEntityBaseModelMCA<T> {
    protected static final String BREASTPLATE = "breastplate";
    public final class_630 breastsWear;
    public final class_630 leftArmwear;
    public final class_630 rightArmwear;
    public final class_630 leftLegwear;
    public final class_630 rightLegwear;
    public final class_630 bodyWear;
    private boolean wearsHidden;

    public VillagerEntityModelMCA(ModelPartCompat tree) {
        super(tree);
        this.bodyWear = tree.getChild("jacket");
        this.leftArmwear = tree.getChild("left_sleeve");
        this.rightArmwear = tree.getChild("right_sleeve");
        this.leftLegwear = tree.getChild("left_pants");
        this.rightLegwear = tree.getChild("right_pants");
        this.breastsWear = tree.getChild(BREASTPLATE);
    }

    public static ModelData hairData(Dilation dilation) {
        ModelData modelData = VillagerEntityModelMCA.bodyData(dilation);
        ModelPartData root = modelData.getRoot();
        root.addChild("hat", ModelPartBuilder.create().uv(32, 0).cuboid(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, dilation.add(0.3f)), ModelTransform.NONE);
        return modelData;
    }

    public static ModelData bodyData(Dilation dilation) {
        return VillagerEntityModelMCA.bodyData(dilation, false);
    }

    public static ModelData bodyData(Dilation dilation, boolean slim) {
        ModelData modelData = PlayerEntityModelCompat.getTexturedModelData(dilation, slim);
        ModelPartData root = modelData.getRoot();
        root.addChild("breasts", VillagerEntityModelMCA.newBreasts(dilation, 0), ModelTransform.NONE);
        root.addChild(BREASTPLATE, VillagerEntityModelMCA.newBreasts(dilation.add(0.1f), 16), ModelTransform.NONE);
        return modelData;
    }

    @Override
    protected Iterable<class_630> method_22948() {
        return ImmutableList.of((Object)this.field_3391, (Object)this.field_3401, (Object)this.field_3390, (Object)this.field_3392, (Object)this.field_3397, (Object)this.bodyWear, (Object)this.leftLegwear, (Object)this.rightLegwear, (Object)this.leftArmwear, (Object)this.rightArmwear);
    }

    @Override
    public Iterable<class_630> getBreastParts() {
        return ImmutableList.of((Object)this.breasts, (Object)this.breastsWear);
    }

    @Override
    public void method_17087(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        super.method_17087(villager, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        this.leftLegwear.method_17138(this.field_3397);
        this.rightLegwear.method_17138(this.field_3392);
        this.leftArmwear.method_17138(this.field_3390);
        this.rightArmwear.method_17138(this.field_3401);
        this.bodyWear.method_17138(this.field_3391);
        this.breastsWear.method_17138(this.breasts);
    }

    public void method_2805(boolean visible) {
        super.method_2805(visible);
        this.leftArmwear.field_3665 = !this.wearsHidden && visible;
        this.rightArmwear.field_3665 = !this.wearsHidden && visible;
        this.leftLegwear.field_3665 = !this.wearsHidden && visible;
        this.rightLegwear.field_3665 = !this.wearsHidden && visible;
        this.bodyWear.field_3665 = !this.wearsHidden && visible;
    }

    public VillagerEntityModelMCA<T> hideWears() {
        this.wearsHidden = true;
        this.breastsWear.field_3665 = false;
        this.leftArmwear.field_3665 = false;
        this.rightArmwear.field_3665 = false;
        this.leftLegwear.field_3665 = false;
        this.rightLegwear.field_3665 = false;
        this.bodyWear.field_3665 = false;
        return this;
    }

    @Override
    public void method_2818(class_572<T> target) {
        super.method_2818(target);
        if (target instanceof VillagerEntityModelMCA) {
            this.copyAttributes((VillagerEntityModelMCA)target);
        }
    }

    private void copyAttributes(VillagerEntityModelMCA<T> target) {
        target.leftLegwear.method_17138(this.leftLegwear);
        target.rightLegwear.method_17138(this.rightLegwear);
        target.leftArmwear.method_17138(this.leftArmwear);
        target.rightArmwear.method_17138(this.rightArmwear);
        target.bodyWear.method_17138(this.bodyWear);
        target.breastsWear.method_17138(this.breastsWear);
    }
}

