/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai;

import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.entity.EntityWrapper;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.DialogueType;
import fabric.net.mca.entity.ai.relationship.family.FamilyTree;
import fabric.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import fabric.net.mca.resources.API;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_4051;
import net.minecraft.class_5250;

public interface Messenger
extends EntityWrapper {
    public static final class_4051 CAN_RECEIVE = new class_4051().method_18423();

    default public boolean isSpeechImpaired() {
        return false;
    }

    default public boolean isToYoungToSpeak() {
        return false;
    }

    default public void playSpeechEffect() {
    }

    default public DialogueType getDialogueType(class_1657 receiver) {
        return DialogueType.UNASSIGNED;
    }

    default public class_2588 getTranslatable(class_1657 target, String phraseId, Object ... params) {
        String targetName;
        if (target.field_6002 instanceof class_3218) {
            class_3218 world = (class_3218)target.field_6002;
            targetName = FamilyTree.get(world).getOrEmpty(target.method_5667()).map(FamilyTreeNode::getName).filter(n -> !MCA.isBlankString(n)).orElse(target.method_5477().getString());
        } else {
            targetName = target.method_5477().getString();
        }
        Object[] newParams = new Object[params.length + 1];
        System.arraycopy(params, 0, newParams, 1, params.length);
        newParams[0] = targetName;
        String professionString = "";
        if (!this.asEntity().method_6109() && this.asEntity() instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)this.asEntity();
            professionString = "#P" + class_2378.field_17167.method_10221((Object)v.getProfession()).method_12832() + ".";
        }
        String personalityString = "";
        if (!this.asEntity().method_6109() && this.asEntity() instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)this.asEntity();
            personalityString = "#E" + v.getVillagerBrain().getPersonality().name() + ".";
        }
        return new class_2588(personalityString + professionString + "#T" + this.getDialogueType(target).name() + "." + phraseId, newParams);
    }

    default public void sendChatToAllAround(String phrase, Object ... params) {
        for (class_1657 player : this.asEntity().field_6002.method_18464(CAN_RECEIVE, (class_1309)this.asEntity(), this.asEntity().method_5829().method_1014(20.0))) {
            float dist = player.method_5739((class_1297)this.asEntity());
            this.sendChatMessage(this.getTranslatable(player, phrase, params).method_27692(dist < 10.0f ? class_124.field_1068 : class_124.field_1080), (class_1297)player);
        }
    }

    default public void sendChatMessage(class_1657 target, String phraseId, Object ... params) {
        this.sendChatMessage((class_5250)this.getTranslatable(target, phraseId, params), (class_1297)target);
    }

    default public void sendChatMessage(class_5250 message, class_1297 receiver) {
        if (this.isSpeechImpaired()) {
            message = new class_2588(API.getRandomSentence("zombie", message.getString()));
        } else if (this.isToYoungToSpeak()) {
            message = new class_2588(API.getRandomSentence("baby", message.getString()));
        }
        receiver.method_9203((class_2561)new class_2585(Config.getInstance().villagerChatPrefix).method_10852(this.asEntity().method_5476()).method_27693(": ").method_10852((class_2561)message), this.asEntity().method_5667());
        this.playSpeechEffect();
    }

    default public void sendEventMessage(class_2561 message, class_1657 receiver) {
        receiver.method_7353(message, true);
    }

    default public void sendEventMessage(class_2561 message) {
        if (!(this instanceof class_1297)) {
            return;
        }
        Messenger.sendEventMessage(((class_1297)this).field_6002, message);
    }

    public static void sendEventMessage(class_1937 world, class_2561 message) {
        world.method_18456().forEach(player -> player.method_7353(message, true));
    }
}

