/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.interaction.gifts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fabric.net.mca.client.gui.Constraint;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.Chore;
import fabric.net.mca.entity.ai.LongTermMemory;
import fabric.net.mca.entity.ai.MoodGroup;
import fabric.net.mca.entity.ai.Traits;
import fabric.net.mca.entity.ai.relationship.AgeState;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.entity.ai.relationship.Personality;
import fabric.net.mca.resources.Rank;
import fabric.net.mca.resources.Tasks;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class GiftPredicate {
    public static final Map<String, Factory<JsonElement>> CONDITION_TYPES = new HashMap<String, Factory<JsonElement>>();
    private final int satisfactionBoost;
    @Nullable
    private final Condition condition;
    List<String> conditionKeys;

    public static float divideAndAdd(JsonObject json, long value) {
        return class_3532.method_15363((float)((float)value / (json.has("dividend") ? json.get("dividend").getAsFloat() : 1.0f) + (json.has("add") ? json.get("add").getAsFloat() : 0.0f)), (float)0.0f, (float)(json.has("max") ? json.get("max").getAsFloat() : 1.0f));
    }

    public static <T> void register(String name, BiFunction<JsonElement, String, T> jsonParser, Factory<T> predicate) {
        CONDITION_TYPES.put(name, json -> predicate.parse(jsonParser.apply((JsonElement)json, name)));
    }

    public static GiftPredicate fromJson(JsonObject json) {
        int satisfaction = 0;
        @Nullable Condition condition = null;
        LinkedList<String> conditionKeys = new LinkedList<String>();
        for (Map.Entry entry : json.entrySet()) {
            if ("satisfaction_boost".equals(entry.getKey())) {
                satisfaction = class_3518.method_15257((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                continue;
            }
            if (!CONDITION_TYPES.containsKey(entry.getKey())) continue;
            Condition parsed = CONDITION_TYPES.get(entry.getKey()).parse((JsonElement)entry.getValue());
            conditionKeys.add((String)entry.getKey());
            if (condition == null) {
                condition = parsed;
                continue;
            }
            condition = condition.and(parsed);
        }
        return new GiftPredicate(satisfaction, condition, conditionKeys);
    }

    public GiftPredicate(int satisfactionBoost, @Nullable Condition condition, List<String> conditionKeys) {
        this.satisfactionBoost = satisfactionBoost;
        this.condition = condition;
        this.conditionKeys = conditionKeys;
    }

    public float test(VillagerEntityMCA recipient, class_1799 stack, @Nullable class_3222 player) {
        return this.condition != null ? this.condition.test(recipient, stack, player) : 0.0f;
    }

    public int getSatisfactionFor(VillagerEntityMCA recipient, class_1799 stack, @Nullable class_3222 player) {
        return (int)(this.test(recipient, stack, player) * (float)this.satisfactionBoost);
    }

    public List<String> getConditionKeys() {
        return this.conditionKeys;
    }

    static {
        GiftPredicate.register("profession", (json, name) -> new class_2960(class_3518.method_15287((JsonElement)json, (String)name)), profession -> (villager, stack, player) -> class_2378.field_17167.method_10221((Object)villager.getProfession()).equals(profession) ? 1.0f : 0.0f);
        GiftPredicate.register("age_group", (json, name) -> AgeState.valueOf(class_3518.method_15287((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), group -> (villager, stack, player) -> villager.getAgeState() == group ? 1.0f : 0.0f);
        GiftPredicate.register("gender", (json, name) -> Gender.valueOf(class_3518.method_15287((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), gender -> (villager, stack, player) -> villager.getGenetics().getGender() == gender ? 1.0f : 0.0f);
        GiftPredicate.register("has_item", (json, name) -> class_1856.method_8102((JsonElement)json), item -> (villager, stack, player) -> {
            for (int i = 0; i < villager.method_18011().method_5439(); ++i) {
                if (!item.method_8093(villager.method_18011().method_5438(i))) continue;
                return 1.0f;
            }
            return 0.0f;
        });
        GiftPredicate.register("min_health", class_3518::method_15269, health -> (villager, stack, player) -> villager.method_6032() > health.floatValue() ? 1.0f : 0.0f);
        GiftPredicate.register("is_married", class_3518::method_15268, married -> (villager, stack, player) -> villager.getRelationships().isMarried() == married.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("has_home", class_3518::method_15268, hasHome -> (villager, stack, player) -> villager.getResidency().getHome().isPresent() == hasHome.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("has_village", class_3518::method_15268, hasVillage -> (villager, stack, player) -> villager.getResidency().getHomeVillage().isPresent() == hasVillage.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("min_infection_progress", class_3518::method_15269, progress -> (villager, stack, player) -> villager.getInfectionProgress() > progress.floatValue() ? 1.0f : 0.0f);
        GiftPredicate.register("mood", (json, name) -> class_3518.method_15287((JsonElement)json, (String)name).toLowerCase(Locale.ENGLISH), mood -> (villager, stack, player) -> villager.getVillagerBrain().getMood().getName().equals(mood) ? 1.0f : 0.0f);
        GiftPredicate.register("mood_group", (json, name) -> MoodGroup.valueOf(class_3518.method_15287((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), moodGroup -> (villager, stack, player) -> villager.getVillagerBrain().getPersonality().getMoodGroup() == moodGroup ? 1.0f : 0.0f);
        GiftPredicate.register("personality", (json, name) -> Personality.valueOf(class_3518.method_15287((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), personality -> (villager, stack, player) -> villager.getVillagerBrain().getPersonality() == personality ? 1.0f : 0.0f);
        GiftPredicate.register("is_pregnant", class_3518::method_15268, pregnant -> (villager, stack, player) -> villager.getRelationships().getPregnancy().isPregnant() == pregnant.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("min_pregnancy_progress", class_3518::method_15257, progress -> (villager, stack, player) -> villager.getRelationships().getPregnancy().getBabyAge() > progress ? 1.0f : 0.0f);
        GiftPredicate.register("pregnancy_child_gender", (json, name) -> Gender.valueOf(class_3518.method_15287((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), gender -> (villager, stack, player) -> villager.getRelationships().getPregnancy().getGender() == gender ? 1.0f : 0.0f);
        GiftPredicate.register("current_chore", (json, name) -> Chore.valueOf(class_3518.method_15287((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), chore -> (villager, stack, player) -> villager.getVillagerBrain().getCurrentJob() == chore ? 1.0f : 0.0f);
        GiftPredicate.register("item", (json, name) -> {
            class_2960 id = new class_2960(class_3518.method_15287((JsonElement)json, (String)name));
            class_1792 item = (class_1792)class_2378.field_11142.method_17966(id).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + id + "'"));
            return class_1856.method_8101((class_1799[])new class_1799[]{new class_1799((class_1935)item)});
        }, ingredient -> (villager, stack, player) -> ingredient.method_8093(stack) ? 1.0f : 0.0f);
        GiftPredicate.register("tag", (json, name) -> {
            class_2960 id = new class_2960(class_3518.method_15287((JsonElement)json, (String)name));
            class_3494.class_5123 tag = TagHooks.getItemOptional((class_2960)id);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + id + "'");
            }
            return class_1856.method_8106((class_3494)tag);
        }, ingredient -> (villager, stack, player) -> ingredient.method_8093(stack) ? 1.0f : 0.0f);
        GiftPredicate.register("trait", (json, name) -> Traits.Trait.valueOf(class_3518.method_15287((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), trait -> (villager, stack, player) -> villager.getTraits().hasTrait((Traits.Trait)((Object)trait)) ? 1.0f : 0.0f);
        GiftPredicate.register("hearts_min", class_3518::method_15257, hearts -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((class_1657)player).getHearts();
            return h >= hearts ? 1.0f : 0.0f;
        });
        GiftPredicate.register("hearts_max", class_3518::method_15257, hearts -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((class_1657)player).getHearts();
            return h <= hearts ? 1.0f : 0.0f;
        });
        GiftPredicate.register("hearts", class_3518::method_15295, json -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((class_1657)player).getHearts();
            return GiftPredicate.divideAndAdd(json, h);
        });
        GiftPredicate.register("memory", class_3518::method_15295, json -> (villager, stack, player) -> {
            String id = LongTermMemory.parseId(json, player);
            long ticks = villager.getLongTermMemory().getMemory(id);
            return GiftPredicate.divideAndAdd(json, ticks);
        });
        GiftPredicate.register("emeralds", class_3518::method_15257, amount -> (villager, stack, player) -> player != null && player.field_7514.method_18861(class_1802.field_8687) >= amount ? 1.0f : 0.0f);
        GiftPredicate.register("village_has_building", class_3518::method_15287, name -> (villager, stack, player) -> villager.getResidency().getHomeVillage().filter(v -> v.hasBuilding((String)name)).isPresent() ? 1.0f : 0.0f);
        GiftPredicate.register("rank", class_3518::method_15287, name -> (villager, stack, player) -> villager.getResidency().getHomeVillage().filter(v -> Tasks.getRank(v, player) == Rank.fromName(name)).isPresent() ? 1.0f : 0.0f);
        GiftPredicate.register("time_min", class_3518::method_15263, time -> (villager, stack, player) -> villager.field_6002.method_8532() % 24000L >= time ? 1.0f : 0.0f);
        GiftPredicate.register("time_max", class_3518::method_15263, time -> (villager, stack, player) -> villager.field_6002.method_8532() % 24000L <= time ? 1.0f : 0.0f);
        GiftPredicate.register("biome", (json, name) -> new class_2960(class_3518.method_15287((JsonElement)json, (String)name)), biome -> (villager, stack, player) -> {
            Optional biomeKey = villager.field_6002.method_31081(villager.method_24515());
            return biomeKey.filter(b -> b.method_29177().equals(biome)).map(result -> Float.valueOf(1.0f)).orElse(Float.valueOf(0.0f)).floatValue();
        });
        GiftPredicate.register("advancement", (json, name) -> new class_2960(class_3518.method_15287((JsonElement)json, (String)name)), id -> (villager, stack, player) -> {
            assert (player != null);
            class_161 advancement = Objects.requireNonNull(player.method_5682()).method_3851().method_12896(id);
            return player.method_14236().method_12882(advancement).method_740() ? 1.0f : 0.0f;
        });
        GiftPredicate.register("constraints", (json, name) -> Constraint.fromStringList(class_3518.method_15287((JsonElement)json, (String)name)), constraints -> (villager, stack, player) -> {
            Set<Constraint> c = Constraint.allMatching(villager, player);
            return c.containsAll((Collection<?>)constraints) ? 1.0f : 0.0f;
        });
    }

    public static interface Factory<T> {
        public Condition parse(T var1);
    }

    public static interface Condition {
        public float test(VillagerEntityMCA var1, class_1799 var2, @Nullable class_3222 var3);

        default public Condition and(Condition b) {
            Condition a = this;
            return (villager, stack, player) -> a.test(villager, stack, player) * b.test(villager, stack, player);
        }
    }
}

